/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.agile;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.AgileWriterResult;
import org.eclipse.osee.ats.api.agile.IAgileBacklog;
import org.eclipse.osee.ats.api.agile.IAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.IAgileItem;
import org.eclipse.osee.ats.api.agile.IAgileProgram;
import org.eclipse.osee.ats.api.agile.IAgileProgramBacklog;
import org.eclipse.osee.ats.api.agile.IAgileProgramBacklogItem;
import org.eclipse.osee.ats.api.agile.IAgileProgramFeature;
import org.eclipse.osee.ats.api.agile.IAgileService;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.agile.IAgileSprintHtmlOperation;
import org.eclipse.osee.ats.api.agile.IAgileStory;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.agile.JaxAgileBacklog;
import org.eclipse.osee.ats.api.agile.JaxAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.JaxAgileItem;
import org.eclipse.osee.ats.api.agile.JaxAgileProgramBacklog;
import org.eclipse.osee.ats.api.agile.JaxAgileProgramBacklogItem;
import org.eclipse.osee.ats.api.agile.JaxAgileProgramFeature;
import org.eclipse.osee.ats.api.agile.JaxAgileStory;
import org.eclipse.osee.ats.api.agile.JaxAgileTeam;
import org.eclipse.osee.ats.api.agile.JaxNewAgileTeam;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.data.enums.token.PointAttributeType;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.agile.AgileBacklog;
import org.eclipse.osee.ats.core.agile.AgileBacklogWriter;
import org.eclipse.osee.ats.core.agile.AgileFactory;
import org.eclipse.osee.ats.core.agile.AgileFeatureGroup;
import org.eclipse.osee.ats.core.agile.AgileFolders;
import org.eclipse.osee.ats.core.agile.AgileItemWriter;
import org.eclipse.osee.ats.core.agile.AgileProgram;
import org.eclipse.osee.ats.core.agile.AgileProgramBacklog;
import org.eclipse.osee.ats.core.agile.AgileProgramBacklogItem;
import org.eclipse.osee.ats.core.agile.AgileProgramFeature;
import org.eclipse.osee.ats.core.agile.AgileTeam;
import org.eclipse.osee.ats.core.agile.operations.AgileProgramOperations;
import org.eclipse.osee.ats.core.agile.operations.BacklogOperations;
import org.eclipse.osee.ats.core.agile.operations.SprintBurndownOperations;
import org.eclipse.osee.ats.core.agile.operations.SprintBurnupOperations;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.NamedComparator;
import org.eclipse.osee.framework.jdk.core.util.SortOrder;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;

public class AgileService
implements IAgileService {
    private final Log logger;
    private final AtsApi atsApi;

    public AgileService(Log logger, AtsApi atsApi) {
        this.logger = logger;
        this.atsApi = atsApi;
    }

    public String getPointsStr(IAtsWorkItem workItem) {
        AttributeTypeToken pointsAttrType = this.atsApi.getAgileService().getPointsAttrType(workItem);
        if (!this.atsApi.getAttributeResolver().isAttributeTypeValid(workItem, pointsAttrType)) {
            return "";
        }
        String ptsStr = this.atsApi.getAttributeResolver().getSoleAttributeValueAsString((IAtsObject)workItem, pointsAttrType, "");
        return ptsStr;
    }

    public AttributeTypeToken getPointsAttrType(IAtsTeamDefinition teamDef) {
        AttributeTypeGeneric pointsAttrType = AttributeTypeToken.SENTINEL;
        IAgileTeam agileTeam = this.atsApi.getAgileService().getAgileTeam(teamDef);
        if (agileTeam != null) {
            pointsAttrType = this.atsApi.getAgileService().getAgileTeamPointsAttributeType(agileTeam);
        }
        if (pointsAttrType.isInvalid()) {
            pointsAttrType = AtsAttributeTypes.PointsNumeric;
        }
        return pointsAttrType;
    }

    public AttributeTypeToken getPointsAttrType(IAtsWorkItem workItem) {
        IAgileTeam agileTeam;
        IAtsTeamWorkflow teamWf;
        AttributeTypeToken ptsAttrType;
        JaxAgileTeam aTeam;
        if (workItem.getWorkDefinition().getPointsAttrType().isValid()) {
            return workItem.getWorkDefinition().getPointsAttrType();
        }
        AttributeTypeGeneric pointsAttrType = AttributeTypeToken.SENTINEL;
        Long aTeamId = (Long)this.atsApi.getConfigService().getConfigurations().getTeamDefToAgileTeam().get(workItem.getParentTeamWorkflow().getTeamDefinition().getId());
        if (aTeamId != null && aTeamId > 0L && (aTeam = (JaxAgileTeam)this.atsApi.getConfigService().getConfigurations().getIdToAgileTeam().get(aTeamId)) != null && (ptsAttrType = aTeam.getPointsAttrType()).isValid()) {
            pointsAttrType = ptsAttrType;
        }
        if (pointsAttrType.isInvalid() && (teamWf = workItem.getParentTeamWorkflow()) != null && (agileTeam = this.atsApi.getAgileService().getAgileTeam((IAtsWorkItem)teamWf)) != null) {
            pointsAttrType = this.atsApi.getAgileService().getAgileTeamPointsAttributeType(agileTeam);
        }
        if (pointsAttrType.isInvalid()) {
            pointsAttrType = AtsAttributeTypes.PointsNumeric;
        }
        return pointsAttrType;
    }

    public IAgileTeam getAgileTeamById(ArtifactId agileTeamId) {
        AgileTeam program = null;
        if (agileTeamId instanceof AgileTeam) {
            program = (AgileTeam)agileTeamId;
        } else {
            ArtifactToken art = this.atsApi.getQueryService().getArtifact(agileTeamId);
            if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileTeam})) {
                program = new AgileTeam(this.atsApi.getLogger(), this.atsApi, art);
            }
        }
        return program;
    }

    public IAgileFeatureGroup getAgileFeatureGroupById(ArtifactId agileFeatureGroupId) {
        AgileFeatureGroup agileFeatureGroup = null;
        if (agileFeatureGroupId instanceof AgileFeatureGroup) {
            agileFeatureGroup = (AgileFeatureGroup)agileFeatureGroupId;
        } else {
            ArtifactToken art = this.atsApi.getQueryService().getArtifact(agileFeatureGroupId);
            if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileFeatureGroup})) {
                agileFeatureGroup = new AgileFeatureGroup(this.atsApi.getLogger(), this.atsApi, art);
            }
        }
        return agileFeatureGroup;
    }

    public IAgileProgram getAgileProgram(long programId) {
        IAgileProgram program = null;
        ArtifactToken progArt = this.atsApi.getQueryService().getArtifact(Long.valueOf(programId));
        if (progArt != null) {
            program = AgileProgram.construct((ArtifactId)progArt, this.atsApi);
        }
        return program;
    }

    public IAgileProgramFeature getAgileProgramFeature(long programFeatureId) {
        IAgileProgramFeature programFeature = null;
        ArtifactToken progArt = this.atsApi.getQueryService().getArtifact(Long.valueOf(programFeatureId));
        if (progArt != null) {
            programFeature = AgileProgramFeature.construct((ArtifactId)progArt, this.atsApi);
        }
        return programFeature;
    }

    public IAgileProgramFeature createAgileProgramFeature(long teamId, String name, String guid, Long id) {
        return AgileFactory.createAgileProgramFeature(this.logger, this.atsApi, teamId, name, guid, id);
    }

    public IAgileProgramBacklog getAgileProgramBacklog(IAgileProgram program) {
        IAgileProgramBacklog programBacklog = null;
        ArtifactToken programBacklogArt = this.getAgileProgramBacklogArt(program);
        if (programBacklogArt != null) {
            programBacklog = AgileProgramBacklog.construct((ArtifactId)programBacklogArt, this.atsApi);
        }
        return programBacklog;
    }

    public ArtifactToken getAgileProgramBacklogArt(IAgileProgram program) {
        ArtifactToken programBacklogArt = null;
        ArtifactToken programArt = this.atsApi.getQueryService().getArtifact(program.getId());
        if (programArt != null) {
            for (ArtifactToken child : this.atsApi.getRelationResolver().getChildren((ArtifactId)programArt)) {
                if (!child.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileProgramBacklog})) continue;
                programBacklogArt = child;
                break;
            }
        }
        return programBacklogArt;
    }

    public IAgileProgramBacklogItem getAgileProgramBacklogItem(long programBacklogItemId) {
        IAgileProgramBacklogItem programBacklogItem = null;
        ArtifactToken progBackItemArt = this.atsApi.getQueryService().getArtifact(Long.valueOf(programBacklogItemId));
        if (progBackItemArt != null) {
            programBacklogItem = AgileProgramBacklogItem.construct((ArtifactId)progBackItemArt, this.atsApi);
        }
        return programBacklogItem;
    }

    public IAgileTeam getAgileTeam(ArtifactId artifact) {
        return AgileFactory.getAgileTeam(this.logger, this.atsApi, artifact);
    }

    public IAgileTeam getAgileTeam(long id) {
        IAgileTeam team = null;
        ArtifactToken teamArt = this.atsApi.getQueryService().getArtifact(Long.valueOf(id));
        if (teamArt != null) {
            team = this.getAgileTeam((ArtifactId)teamArt);
        }
        return team;
    }

    public IAgileTeam getAgileTeamById(long teamId) {
        IAgileTeam team = null;
        ArtifactToken artifact = this.atsApi.getQueryService().getArtifact(Long.valueOf(teamId));
        if (artifact != null) {
            team = this.getAgileTeam((ArtifactId)artifact);
        }
        return team;
    }

    public IAgileTeam createAgileTeam(JaxNewAgileTeam newTeam) {
        return AgileFactory.createAgileTeam(this.logger, this.atsApi, newTeam);
    }

    public IAgileTeam updateAgileTeam(JaxAgileTeam team) {
        return AgileFactory.updateAgileTeam(this.logger, this.atsApi, team);
    }

    public void deleteAgileTeam(long id) {
        ArtifactToken team = this.atsApi.getQueryService().getArtifact(Long.valueOf(id));
        if (!team.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileTeam})) {
            throw new OseeArgumentException("ID %d is not a valid Agile Team", new Object[]{id});
        }
        IAtsChangeSet changes = this.atsApi.createChangeSet("Delete Agile Team");
        this.deleteRecurse(this.atsApi.getRelationResolver().getChildren((ArtifactId)team), changes);
        changes.deleteArtifact((ArtifactId)team);
        changes.execute();
    }

    private void deleteRecurse(Collection<ArtifactToken> resultSet, IAtsChangeSet changes) {
        for (ArtifactId artifactId : resultSet) {
            this.deleteRecurse(this.atsApi.getRelationResolver().getChildren(artifactId), changes);
            changes.deleteArtifact(artifactId);
        }
    }

    public Collection<IAgileTeam> getTeams() {
        ArrayList<IAgileTeam> teams = new ArrayList<IAgileTeam>();
        for (ArtifactId teamArt : this.atsApi.getQueryService().createQuery(new ArtifactTypeToken[]{AtsArtifactTypes.AgileTeam}).getArtifacts()) {
            teams.add(this.getAgileTeam(teamArt));
        }
        return teams;
    }

    public AttributeTypeToken getAgileTeamPointsAttributeType(IAgileTeam team) {
        PointAttributeType type = AtsAttributeTypes.Points;
        String attrTypeName = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)team, (AttributeTypeToken)AtsAttributeTypes.PointsAttributeType, null);
        if (Strings.isValid((String)attrTypeName)) {
            type = this.getTypeFromName(attrTypeName);
        }
        return type;
    }

    private AttributeTypeToken getTypeFromName(String attrTypeName) {
        AttributeTypeToken type = null;
        for (AttributeTypeToken attrType : this.atsApi.getStoreService().getAttributeTypes()) {
            if (!attrType.getName().equals(attrTypeName)) continue;
            type = attrType;
            break;
        }
        if (type == null) {
            throw new OseeCoreException("Invalid attribute type name provided: %s", new Object[]{attrTypeName});
        }
        return type;
    }

    public IAgileTeam getAgileTeam(IAtsTeamDefinition teamDef) {
        IAgileTeam aTeam = null;
        ArtifactToken aTeamArt = this.atsApi.getRelationResolver().getRelatedOrSentinel((IAtsObject)teamDef, AtsRelationTypes.AgileTeamToAtsTeam_AgileTeam);
        if (aTeamArt.isValid()) {
            aTeam = this.atsApi.getAgileService().getAgileTeam((ArtifactId)aTeamArt);
        }
        return aTeam;
    }

    public IAgileTeam getAgileTeam(IAgileSprint sprint) {
        IAgileTeam aTeam = null;
        ArtifactToken aTeamArt = this.atsApi.getRelationResolver().getRelatedOrSentinel((IAtsObject)sprint, AtsRelationTypes.AgileTeamToSprint_AgileTeam);
        if (aTeamArt.isValid()) {
            aTeam = this.atsApi.getAgileService().getAgileTeam((ArtifactId)aTeamArt);
        }
        return aTeam;
    }

    public IAgileTeam getAgileTeamByName(String agileTeamName) {
        IAgileTeam aTeam = null;
        ArtifactToken aTeamArt = this.atsApi.getQueryService().getArtifactByNameOrSentinel(AtsArtifactTypes.AgileTeam, agileTeamName);
        if (aTeamArt.isValid()) {
            aTeam = this.atsApi.getAgileService().getAgileTeam((ArtifactId)aTeamArt);
        }
        return aTeam;
    }

    public Set<AtsUser> getTeamMebers(IAgileTeam agileTeam) {
        HashSet<AtsUser> activeMembers = new HashSet<AtsUser>();
        for (ArtifactToken user : this.atsApi.getRelationResolver().getRelated((IAtsObject)agileTeam, CoreRelationTypes.Users_User)) {
            activeMembers.add(this.atsApi.getUserService().getUserById((ArtifactId)user));
        }
        for (ArtifactToken atsTeam : this.atsApi.getRelationResolver().getRelated((IAtsObject)agileTeam, AtsRelationTypes.AgileTeamToAtsTeam_AtsTeam)) {
            for (ArtifactToken user : this.atsApi.getRelationResolver().getRelated((ArtifactId)atsTeam, AtsRelationTypes.TeamMember_Member)) {
                if (!((Boolean)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)user, (AttributeTypeToken)CoreAttributeTypes.Active, (Object)true)).booleanValue()) continue;
                activeMembers.add(this.atsApi.getUserService().getUserById((ArtifactId)user));
            }
            for (ArtifactToken user : this.atsApi.getRelationResolver().getRelated((ArtifactId)atsTeam, AtsRelationTypes.TeamLead_Lead)) {
                if (!((Boolean)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)user, (AttributeTypeToken)CoreAttributeTypes.Active, (Object)true)).booleanValue()) continue;
                activeMembers.add(this.atsApi.getUserService().getUserById((ArtifactId)user));
            }
        }
        return activeMembers;
    }

    public IAgileFeatureGroup getAgileFeatureGroup(ArtifactId artifact) {
        return AgileFactory.getAgileFeatureGroup(this.logger, this.atsApi, artifact);
    }

    public void deleteAgileFeatureGroup(long id) {
        ArtifactToken featureGroup = this.atsApi.getQueryService().getArtifact(Long.valueOf(id));
        if (!featureGroup.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileFeatureGroup})) {
            throw new OseeArgumentException("ID %d is not a valid Agile Feature Group", new Object[]{id});
        }
        IAtsChangeSet changes = this.atsApi.createChangeSet("Delete Agile Feature Group");
        changes.deleteArtifact((ArtifactId)featureGroup);
        changes.execute();
    }

    public IAgileFeatureGroup createAgileFeatureGroup(long teamId, String name, String guid, Long id) {
        return AgileFactory.createAgileFeatureGroup(this.logger, this.atsApi, teamId, name, guid, id);
    }

    public IAgileFeatureGroup createAgileFeatureGroup(JaxAgileFeatureGroup newFeatureGroup) {
        return AgileFactory.createAgileFeatureGroup(this.logger, this.atsApi, newFeatureGroup);
    }

    public Collection<IAgileFeatureGroup> getAgileFeatureGroups(IAgileTeam team) {
        LinkedList<IAgileFeatureGroup> groups = new LinkedList<IAgileFeatureGroup>();
        ArtifactToken artifact = team.getStoreObject();
        for (ArtifactId groupArt : this.atsApi.getRelationResolver().getRelated((ArtifactId)artifact, AtsRelationTypes.AgileTeamToFeatureGroup_AgileFeatureGroup)) {
            groups.add(this.atsApi.getAgileService().getAgileFeatureGroup(groupArt));
        }
        return groups;
    }

    public IAgileBacklog getBacklogForTeam(long teamId) {
        IAgileBacklog backlog = null;
        ArtifactToken teamArt = this.atsApi.getQueryService().getArtifact(Long.valueOf(teamId));
        ArtifactToken backlogArt = this.atsApi.getRelationResolver().getRelatedOrSentinel((ArtifactId)teamArt, AtsRelationTypes.AgileTeamToBacklog_Backlog);
        if (backlogArt.isValid()) {
            backlog = this.getAgileBacklog((ArtifactId)backlogArt);
        }
        return backlog;
    }

    public IAgileSprint getAgileSprint(ArtifactId artifact) {
        return AgileFactory.getAgileSprint(this.logger, this.atsApi, artifact);
    }

    public IAgileSprint getAgileSprint(long id) {
        return this.getAgileSprint(ArtifactId.valueOf((Long)id));
    }

    public IAgileSprint createAgileSprint(long teamId, String name, Long id) {
        return AgileFactory.createAgileSprint(this.logger, this.atsApi, teamId, name, id);
    }

    public Collection<IAgileSprint> getSprintsForTeam(long teamId) {
        ArrayList<IAgileSprint> sprints = new ArrayList<IAgileSprint>();
        ArtifactToken team = this.atsApi.getQueryService().getArtifact(Long.valueOf(teamId));
        for (ArtifactId sprintArt : this.atsApi.getRelationResolver().getRelated((ArtifactId)team, AtsRelationTypes.AgileTeamToSprint_Sprint)) {
            sprints.add(this.getAgileSprint(sprintArt));
        }
        return sprints;
    }

    public Collection<IAgileSprint> getAgileSprints(IAgileTeam team) {
        LinkedList<IAgileSprint> sprints = new LinkedList<IAgileSprint>();
        ArtifactToken artifact = team.getStoreObject();
        for (ArtifactToken sprintArt : this.atsApi.getRelationResolver().getRelated((ArtifactId)artifact, AtsRelationTypes.AgileTeamToSprint_Sprint)) {
            sprints.add(this.atsApi.getWorkItemService().getAgileSprint(sprintArt));
        }
        return sprints;
    }

    public IAgileBacklog getAgileBacklog(ArtifactId artifact) {
        return AgileFactory.getAgileBacklog(this.logger, this.atsApi, artifact);
    }

    public IAgileBacklog getAgileBacklog(IAgileTeam team) {
        if (team == null) {
            return null;
        }
        ArtifactId teamFolder = AgileFolders.getTeamFolder(this.atsApi, team.getId());
        if (teamFolder == null) {
            return null;
        }
        ArtifactToken backlogArt = this.atsApi.getRelationResolver().getRelatedOrSentinel(teamFolder, AtsRelationTypes.AgileTeamToBacklog_Backlog);
        if (backlogArt.isInvalid()) {
            return null;
        }
        return new AgileBacklog(this.logger, this.atsApi, backlogArt);
    }

    public IAgileBacklog getAgileBacklog(long id) {
        IAgileBacklog backlog = null;
        ArtifactToken teamArt = this.atsApi.getQueryService().getArtifact(Long.valueOf(id));
        if (teamArt != null) {
            backlog = this.getAgileBacklog((ArtifactId)teamArt);
        }
        return backlog;
    }

    public IAgileBacklog createAgileBacklog(long teamId, String name, Long id) {
        return AgileFactory.createAgileBacklog(this.logger, this.atsApi, teamId, name, id);
    }

    public IAgileBacklog updateAgileBacklog(JaxAgileBacklog updatedBacklog) {
        AgileBacklogWriter writer = new AgileBacklogWriter(this.atsApi, this, updatedBacklog);
        return writer.write();
    }

    public AgileWriterResult updateAgileItem(JaxAgileItem newItem) {
        AgileItemWriter writer = new AgileItemWriter(this.atsApi, this, newItem);
        return writer.write();
    }

    public Collection<IAgileFeatureGroup> getAgileFeatureGroups(List<Long> ids) {
        LinkedList<IAgileFeatureGroup> features = new LinkedList<IAgileFeatureGroup>();
        for (ArtifactId featureArt : this.atsApi.getQueryService().getArtifacts(ids)) {
            features.add(this.atsApi.getAgileService().getAgileFeatureGroup(featureArt));
        }
        return features;
    }

    public Collection<IAgileItem> getItems(IAgileBacklog backlog) {
        return this.getItems((IAtsObject)backlog, AtsRelationTypes.Goal_Member);
    }

    private Collection<IAgileItem> getItems(IAtsObject backlogOrSprint, RelationTypeSide relationType) {
        LinkedList<IAgileItem> items = new LinkedList<IAgileItem>();
        ArtifactToken backlogArt = backlogOrSprint.getStoreObject();
        for (ArtifactToken art : this.atsApi.getRelationResolver().getRelated((ArtifactId)backlogArt, relationType)) {
            if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AbstractWorkflowArtifact})) {
                IAgileItem agileItem = this.atsApi.getWorkItemService().getAgileItem(art);
                items.add(agileItem);
                continue;
            }
            throw new OseeStateException("Inavlid artifact [%s] in [%s].  Only workflows are allowed, not [%s]", new Object[]{art.toStringWithId(), backlogOrSprint, art.getArtifactType()});
        }
        return items;
    }

    public Collection<IAgileItem> getItems(IAgileSprint sprint) {
        return this.getItems((IAtsObject)sprint, AtsRelationTypes.AgileSprintToItem_AtsItem);
    }

    public Collection<IAgileFeatureGroup> getFeatureGroups(IAgileItem aItem) {
        LinkedList<IAgileFeatureGroup> groups = new LinkedList<IAgileFeatureGroup>();
        ArtifactToken itemArt = this.atsApi.getQueryService().getArtifact((IAtsObject)aItem);
        for (ArtifactId featureGroup : this.atsApi.getRelationResolver().getRelated((ArtifactId)itemArt, AtsRelationTypes.AgileFeatureToItem_AgileFeatureGroup)) {
            groups.add(this.atsApi.getAgileService().getAgileFeatureGroup(featureGroup));
        }
        return groups;
    }

    public Collection<IAgileFeatureGroup> getFeatureGroups(IAtsWorkItem workItem) {
        LinkedList<IAgileFeatureGroup> groups = new LinkedList<IAgileFeatureGroup>();
        ArtifactToken itemArt = this.atsApi.getQueryService().getArtifact((IAtsObject)workItem);
        for (ArtifactId featureGroup : this.atsApi.getRelationResolver().getRelated((ArtifactId)itemArt, AtsRelationTypes.AgileFeatureToItem_AgileFeatureGroup)) {
            groups.add(this.atsApi.getAgileService().getAgileFeatureGroup(featureGroup));
        }
        return groups;
    }

    public IAgileSprint getSprint(IAgileItem item) {
        IAgileSprint sprint = null;
        ArtifactToken itemArt = this.atsApi.getQueryService().getArtifact((IAtsObject)item);
        ArtifactToken sprintArt = this.atsApi.getRelationResolver().getRelatedOrSentinel((ArtifactId)itemArt, AtsRelationTypes.AgileSprintToItem_AgileSprint);
        if (sprintArt.isValid()) {
            sprint = this.atsApi.getWorkItemService().getAgileSprint(sprintArt);
        }
        return sprint;
    }

    public IAgileSprint getSprint(IAtsWorkItem workItem) {
        IAgileSprint sprint = null;
        ArtifactToken itemArt = this.atsApi.getQueryService().getArtifact((IAtsObject)workItem);
        ArtifactToken sprintArt = this.atsApi.getRelationResolver().getRelatedOrSentinel((ArtifactId)itemArt, AtsRelationTypes.AgileSprintToItem_AgileSprint);
        if (sprintArt.isValid()) {
            sprint = this.atsApi.getWorkItemService().getAgileSprint(sprintArt);
        }
        return sprint;
    }

    public void deleteSprint(long sprintId) {
        ArtifactToken sprint = this.atsApi.getQueryService().getArtifact(Long.valueOf(sprintId));
        if (sprint != null) {
            IAtsChangeSet changes = this.atsApi.createChangeSet("Delete Agile Sprint");
            changes.deleteArtifact((ArtifactId)sprint);
            changes.execute();
        }
    }

    public IAgileTeam getAgileTeam(IAgileItem item) {
        ArtifactToken teamArt;
        ArtifactToken teamArt2;
        ArtifactToken itemArt = this.atsApi.getQueryService().getArtifact((IAtsObject)item);
        ArtifactToken backlogArt = this.atsApi.getRelationResolver().getRelatedOrSentinel((ArtifactId)itemArt, AtsRelationTypes.Goal_Member);
        if (backlogArt.isValid() && (teamArt2 = this.atsApi.getRelationResolver().getRelatedOrSentinel((ArtifactId)backlogArt, AtsRelationTypes.AgileTeamToBacklog_AgileTeam)).isValid()) {
            return this.atsApi.getAgileService().getAgileTeam((ArtifactId)teamArt2);
        }
        ArtifactToken sprintArt = this.atsApi.getRelationResolver().getRelatedOrSentinel((ArtifactId)itemArt, AtsRelationTypes.AgileSprintToItem_AgileSprint);
        if (sprintArt.isValid() && (teamArt = this.atsApi.getRelationResolver().getRelatedOrSentinel((ArtifactId)sprintArt, AtsRelationTypes.AgileTeamToSprint_AgileTeam)).isValid()) {
            return this.atsApi.getAgileService().getAgileTeam((ArtifactId)teamArt);
        }
        return null;
    }

    public ArtifactToken getRelatedBacklogArt(IAtsWorkItem workItem) {
        ArtifactToken relatedBacklogArt = null;
        for (ArtifactToken backlogArt : this.atsApi.getRelationResolver().getRelated((IAtsObject)workItem, AtsRelationTypes.Goal_Goal)) {
            if (!this.isBacklog(backlogArt)) continue;
            relatedBacklogArt = backlogArt;
        }
        return relatedBacklogArt;
    }

    public boolean isBacklog(Object object) {
        boolean backlog = false;
        if (object instanceof IAtsWorkItem) {
            backlog = this.atsApi.getRelationResolver().getRelatedCount((IAtsWorkItem)object, AtsRelationTypes.AgileTeamToBacklog_AgileTeam) == 1;
        } else if (object instanceof ArtifactToken) {
            backlog = this.atsApi.getRelationResolver().getRelatedCount((ArtifactToken)object, AtsRelationTypes.AgileTeamToBacklog_AgileTeam) == 1;
        }
        return backlog;
    }

    public boolean isSprint(ArtifactToken artifact) {
        return artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileSprint});
    }

    public Collection<ArtifactToken> getRelatedSprints(ArtifactId artifact) {
        HashSet<ArtifactToken> sprints = new HashSet<ArtifactToken>();
        for (ArtifactToken sprintArt : this.atsApi.getRelationResolver().getRelatedArtifacts(artifact, AtsRelationTypes.AgileSprintToItem_AgileSprint)) {
            sprints.add(sprintArt);
        }
        return sprints;
    }

    public String getAgileTeamPointsStr(IAtsWorkItem workItem) {
        String result = this.atsApi.getAttributeResolver().getSoleAttributeValueAsString((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.Points, "");
        if (Strings.isInValid((String)result)) {
            Double pts = (Double)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.PointsNumeric, (Object)0.0);
            result = pts == 0.0 ? "" : pts.toString();
        }
        return result;
    }

    public IAgileTeam getAgileTeam(IAtsWorkItem workItem) {
        IAgileTeam agileTeam = null;
        IAtsTeamWorkflow teamWf = workItem.getParentTeamWorkflow();
        if (teamWf != null) {
            IAgileSprint sprint;
            ArtifactToken sprintArt;
            ArtifactToken agileTeamArt;
            IAtsTeamDefinition teamDef = teamWf.getTeamDefinition();
            if (teamDef != null && (agileTeamArt = this.atsApi.getRelationResolver().getRelatedOrSentinel((IAtsObject)teamDef, AtsRelationTypes.AgileTeamToAtsTeam_AgileTeam)).isValid()) {
                agileTeam = this.atsApi.getAgileService().getAgileTeam((ArtifactId)agileTeamArt);
            }
            if (agileTeam == null && (sprintArt = this.atsApi.getRelationResolver().getRelatedOrSentinel((IAtsObject)workItem, AtsRelationTypes.AgileSprintToItem_AgileSprint)).isValid() && (sprint = this.getAgileSprint((ArtifactId)sprintArt)) != null) {
                agileTeam = this.atsApi.getAgileService().getAgileTeamFromSprint(sprint);
            }
            if (agileTeam == null) {
                for (ArtifactToken goalArt : this.atsApi.getRelationResolver().getRelated((IAtsObject)workItem, AtsRelationTypes.Goal_Goal)) {
                    IAgileBacklog backlog;
                    if (!goalArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Goal}) || (backlog = this.getAgileBacklog((ArtifactId)goalArt)) == null) continue;
                    agileTeam = this.atsApi.getAgileService().getAgileTeamFromBacklog(backlog);
                }
            }
        }
        return agileTeam;
    }

    public IAgileTeam getAgileTeamFromSprint(IAgileSprint sprint) {
        IAgileTeam agileTeam = null;
        ArtifactToken agileTeamArt = this.atsApi.getRelationResolver().getRelatedOrSentinel((IAtsObject)sprint, AtsRelationTypes.AgileTeamToSprint_AgileTeam);
        if (agileTeamArt.isValid()) {
            agileTeam = this.atsApi.getAgileService().getAgileTeam((ArtifactId)agileTeamArt);
        }
        return agileTeam;
    }

    public IAgileTeam getAgileTeamFromBacklog(IAgileBacklog backlog) {
        IAgileTeam agileTeam = null;
        ArtifactToken agileBacklogArt = this.atsApi.getRelationResolver().getRelatedOrSentinel((IAtsObject)backlog, AtsRelationTypes.AgileTeamToBacklog_AgileTeam);
        if (agileBacklogArt.isValid()) {
            agileTeam = this.atsApi.getAgileService().getAgileTeam((ArtifactId)agileBacklogArt);
        }
        return agileTeam;
    }

    public XResultData storeSprintReports(long teamId, long sprintId) {
        XResultData results = new XResultData();
        results.setTitle("Store Sprint Reports");
        IAtsChangeSet changes = this.atsApi.createChangeSet("Store Agile Sprint Reports");
        IAgileSprint sprint = this.getAgileSprint((ArtifactId)this.atsApi.getQueryService().getArtifact(Long.valueOf(sprintId)));
        AgileService.createUpdateBurnChart(new SprintBurndownOperations(this.atsApi), teamId, sprintId, this.atsApi, changes, sprint);
        AgileService.createUpdateBurnChart(new SprintBurnupOperations(this.atsApi), teamId, sprintId, this.atsApi, changes, sprint);
        for (IAgileSprintHtmlOperation operation : this.atsApi.getAgileSprintHtmlReportOperations()) {
            AgileService.createUpdateBurnChart(operation, teamId, sprintId, this.atsApi, changes, sprint);
        }
        changes.executeIfNeeded();
        return results;
    }

    public static void createUpdateBurnChart(IAgileSprintHtmlOperation operation, long teamId, long sprintId, AtsApi atsApi, IAtsChangeSet changes, IAgileSprint sprint) {
        String html = operation.getReportHtml(teamId, sprintId);
        ArtifactToken burndownArt = atsApi.getRelationResolver().getChildNamedOrNull((IAtsObject)sprint, operation.getReportType().name());
        if (burndownArt == null) {
            burndownArt = changes.createArtifact(CoreArtifactTypes.GeneralDocument, operation.getReportType().name());
            changes.setSoleAttributeValue((ArtifactId)burndownArt, (AttributeTypeToken)CoreAttributeTypes.Extension, (Object)"html");
            changes.addChild((ArtifactId)sprint.getStoreObject(), (ArtifactId)burndownArt);
        }
        try {
            changes.setSoleAttributeValue((ArtifactId)burndownArt, (AttributeTypeToken)CoreAttributeTypes.NativeContent, (Object)Lib.stringToInputStream((String)html));
        }
        catch (UnsupportedEncodingException ex) {
            throw new OseeArgumentException((Throwable)ex, "Error trying to store Agile " + operation.getReportType(), new Object[0]);
        }
    }

    public Collection<IAtsTeamDefinition> getAtsTeams(IAgileTeam aTeam) {
        LinkedList<IAtsTeamDefinition> teamDefs = new LinkedList<IAtsTeamDefinition>();
        for (ArtifactId teamArt : this.atsApi.getRelationResolver().getRelated((ArtifactId)aTeam.getStoreObject(), AtsRelationTypes.AgileTeamToAtsTeam_AtsTeam)) {
            teamDefs.add((IAtsTeamDefinition)this.atsApi.getQueryService().getConfigItem(teamArt));
        }
        return teamDefs;
    }

    public IAgileProgram createAgileProgram(IAgileProgram agileProgram) {
        AgileProgramOperations ops = new AgileProgramOperations(this.atsApi);
        IAgileProgram program = ops.createAgileProgram(agileProgram);
        return program;
    }

    public IAgileProgramFeature createAgileProgramFeature(IAgileProgramBacklogItem programBacklogItem, JaxAgileProgramFeature jaxFeature) {
        AgileProgramOperations ops = new AgileProgramOperations(this.atsApi);
        IAgileProgramFeature feature = ops.createAgileProgramFeature(programBacklogItem, jaxFeature);
        if (feature == null) {
            throw new OseeCoreException("In AgileService.createAgileProgramFeature, the local variable \"feature\" is null which gets returned", new Object[0]);
        }
        return feature;
    }

    public void setAgileStory(IAtsTeamWorkflow teamWf, IAgileStory story, IAtsChangeSet changes) {
        changes.unrelateFromAll(AtsRelationTypes.AgileStoryToItem_AgileStory, (ArtifactId)teamWf.getStoreObject());
        changes.relate((Object)story, AtsRelationTypes.AgileStoryToItem_TeamWorkflow, (Object)teamWf);
    }

    public IAgileStory createAgileStory(IAgileProgramFeature feature, JaxAgileStory jaxStory) {
        AgileProgramOperations ops = new AgileProgramOperations(this.atsApi);
        IAgileStory story = ops.createAgileStory(feature, jaxStory);
        return story;
    }

    public IAgileProgramBacklog createAgileProgramBacklog(IAgileProgram agileProgram, JaxAgileProgramBacklog jaxProgramBacklog) {
        AgileProgramOperations ops = new AgileProgramOperations(this.atsApi);
        IAgileProgramBacklog progBacklog = ops.createAgileProgramBacklog(agileProgram, jaxProgramBacklog);
        return progBacklog;
    }

    public IAgileProgramBacklogItem createAgileProgramBacklogItem(IAgileProgramBacklog programBacklog, JaxAgileProgramBacklogItem jaxProgramBacklogItem) {
        AgileProgramOperations ops = new AgileProgramOperations(this.atsApi);
        IAgileProgramBacklogItem progBacklogItem = ops.createAgileProgramBacklogItem(programBacklog, jaxProgramBacklogItem);
        return progBacklogItem;
    }

    public List<ArtifactToken> getTeamMembersOrdered(IAgileTeam aTeam) {
        Set activeTeamMembers = this.atsApi.getAgileService().getTeamMebers(aTeam);
        LinkedList<ArtifactToken> results = new LinkedList<ArtifactToken>();
        for (AtsUser user : activeTeamMembers) {
            results.add(ArtifactToken.valueOf((ArtifactId)user.getStoreObject(), (String)user.getName()));
        }
        Collections.sort(results, new NamedComparator(SortOrder.ASCENDING));
        results.add((ArtifactToken)SystemUser.UnAssigned);
        return results;
    }

    public List<ArtifactToken> getOtherMembersOrdered(IAgileTeam aTeam) {
        List<ArtifactToken> activeTeamMembers = this.getTeamMembersOrdered(aTeam);
        LinkedList<ArtifactToken> results = new LinkedList<ArtifactToken>();
        for (AtsUser user : this.atsApi.getUserService().getUsers()) {
            if (user.equals((Object)AtsCoreUsers.UNASSIGNED_USER) || !user.isActive() || activeTeamMembers.contains(user.getStoreObject())) continue;
            results.add(user.getStoreObject());
        }
        Collections.sort(results, new NamedComparator(SortOrder.ASCENDING));
        return results;
    }

    public String getAgileFeatureGroupStr(IAtsWorkItem workItem) {
        return AtsObjects.toString(",", this.getFeatureGroups(workItem));
    }

    public IAgileSprint getSprint(IAtsTeamWorkflow teamWf) {
        ArtifactToken sprintArt = this.atsApi.getRelationResolver().getRelatedOrSentinel((IAtsObject)teamWf, AtsRelationTypes.AgileSprintToItem_AgileSprint);
        if (sprintArt.isValid()) {
            return this.atsApi.getAgileService().getAgileSprint((ArtifactId)sprintArt);
        }
        return null;
    }

    public void setSprint(IAtsTeamWorkflow teamWf, IAgileSprint sprint, IAtsChangeSet changes) {
        IAgileSprint currSprint = this.atsApi.getAgileService().getSprint(teamWf);
        if (currSprint != null) {
            changes.unrelate((IAtsObject)currSprint, AtsRelationTypes.AgileSprintToItem_AtsItem, (IAtsObject)teamWf);
        }
        if (sprint != null) {
            changes.relate((Object)sprint, AtsRelationTypes.AgileSprintToItem_AtsItem, (Object)teamWf);
        }
    }

    public XResultData sortAgileBacklog(ArtifactToken backlog, String comment) {
        BacklogOperations ops = new BacklogOperations(this.atsApi);
        return ops.sort(backlog, comment);
    }
}

