/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.access;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.access.IAtsAccessContextProvider;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.core.access.AtsAccessContextProvider;
import org.eclipse.osee.ats.core.access.AtsArtifactChecks;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.ats.core.task.TaskAutoGenArtifactChecks;
import org.eclipse.osee.framework.core.access.AccessControlUtil;
import org.eclipse.osee.framework.core.access.ArtifactCheck;
import org.eclipse.osee.framework.core.access.IOseeAccessProvider;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;

public class AtsOseeAccessProvider
implements IOseeAccessProvider {
    private final Collection<IAtsAccessContextProvider> providers = new ArrayList<IAtsAccessContextProvider>();
    private AtsAccessContextProvider defaultAtsAccessProvider;
    public static Collection<ArtifactCheck> artChecks = null;

    public AtsOseeAccessProvider() {
        AccessControlUtil.errorf((String)this.getClass().getSimpleName(), (Object[])new Object[0]);
        this.getDefaultAtsAccessProvider();
    }

    public void addAtsAccessProvider(IAtsAccessContextProvider provider) {
        this.providers.add(provider);
    }

    public boolean isApplicable(ArtifactToken user, Object object) {
        AtsUser atsUser = AtsApiService.get().getUserService().getUserById((ArtifactId)user);
        for (IAtsAccessContextProvider provider : this.providers) {
            if (!provider.isApplicable(atsUser, object)) continue;
            return true;
        }
        return this.getDefaultAtsAccessProvider().isApplicable(atsUser, object);
    }

    public XResultData hasArtifactContextWriteAccess(ArtifactToken user, Collection<? extends ArtifactToken> artifacts, XResultData rd) {
        AtsUser atsUser = AtsApiService.get().getUserService().getUserById((ArtifactId)user);
        for (ArtifactToken artifactToken : artifacts) {
            boolean found = false;
            for (IAtsAccessContextProvider provider : this.providers) {
                if (!provider.isApplicable(atsUser, (Object)artifactToken)) continue;
                provider.hasArtifactContextWriteAccess(atsUser, artifacts, rd);
                found = true;
                break;
            }
            if (found) continue;
            this.getDefaultAtsAccessProvider().hasArtifactContextWriteAccess(atsUser, artifacts, rd);
        }
        return rd;
    }

    public XResultData hasAttributeTypeContextWriteAccess(ArtifactToken user, Collection<? extends ArtifactToken> artifacts, AttributeTypeToken attributeType, XResultData rd) {
        AtsUser atsUser = AtsApiService.get().getUserService().getUserById((ArtifactId)user);
        for (ArtifactToken artifactToken : artifacts) {
            boolean found = false;
            for (IAtsAccessContextProvider provider : this.providers) {
                if (!provider.isApplicable(atsUser, (Object)artifactToken)) continue;
                provider.hasAttributeTypeContextWriteAccess(atsUser, artifacts, attributeType, rd);
                found = true;
                break;
            }
            if (found) continue;
            this.getDefaultAtsAccessProvider().hasAttributeTypeContextWriteAccess(atsUser, artifacts, attributeType, rd);
        }
        return rd;
    }

    public XResultData hasRelationContextWriteAccess(ArtifactToken user, ArtifactToken artifact, RelationTypeToken relationType, XResultData rd) {
        AtsUser atsUser = AtsApiService.get().getUserService().getUserById((ArtifactId)user);
        boolean found = false;
        for (IAtsAccessContextProvider provider : this.providers) {
            if (!provider.isApplicable(atsUser, (Object)artifact)) continue;
            provider.hasRelationContextWriteAccess(atsUser, artifact, relationType, rd);
            found = true;
            break;
        }
        if (!found) {
            this.getDefaultAtsAccessProvider().hasRelationContextWriteAccess(atsUser, artifact, relationType, rd);
        }
        return rd;
    }

    public IAtsAccessContextProvider getDefaultAtsAccessProvider() {
        if (this.defaultAtsAccessProvider == null) {
            this.defaultAtsAccessProvider = new AtsAccessContextProvider();
        }
        AtsApi atsApi = AtsApiService.get();
        this.defaultAtsAccessProvider.setAtsApi(atsApi);
        return this.defaultAtsAccessProvider;
    }

    public Collection<ArtifactCheck> getArtifactChecks() {
        if (artChecks == null) {
            artChecks = Arrays.asList(new AtsArtifactChecks(), new TaskAutoGenArtifactChecks());
        }
        return artChecks;
    }
}

