/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.util;

import java.util.Objects;

public class PublishingTemplateMatchCriterion {
    private final String option;
    private final String presentationType;
    private final String rendererIdentifier;

    public PublishingTemplateMatchCriterion(String rendererIdentifier, String presentationType) {
        this(rendererIdentifier, presentationType, null);
    }

    public PublishingTemplateMatchCriterion(String rendererIdentifier, String presentationType, String option) {
        Objects.requireNonNull(rendererIdentifier, "SetupPublishing.PublishingTemplateMatchCriterion::new, parameter \"rendererIdentifier\" cannot be null.");
        if (rendererIdentifier.isBlank()) {
            throw new IllegalArgumentException("SetupPublishing.PublishingTemplateMatchCriterion::new, parameter \"rendererIdentifier\" cannot be blank.");
        }
        Objects.requireNonNull(presentationType, "SetupPublishing.PublishingTemplateMatchCriterion::new, parameter \"presentationType\" cannot be null.");
        if (presentationType.isBlank()) {
            throw new IllegalArgumentException("SetupPublishing.PublishingTemplateMatchCriterion::new, parameter \"presentationType\" cannot be blank.");
        }
        if (Objects.nonNull(option) && option.isBlank()) {
            throw new IllegalArgumentException("SetupPublishing.PublishingTemplateMatchCriterion::new, parameter \"option\" cannot be blank.");
        }
        this.rendererIdentifier = rendererIdentifier;
        this.presentationType = presentationType;
        this.option = option;
    }

    public String getTemplateMatchCriteria() {
        StringBuilder matchCriteria = new StringBuilder(this.rendererIdentifier.length() + this.presentationType.length() + (Objects.nonNull(this.option) ? this.option.length() : 0) + 8).append(this.rendererIdentifier).append(" ").append(this.presentationType);
        if (Objects.nonNull(this.option)) {
            matchCriteria.append(" ").append(this.option);
        }
        return matchCriteria.toString();
    }
}

