/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.applicability.ApplicabilityUseResultToken;
import org.eclipse.osee.framework.core.applicability.FeatureDefinition;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.CoreTupleTypes;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.NamedComparator;
import org.eclipse.osee.framework.jdk.core.util.SortOrder;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.core.ds.ApplicabilityDsQuery;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.search.ApplicabilityQuery;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.search.TransactionQuery;
import org.eclipse.osee.orcs.search.TupleQuery;

public class ApplicabilityQueryImpl
implements ApplicabilityQuery {
    private final TupleQuery tupleQuery;
    private final ApplicabilityDsQuery applicabilityDsQuery;
    private final TransactionQuery transactionQuery;
    private final BranchQuery branchQuery;
    private final QueryFactory queryFactory;
    private final OrcsApi orcsApi;

    public ApplicabilityQueryImpl(ApplicabilityDsQuery applicabilityDsQuery, QueryFactory queryFactory, OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
        this.tupleQuery = queryFactory.tupleQuery();
        this.applicabilityDsQuery = applicabilityDsQuery;
        this.transactionQuery = queryFactory.transactionQuery();
        this.branchQuery = queryFactory.branchQuery();
        this.queryFactory = queryFactory;
    }

    public ApplicabilityToken getApplicabilityToken(ArtifactId artId, BranchId branch) {
        return this.applicabilityDsQuery.getApplicabilityToken(artId, branch);
    }

    public List<Pair<ArtifactId, ApplicabilityToken>> getApplicabilityTokens(List<? extends ArtifactId> artIds, BranchId branch) {
        return this.applicabilityDsQuery.getApplicabilityTokens(artIds, branch);
    }

    public HashMap<Long, ApplicabilityToken> getApplicabilityTokens(BranchId branch) {
        HashMap<Long, ApplicabilityToken> tokens = new HashMap<Long, ApplicabilityToken>();
        BiConsumer<Long, String> consumer = (id, name) -> {
            ApplicabilityToken applicabilityToken = tokens.put((Long)id, new ApplicabilityToken(id, name));
        };
        this.tupleQuery.getTuple2UniqueE2Pair(CoreTupleTypes.ApplicabilityDefinition, branch, consumer);
        if (tokens.isEmpty()) {
            tokens.put(ApplicabilityToken.BASE.getId(), ApplicabilityToken.BASE);
        }
        return tokens;
    }

    public Collection<ApplicabilityToken> getApplicabilityTokens(BranchId branch, boolean orderByName, String filter, Long pageNum, Long pageSize) {
        LinkedList<ApplicabilityToken> tokens = new LinkedList<ApplicabilityToken>();
        BiConsumer<Long, String> consumer = (id, name) -> {
            boolean bl = tokens.add(new ApplicabilityToken(id, name));
        };
        this.tupleQuery.getTuple2UniqueE2Pair(CoreTupleTypes.ApplicabilityDefinition, branch, orderByName, filter, pageNum, pageSize, consumer);
        if (tokens.isEmpty()) {
            tokens.add(ApplicabilityToken.BASE);
        }
        return tokens;
    }

    public HashMap<Long, ApplicabilityToken> getApplicabilityTokens(BranchId branch1, BranchId branch2) {
        HashMap<Long, ApplicabilityToken> tokens = new HashMap<Long, ApplicabilityToken>();
        BiConsumer<Long, String> consumer = (id, name) -> {
            ApplicabilityToken applicabilityToken = tokens.put((Long)id, new ApplicabilityToken(id, name));
        };
        this.tupleQuery.getTuple2UniqueE2Pair(CoreTupleTypes.ApplicabilityDefinition, branch1, consumer);
        this.tupleQuery.getTuple2UniqueE2Pair(CoreTupleTypes.ApplicabilityDefinition, branch2, consumer);
        return tokens;
    }

    public Long getApplicabilityTokenCount(BranchId branch, String filter) {
        return this.tupleQuery.getTuple2UniqueE2PairCount(CoreTupleTypes.ApplicabilityDefinition, branch, filter);
    }

    public List<ApplicabilityId> getApplicabilitiesReferenced(ArtifactId artifact, BranchId branch) {
        LinkedList<ApplicabilityId> appIds = new LinkedList<ApplicabilityId>();
        Iterable existingAppIds = this.tupleQuery.getTuple2(CoreTupleTypes.ArtifactReferenceApplicabilityType, branch, (Object)artifact);
        for (ApplicabilityId tuple2 : existingAppIds) {
            appIds.add(tuple2);
        }
        return appIds;
    }

    public List<ApplicabilityToken> getApplicabilityReferenceTokens(ArtifactId artifact, BranchId branch) {
        LinkedList<ApplicabilityToken> tokens = new LinkedList<ApplicabilityToken>();
        this.tupleQuery.getTuple2NamedId(CoreTupleTypes.ArtifactReferenceApplicabilityType, branch, (Object)artifact, (e2, value) -> {
            boolean bl = tokens.add(ApplicabilityToken.valueOf((long)e2, (String)value));
        });
        return tokens;
    }

    public List<ApplicabilityToken> getViewApplicabilityTokens(ArtifactId artId, BranchId branch) {
        return this.getViewApplicabilityTokens(artId, branch, "");
    }

    public List<ApplicabilityToken> getViewApplicabilityTokens(ArtifactId artId, BranchId branch, String productType) {
        ArrayList<ApplicabilityToken> result = new ArrayList<ApplicabilityToken>();
        BiConsumer<Long, String> consumer = (id, name) -> {
            boolean bl = result.add(new ApplicabilityToken(id, name));
        };
        this.tupleQuery.getTuple2KeyValuePair(CoreTupleTypes.ViewApplicability, (Object)artId, branch, consumer);
        if (!productType.isEmpty()) {
            ArrayList productTypeApps = new ArrayList();
            BiConsumer<Long, String> consumer2 = (id, name) -> {
                boolean bl = productTypeApps.add(new ApplicabilityToken(id, name));
            };
            for (FeatureDefinition featureDefinition : this.getFeatureDefinitionData(branch, productType)) {
                this.tupleQuery.getTuple2KeyValuePair(CoreTupleTypes.ApplicabilityDefinition, (Object)ArtifactId.valueOf((Long)featureDefinition.getId()), branch, consumer2);
            }
            List<ApplicabilityToken> intersect = result.stream().filter(productTypeApps::contains).collect(Collectors.toList());
            intersect.addAll(result.stream().filter(a -> a.getName().startsWith("Config =") || a.getName().equals("Base") || a.getName().startsWith("ConfigurationGroup =")).collect(Collectors.toList()));
            return intersect;
        }
        return result;
    }

    public List<FeatureDefinition> getFeatureDefinitionData(BranchId branch, String productType) {
        BranchId branchToUse = branch;
        Branch br = (Branch)((BranchQuery)this.branchQuery.andId(branch)).getResults().getExactlyOne();
        if (br.getBranchType().equals((Object)BranchType.MERGE)) {
            branchToUse = br.getParentBranch();
        }
        ArrayList<FeatureDefinition> featureDefinition = new ArrayList<FeatureDefinition>();
        QueryBuilder query = this.queryFactory.fromBranch(branchToUse).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.Feature});
        if (!productType.isEmpty()) {
            query = query.andAttributeIs((AttributeTypeToken)CoreAttributeTypes.ProductApplicability, productType);
        }
        List featureArts = query.asArtifacts();
        Collections.sort(featureArts, new NamedComparator(SortOrder.ASCENDING));
        for (ArtifactToken featureArt : featureArts) {
            ArtifactReadable art = (ArtifactReadable)featureArt;
            FeatureDefinition feature = new FeatureDefinition();
            feature.setId(art.getId());
            feature.setName(art.getName());
            feature.setDefaultValue((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.DefaultValue, (Object)""));
            feature.setValues(art.getAttributeValues((AttributeTypeToken)CoreAttributeTypes.Value));
            feature.setValueType(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.FeatureValueType, ""));
            feature.setMultiValued(((Boolean)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.FeatureMultivalued, (Object)false)).booleanValue());
            feature.setDescription(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Description, ""));
            feature.setData((Object)featureArt);
            feature.setProductApplicabilities(art.getAttributeValues((AttributeTypeToken)CoreAttributeTypes.ProductApplicability));
            featureDefinition.add(feature);
        }
        return featureDefinition;
    }

    public List<FeatureDefinition> getFeatureDefinitionData(BranchId branch) {
        return this.getFeatureDefinitionData(branch, "");
    }

    public Map<String, List<String>> getNamedViewApplicabilityMap(BranchId branch, ArtifactId viewId) {
        TreeMap<String, List<String>> toReturn = new TreeMap<String, List<String>>();
        List<ApplicabilityToken> appTokens = this.getViewApplicabilityTokens(viewId, branch);
        for (ApplicabilityToken app : appTokens) {
            String[] split;
            if (app.getName().equalsIgnoreCase("Base") || app.getName().contains("|") || app.getName().contains("&") || app.getName().toLowerCase().startsWith("Config =") || (split = app.getName().split("=")).length != 2) continue;
            String name = split[0].trim();
            String value = split[1].trim();
            if (toReturn.containsKey(name)) {
                ArrayList<String> list = new ArrayList<String>();
                list.addAll((Collection)toReturn.get(name));
                list.add(value);
                toReturn.put(name, list);
                continue;
            }
            toReturn.put(name, Arrays.asList(value));
        }
        return toReturn;
    }

    public boolean applicabilityExistsOnBranchView(BranchId branch, ArtifactId viewId, String applicability) {
        ArrayList tuples = new ArrayList();
        this.queryFactory.tupleQuery().getTuple2GammaFromE1E2(CoreTupleTypes.ViewApplicability, branch, (Object)viewId, (Object)applicability, tuples::add);
        return !tuples.isEmpty();
    }

    public String getExistingFeatureApplicability(BranchId branch, ArtifactId viewId, String featureName) {
        String existingAppl = "";
        for (String appl : this.queryFactory.tupleQuery().getTuple2(CoreTupleTypes.ViewApplicability, branch, (Object)viewId)) {
            if (!(appl.startsWith(String.valueOf(featureName) + " =") & !appl.contains("|") & !appl.contains("&"))) continue;
            existingAppl = appl;
        }
        return existingAppl;
    }

    public List<ArtifactId> getBranchViewsForApplicability(BranchId branch, ApplicabilityId applId) {
        ArrayList<ArtifactId> arts = new ArrayList<ArtifactId>();
        for (Long long1 : this.queryFactory.tupleQuery().getTuple2E1ListRaw(CoreTupleTypes.ViewApplicability, branch, applId.getId())) {
            arts.add(ArtifactId.valueOf((Long)long1));
        }
        return arts;
    }

    public boolean featureExistsOnBranch(BranchId branch, String featureName) {
        if (ApplicabilityToken.BASE.getName().equals(featureName)) {
            return true;
        }
        ArtifactId feature = this.queryFactory.fromBranch(branch).andTypeEquals(new ArtifactTypeToken[]{CoreArtifactTypes.Feature}).andAttributeIs((AttributeTypeToken)CoreAttributeTypes.Name, featureName).asArtifactIdOrSentinel();
        boolean returnValue = feature.isValid();
        return returnValue;
    }

    public boolean featureValueIsValid(BranchId branch, String featureName, String featureValue) {
        return true;
    }

    public List<ArtifactReadable> getViewsForBranch(BranchId branch) {
        List views = this.queryFactory.fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.BranchView}).asArtifacts();
        List cfgGrps = this.queryFactory.fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.PlCfgGroupsFolder).asArtifacts();
        if (!cfgGrps.isEmpty()) {
            views.addAll(cfgGrps);
        }
        return views;
    }

    public List<ArtifactReadable> getViewsForBranch(BranchId branch, AttributeTypeToken orderByAttributeType) {
        List views = this.queryFactory.fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.BranchView}).setOrderByAttribute(orderByAttributeType).asArtifacts();
        List cfgGrps = this.queryFactory.fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.PlCfgGroupsFolder).asArtifacts();
        if (!cfgGrps.isEmpty()) {
            views.addAll(cfgGrps);
        }
        return views;
    }

    public List<ArtifactReadable> getConfigurationsForBranch(BranchId branch) {
        return this.queryFactory.fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.BranchView}).asArtifacts();
    }

    public List<ArtifactReadable> getConfigurationGroupsForBranch(BranchId branch) {
        List views = this.queryFactory.fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.GroupArtifact}).andRelatedTo(CoreRelationTypes.DefaultHierarchical_Parent, (ArtifactId)CoreArtifactTokens.PlCfgGroupsFolder).asArtifacts();
        return views;
    }

    public boolean viewExistsOnBranch(BranchId branch, ArtifactId viewId) {
        Boolean returnValue = false;
        for (ArtifactToken artifactToken : this.getViewsForBranch(branch)) {
            if (!artifactToken.equals(viewId)) continue;
            returnValue = true;
            break;
        }
        return returnValue;
    }

    public ArtifactToken getViewByName(BranchId branch, String viewName) {
        ArtifactToken viewToken = ArtifactToken.SENTINEL;
        for (ArtifactToken artifactToken : this.getViewsForBranch(branch)) {
            if (!artifactToken.getName().equals(viewName)) continue;
            viewToken = artifactToken;
            break;
        }
        return viewToken;
    }

    public String getViewTable(BranchId branch, String filter, ArtifactId view) {
        return this.getConfigMatrix(branch, "all", filter, view);
    }

    private void printTable(StringBuilder html, List<ArtifactToken> branchViews, BranchId branch, String filter, ArtifactId viewId) {
        html.append("<table border=\"1\">");
        if (Strings.isValid((String)filter)) {
            branchViews.removeIf(art -> art.getName().matches(filter));
        }
        if (viewId.isValid()) {
            branchViews.removeIf(art -> !art.getId().equals(viewId.getId()));
        }
        List<FeatureDefinition> featureDefinitionData = this.getFeatureDefinitionData(branch);
        Collections.sort(featureDefinitionData, new Comparator<FeatureDefinition>(){

            @Override
            public int compare(FeatureDefinition obj1, FeatureDefinition obj2) {
                return obj1.getName().compareTo(obj2.getName());
            }
        });
        this.printColumnHeadings(html, branchViews, branch);
        HashMap<ArtifactId, Map<String, List<String>>> branchViewsMap = new HashMap<ArtifactId, Map<String, List<String>>>();
        for (ArtifactId artifactId : branchViews) {
            branchViewsMap.put(artifactId, this.getNamedViewApplicabilityMap(branch, artifactId));
        }
        for (FeatureDefinition featureDefinition : featureDefinitionData) {
            html.append("<tr>");
            html.append(String.format("<td>%s</td>", featureDefinition.getName()));
            html.append(String.format("<td>%s</td>", featureDefinition.getDescription()));
            for (ArtifactId artifactId : branchViews) {
                List list = (List)((Map)branchViewsMap.get(artifactId)).get(featureDefinition.getName());
                if (list != null) {
                    html.append("<td>" + org.eclipse.osee.framework.jdk.core.util.Collections.toString((String)",", (Iterable)list) + "</td>");
                    continue;
                }
                html.append("<td> </td>");
            }
            html.append("</tr>");
        }
        html.append("</table>");
    }

    public String getConfigMatrix(BranchId branch, String matrixType, String filter, ArtifactId viewId) {
        StringBuilder html = this.getHtmlStart();
        List<Object> branchViews = new ArrayList();
        if (matrixType.equals("configs")) {
            html.append(String.format("<h3>Configurations Feature Matrix for branch: %s</h3>", ((Branch)((BranchQuery)this.branchQuery.andId(branch)).getResults().getExactlyOne()).getName()));
            branchViews = this.getConfigurationsForBranch(branch);
            this.printTable(html, branchViews.stream().map(a -> a.getToken()).collect(Collectors.toList()), branch, filter, viewId);
        } else if (matrixType.equals("groups")) {
            html.append(String.format("<h3>Configuration Groups Feature Matrix for branch: %s</h3>", ((Branch)((BranchQuery)this.branchQuery.andId(branch)).getResults().getExactlyOne()).getName()));
            branchViews = this.getConfigurationGroupsForBranch(branch);
            this.printTable(html, branchViews.stream().map(a -> a.getToken()).collect(Collectors.toList()), branch, filter, viewId);
        } else if (matrixType.equals("all")) {
            html.append(String.format("<h3>Configurations and Groups Feature Matrix for branch: %s</h3>", ((Branch)((BranchQuery)this.branchQuery.andId(branch)).getResults().getExactlyOne()).getName()));
            branchViews = this.getViewsForBranch(branch);
            this.printTable(html, branchViews.stream().map(a -> a.getToken()).collect(Collectors.toList()), branch, filter, viewId);
        } else {
            html.append(String.format("<h3>Configuration Groups Feature Matrix for branch: %s</h3>", ((Branch)((BranchQuery)this.branchQuery.andId(branch)).getResults().getExactlyOne()).getName()));
            branchViews = this.getConfigurationGroupsForBranch(branch);
            this.printTable(html, branchViews.stream().map(a -> a.getToken()).collect(Collectors.toList()), branch, filter, viewId);
            html.append(String.format("<h3>Configurations Feature Matrix for branch: %s</h3>", ((Branch)((BranchQuery)this.branchQuery.andId(branch)).getResults().getExactlyOne()).getName()));
            branchViews = this.getConfigurationsForBranch(branch);
            this.printTable(html, branchViews.stream().map(a -> a.getToken()).collect(Collectors.toList()), branch, filter, viewId);
        }
        html.append("</body></html>");
        return html.toString();
    }

    private StringBuilder getHtmlStart() {
        StringBuilder html = new StringBuilder("<!DOCTYPE html><html><head><style> table { border-spacing: 0px } th,td { padding: 3px; } </style></head><body>");
        return html;
    }

    private void printColumnHeadings(StringBuilder html, List<ArtifactToken> branchViews, BranchId branch) {
        html.append("<tr>");
        html.append("<th>Feature Name</th>");
        html.append("<th>Feature Description</th>");
        for (ArtifactToken artId : branchViews) {
            html.append(String.format("<th>%s</th>", artId.getName()));
        }
        html.append("</tr>");
    }

    public List<BranchId> getAffectedBranches(Long injectDateMs, Long removalDateMs, List<ApplicabilityId> applicabilityIds, BranchId branch) {
        ArrayList<BranchId> toReturn = new ArrayList<BranchId>();
        if (injectDateMs == null || removalDateMs == null || applicabilityIds == null) {
            return toReturn;
        }
        Date injection = new Date(injectDateMs);
        Date removal = new Date(removalDateMs);
        List branchList = ((BranchQuery)((BranchQuery)this.branchQuery.andIsOfType(new BranchType[]{BranchType.BASELINE})).andIsChildOf(branch)).getResults().getList();
        HashMap<Long, ApplicabilityId> applicabilityIdsMap = new HashMap<Long, ApplicabilityId>();
        for (ApplicabilityId applicId : applicabilityIds) {
            applicabilityIdsMap.put(applicId.getId(), applicId);
        }
        for (Branch baseBranch : branchList) {
            Date baseDate = ((TransactionReadable)((TransactionQuery)this.transactionQuery.andTxId(baseBranch.getBaselineTx())).getResults().getExactlyOne()).getDate();
            if (!baseDate.after(injection) || removalDateMs != -1L && !baseDate.before(removal)) continue;
            block2: for (ArtifactId artifactId : this.getViewsForBranch((BranchId)baseBranch)) {
                List<ApplicabilityToken> viewApplicabilityTokens = this.getViewApplicabilityTokens(artifactId, (BranchId)baseBranch);
                for (ApplicabilityToken applicToken : viewApplicabilityTokens) {
                    if (!applicabilityIdsMap.containsKey(applicToken.getId())) continue;
                    toReturn.add(BranchId.create((Long)baseBranch.getId(), (ArtifactId)artifactId));
                    continue block2;
                }
            }
        }
        return toReturn;
    }

    public List<BranchId> getAffectedBranches(TransactionId injectionTx, TransactionId removalTx, List<ApplicabilityId> applicabilityIds, BranchId branch) {
        long timeInjectionMs = ((TransactionReadable)((TransactionQuery)this.transactionQuery.andTxId(injectionTx)).getResults().getExactlyOne()).getDate().getTime();
        long timeRemovalMs = removalTx.isInvalid() ? -1L : ((TransactionReadable)((TransactionQuery)this.transactionQuery.andTxId(removalTx)).getResults().getExactlyOne()).getDate().getTime();
        return this.getAffectedBranches(timeInjectionMs, timeRemovalMs, applicabilityIds, branch);
    }

    public Set<ArtifactId> getExcludedArtifacts(BranchId branch, ArtifactId view) {
        return this.applicabilityDsQuery.getExcludedArtifacts(branch, view);
    }

    public List<ApplicabilityUseResultToken> getApplicabilityUsage(BranchId branch, String applic, List<ArtifactTypeToken> arts, List<AttributeTypeToken> attrs) {
        ArrayList<ApplicabilityUseResultToken> result = new ArrayList<ApplicabilityUseResultToken>();
        Collection<ApplicabilityToken> allApps = this.getApplicabilityTokens(branch).values();
        if (applic.equals("all")) {
            allApps.removeIf(a -> a.equals((Object)ApplicabilityToken.BASE));
            for (ApplicabilityToken appToken : allApps) {
                this.searchApplicUsage(branch, result, arts, attrs, appToken);
            }
        } else {
            ApplicabilityToken appToken = allApps.stream().filter(a -> a.getName().equals(applic)).findFirst().get();
            if (appToken.isValid()) {
                this.searchApplicUsage(branch, result, arts, attrs, appToken);
            }
        }
        return result;
    }

    private void searchApplicUsage(BranchId branch, List<ApplicabilityUseResultToken> result, List<ArtifactTypeToken> arts, List<AttributeTypeToken> attrs, ApplicabilityToken appToken) {
        String applic = appToken.getName();
        String featureName = "";
        String configName = "";
        ArrayList<String> searchStrings = new ArrayList<String>();
        if (applic.startsWith("Config")) {
            configName = applic.substring(applic.indexOf("=") + 1);
            searchStrings.add("Configuration[" + configName + "]");
            searchStrings.add("Configuration[" + configName + " |");
            searchStrings.add("| " + configName + "]");
            searchStrings.add("Configuration Not[" + configName + "]");
            searchStrings.add("Configuration Not[" + configName + " |");
        } else {
            searchStrings.add("Feature[" + applic + "]");
            if (!applic.contains("|")) {
                searchStrings.add("Feature[" + applic + " |");
                searchStrings.add("| " + applic + "]");
                if (applic.contains("Included")) {
                    featureName = applic.substring(0, applic.indexOf("=") - 1);
                    searchStrings.add("Feature[" + featureName + "]");
                    searchStrings.add("Feature[" + featureName + " |");
                    searchStrings.add("| " + featureName + "]");
                }
            }
        }
        HashSet artSet = new HashSet();
        List attrTypes = attrs.stream().map(a -> a).collect(Collectors.toList());
        artSet.addAll(this.orcsApi.getQueryFactory().fromBranch(branch, (ApplicabilityId)appToken).includeApplicabilityTokens().asArtifacts());
        for (String str : searchStrings) {
            artSet.addAll(this.orcsApi.getQueryFactory().fromBranch(branch).includeApplicabilityTokens().andIsOfType(arts).and(attrTypes, str, new QueryOption[]{QueryOption.TOKEN_COUNT__MATCH, QueryOption.TOKEN_MATCH_ORDER__MATCH}).asArtifacts());
        }
        result.add(new ApplicabilityUseResultToken(appToken, artSet));
    }
}

