/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.relation.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSets;
import org.eclipse.osee.orcs.core.internal.artifact.Artifact;
import org.eclipse.osee.orcs.core.internal.graph.GraphAdjacencies;
import org.eclipse.osee.orcs.core.internal.relation.Relation;
import org.eclipse.osee.orcs.core.internal.relation.RelationVisitor;
import org.eclipse.osee.orcs.core.internal.util.AbstractTypeCollection;
import org.eclipse.osee.orcs.core.internal.util.OrcsPredicates;

public class RelationNodeAdjacencies
extends AbstractTypeCollection<RelationTypeToken, Relation, RelationTypeToken, Relation>
implements GraphAdjacencies {
    @Override
    protected ResultSet<Relation> createResultSet(List<Relation> values) {
        return ResultSets.newResultSet(values);
    }

    @Override
    protected <T extends Relation> ResultSet<T> createResultSet(RelationTypeToken type, List<T> values) {
        return ResultSets.newResultSet(values);
    }

    @Override
    protected Relation asMatcherData(Relation data) {
        return data;
    }

    @Override
    protected RelationTypeToken getType(Relation data) {
        return data.getRelationType();
    }

    public List<Relation> getList(RelationTypeToken type, DeletionFlag includeDeleted) {
        Predicate deletionFlagEquals = OrcsPredicates.deletionFlagEquals(includeDeleted);
        return this.getListByFilter(type, deletionFlagEquals);
    }

    public List<Relation> getList(RelationTypeToken relationType, DeletionFlag includeDeleted, ArtifactId id, RelationSide side) {
        Predicate deletionFlagEquals = OrcsPredicates.deletionFlagEquals(includeDeleted);
        Predicate<Relation> relIdOnSide = OrcsPredicates.nodeIdOnSideEquals(id, side);
        Predicate matcher = Predicates.and(deletionFlagEquals, relIdOnSide);
        return this.getListByFilter(relationType, matcher);
    }

    public ResultSet<Relation> getResultSet(RelationTypeToken type, DeletionFlag includeDeleted) {
        Predicate deletionFlagEquals = OrcsPredicates.deletionFlagEquals(includeDeleted);
        return this.getSetByFilter(type, deletionFlagEquals);
    }

    public ResultSet<Relation> getResultSet(RelationTypeToken type, DeletionFlag includeDeleted, ArtifactId id, RelationSide side) {
        Predicate deletionFlagEquals = OrcsPredicates.deletionFlagEquals(includeDeleted);
        Predicate<Relation> relIdOnSide = OrcsPredicates.nodeIdOnSideEquals(id, side);
        Predicate matcher = Predicates.and(deletionFlagEquals, relIdOnSide);
        return this.getSetByFilter(type, matcher);
    }

    public Relation getRelation(Artifact aNode, RelationTypeToken type, Artifact bNode, DeletionFlag excludeDeleted) {
        Predicate<Relation> nodeMatcher = OrcsPredicates.nodeIdsEquals((ArtifactId)aNode, (ArtifactId)bNode);
        Predicate deletionFlagEquals = OrcsPredicates.deletionFlagEquals(excludeDeleted);
        Predicate matcher = Predicates.and(deletionFlagEquals, nodeMatcher);
        List listByFilter = this.getListByFilter(type, matcher);
        return listByFilter.isEmpty() ? null : (Relation)listByFilter.get(0);
    }

    public Relation getRelation(ArtifactId artIdA, RelationTypeToken relationType, ArtifactId artIdB) {
        Predicate<Relation> nodeMatcher = OrcsPredicates.nodeIdsEquals(artIdA, artIdB);
        List listByFilter = this.getListByFilter(relationType, nodeMatcher);
        return listByFilter.isEmpty() ? null : (Relation)listByFilter.get(0);
    }

    public Relation getRelation(ArtifactId artIdA, RelationTypeToken relationType, ArtifactId artIdB, int relOrder, DeletionFlag excludeDeleted) {
        Predicate<Relation> nodeMatcher = OrcsPredicates.nodeIdsAndRelOrderEquals(artIdA, artIdB, relOrder);
        Predicate deletionFlagEquals = OrcsPredicates.deletionFlagEquals(excludeDeleted);
        Predicate matcher = Predicates.and(deletionFlagEquals, nodeMatcher);
        List listByFilter = this.getListByFilter(relationType, matcher);
        return listByFilter.isEmpty() ? null : (Relation)listByFilter.get(0);
    }

    public void accept(RelationVisitor visitor) {
        for (Relation relation : this.getAll()) {
            visitor.visit(relation);
        }
    }
}

