/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.relation.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.core.enums.TxCurrent;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSets;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.RelationData;
import org.eclipse.osee.orcs.core.internal.artifact.Artifact;
import org.eclipse.osee.orcs.core.internal.graph.GraphData;
import org.eclipse.osee.orcs.core.internal.relation.Relation;
import org.eclipse.osee.orcs.core.internal.relation.RelationFactory;
import org.eclipse.osee.orcs.core.internal.relation.RelationManager;
import org.eclipse.osee.orcs.core.internal.relation.RelationResolver;
import org.eclipse.osee.orcs.core.internal.relation.RelationTypeValidity;
import org.eclipse.osee.orcs.core.internal.relation.RelationVisitor;
import org.eclipse.osee.orcs.core.internal.relation.impl.RelationNodeAdjacencies;
import org.eclipse.osee.orcs.core.internal.relation.order.OrderChange;
import org.eclipse.osee.orcs.core.internal.relation.order.OrderManager;
import org.eclipse.osee.orcs.core.internal.relation.order.OrderManagerFactory;
import org.eclipse.osee.orcs.core.internal.search.QueryModule;
import org.eclipse.osee.orcs.core.internal.transaction.TxData;
import org.eclipse.osee.orcs.core.internal.util.OrcsConditions;

public class RelationManagerImpl
implements RelationManager {
    private final Log logger;
    private final RelationTypeValidity validity;
    private final RelationResolver resolver;
    private final RelationFactory relationFactory;
    private final OrderManagerFactory orderFactory;

    public RelationManagerImpl(Log logger, RelationTypeValidity validity, RelationResolver resolver, RelationFactory relationFactory, OrderManagerFactory orderFactory, QueryModule.QueryModuleProvider queryProvider) {
        this.logger = logger;
        this.validity = validity;
        this.resolver = resolver;
        this.relationFactory = relationFactory;
        this.orderFactory = orderFactory;
    }

    @Override
    public int getMaximumRelationAllowed(RelationTypeToken type, Artifact node, RelationSide side) {
        Conditions.checkNotNull((Object)node, (String)"node");
        return this.validity.getMaximumRelationsAllowed(type, node.getArtifactType(), side);
    }

    @Override
    public Collection<RelationTypeToken> getValidRelationTypes(Artifact node) {
        Conditions.checkNotNull((Object)node, (String)"node");
        return this.validity.getValidRelationTypes(node.getArtifactType());
    }

    @Override
    public void accept(GraphData graph, Artifact node, RelationVisitor visitor) {
        OrcsConditions.checkOnGraph(graph, node);
        this.ensureRelationsInitialized(graph, node);
        RelationNodeAdjacencies container = (RelationNodeAdjacencies)graph.getAdjacencies((ArtifactId)node);
        if (container != null) {
            container.accept(visitor);
        } else {
            this.logger.warn("Unable to find relation container for [%s]", new Object[]{node.getExceptionString()});
        }
    }

    @Override
    public boolean hasDirtyRelations(Artifact node) {
        GraphData graph = node.getGraph();
        this.ensureRelationsInitialized(graph, node);
        RelationNodeAdjacencies container = (RelationNodeAdjacencies)graph.getAdjacencies((ArtifactId)node);
        return container != null ? container.hasDirty() : false;
    }

    @Override
    public Collection<RelationTypeToken> getExistingRelationTypes(Artifact node) {
        Conditions.checkNotNull((Object)node, (String)"node");
        GraphData graph = node.getGraph();
        this.ensureRelationsInitialized(graph, node);
        RelationNodeAdjacencies container = (RelationNodeAdjacencies)graph.getAdjacencies((ArtifactId)node);
        Collection<RelationTypeToken> toReturn = null;
        if (container != null) {
            toReturn = container.getExistingTypes(DeletionFlag.EXCLUDE_DELETED);
        } else {
            this.logger.warn("Unable to find relation container for [%s]", new Object[]{node.getExceptionString()});
            toReturn = Collections.emptyList();
        }
        return toReturn;
    }

    @Override
    public int getRelatedCount(RelationTypeToken type, Artifact node, RelationSide side) {
        return this.getRelatedCount(type, node, side, DeletionFlag.EXCLUDE_DELETED);
    }

    @Override
    public int getRelatedCount(RelationTypeToken type, Artifact node, RelationSide side, DeletionFlag includeDeleted) {
        return this.getRelations(type, node, side, includeDeleted).size();
    }

    @Override
    public boolean areRelated(Artifact aNode, RelationTypeToken type, Artifact bNode) {
        return this.getRelation(aNode, type, bNode, DeletionFlag.EXCLUDE_DELETED).size() > 0;
    }

    @Override
    public <T extends Artifact> T getParent(OrcsSession session, Artifact child) {
        ResultSet<T> toReturn = this.getRelated(session, CoreRelationTypes.DEFAULT_HIERARCHY, child, CoreRelationTypes.IS_CHILD);
        return (T)((Artifact)toReturn.getOneOrNull());
    }

    @Override
    public <T extends Artifact> ResultSet<T> getChildren(OrcsSession session, Artifact parent) {
        return this.getRelated(session, CoreRelationTypes.DEFAULT_HIERARCHY, parent, CoreRelationTypes.IS_PARENT);
    }

    @Override
    public <T extends Artifact> ResultSet<T> getRelated(OrcsSession session, RelationTypeToken type, Artifact node, RelationSide side) {
        return this.getRelated(session, type, node, side, DeletionFlag.EXCLUDE_DELETED);
    }

    @Override
    public <T extends Artifact> ResultSet<T> getRelated(OrcsSession session, RelationTypeToken type, Artifact node, RelationSide side, DeletionFlag flag) {
        List<Relation> links = this.getRelations(type, node, side, flag);
        List result = null;
        if (links.isEmpty()) {
            result = Collections.emptyList();
        } else {
            RelationSide otherSide = side.oppositeSide();
            GraphData graph = node.getGraph();
            result = this.resolver.resolve(session, graph, links, otherSide);
            if (result.size() > 1) {
                OrderManager orderManager = this.orderFactory.createOrderManager(node);
                RelationTypeSide key = RelationTypeSide.create((RelationTypeToken)type, (RelationSide)otherSide);
                orderManager.sort(key, result);
            }
        }
        return ResultSets.newResultSet(result);
    }

    @Override
    public String getRationale(Artifact aNode, RelationTypeToken type, Artifact bNode) {
        ResultSet<Relation> result = this.getRelation(aNode, type, bNode, DeletionFlag.EXCLUDE_DELETED);
        return ((Relation)result.getExactlyOne()).getRationale();
    }

    @Override
    public void setRationale(Artifact aNode, RelationTypeToken type, Artifact bNode, String rationale) {
        ResultSet<Relation> result = this.getRelation(aNode, type, bNode, DeletionFlag.EXCLUDE_DELETED);
        Relation relation = (Relation)result.getExactlyOne();
        relation.setRationale(rationale);
    }

    @Override
    public void addChild(OrcsSession session, Artifact parent, Artifact child) {
        this.unrelateFromAll(session, CoreRelationTypes.DEFAULT_HIERARCHY, child, CoreRelationTypes.IS_CHILD);
        this.relate(session, parent, CoreRelationTypes.DEFAULT_HIERARCHY, child);
    }

    @Override
    public void relate(OrcsSession session, Artifact aNode, RelationTypeToken type, Artifact bNode) {
        this.relate(session, aNode, type, bNode, Strings.emptyString(), RelationSorter.PREEXISTING);
    }

    @Override
    public void relate(OrcsSession session, Artifact aNode, RelationTypeToken type, Artifact bNode, TxData txData) {
        this.relate(session, aNode, type, bNode, Strings.emptyString(), RelationSorter.PREEXISTING, 0, ArtifactId.SENTINEL, txData);
    }

    @Override
    public void relate(OrcsSession session, Artifact aNode, RelationTypeToken type, Artifact bNode, String rationale) {
        this.relate(session, aNode, type, bNode, rationale, RelationSorter.PREEXISTING);
    }

    @Override
    public void relate(OrcsSession session, Artifact aNode, RelationTypeToken type, Artifact bNode, String rationale, RelationId id) {
        this.relate(session, aNode, type, bNode, rationale, RelationSorter.PREEXISTING, id);
    }

    @Override
    public void relate(OrcsSession session, Artifact aNode, RelationTypeToken type, Artifact bNode, RelationSorter sortType) {
        this.relate(session, aNode, type, bNode, Strings.emptyString(), sortType);
    }

    @Override
    public void relate(OrcsSession session, Artifact aNode, RelationTypeToken type, Artifact bNode, String rationale, RelationSorter sortType) {
        this.relate(session, aNode, type, bNode, rationale, sortType, 0, null, null);
    }

    @Override
    public void relate(OrcsSession session, Artifact aNode, RelationTypeToken type, Artifact bNode, String rationale, RelationSorter sortType, RelationId id) {
        this.relate(session, aNode, type, bNode, rationale, sortType, 0, null, null, id);
    }

    @Override
    public void relate(OrcsSession session, Artifact aNode, RelationTypeToken type, Artifact bNode, String rationale, RelationSorter sortType, int relOrder, ArtifactId relatedArtifact, TxData txData) {
        OrcsConditions.checkBranch(aNode, bNode);
        OrcsConditions.checkRelateSelf(aNode, bNode);
        GraphData graph = this.getGraph(aNode, bNode);
        this.validity.checkRelationTypeValid(type, aNode, RelationSide.SIDE_A);
        this.validity.checkRelationTypeValid(type, bNode, RelationSide.SIDE_B);
        this.checkMultiplicityCanAdd(type, aNode, bNode, txData);
        DeletionFlag delFlag = type.isNewRelationTable() ? DeletionFlag.INCLUDE_HARD_DELETED : DeletionFlag.INCLUDE_DELETED;
        Relation relation = type.isNewRelationTable() ? (Relation)this.getRelation(aNode, type, bNode, relOrder, delFlag).getOneOrNull() : (Relation)this.getRelation(aNode, type, bNode, delFlag).getOneOrNull();
        boolean updated = false;
        if (relation == null) {
            relation = type.isNewRelationTable() ? this.relationFactory.createRelation(aNode, type, bNode, relatedArtifact, relOrder) : this.relationFactory.createRelation(aNode, type, bNode, rationale);
            ((RelationNodeAdjacencies)graph.getAdjacencies((ArtifactId)aNode)).add(type, relation);
            ((RelationNodeAdjacencies)graph.getAdjacencies((ArtifactId)bNode)).add(type, relation);
            updated = true;
        }
        if (relation.isDeleted()) {
            relation.unDelete();
            updated = true;
        }
        if (updated) {
            relation.setDirty();
            if (!type.isNewRelationTable()) {
                this.order(session, type, aNode, RelationSide.SIDE_A, sortType, OrderOp.ADD_TO_ORDER, Collections.singleton(bNode));
            } else {
                relation.setRelOrder(relOrder);
            }
        }
    }

    @Override
    public void relate(OrcsSession session, Artifact aNode, RelationTypeToken type, Artifact bNode, String rationale, RelationSorter sortType, int relOrder, ArtifactId relatedArtifact, TxData txData, RelationId id) {
        OrcsConditions.checkBranch(aNode, bNode);
        OrcsConditions.checkRelateSelf(aNode, bNode);
        GraphData graph = this.getGraph(aNode, bNode);
        this.validity.checkRelationTypeValid(type, aNode, RelationSide.SIDE_A);
        this.validity.checkRelationTypeValid(type, bNode, RelationSide.SIDE_B);
        this.checkMultiplicityCanAdd(type, aNode, bNode, txData);
        DeletionFlag delFlag = type.isNewRelationTable() ? DeletionFlag.INCLUDE_HARD_DELETED : DeletionFlag.INCLUDE_DELETED;
        Relation relation = type.isNewRelationTable() ? (Relation)this.getRelation(aNode, type, bNode, relOrder, delFlag).getOneOrNull() : (Relation)this.getRelation(aNode, type, bNode, delFlag).getOneOrNull();
        boolean updated = false;
        if (relation == null) {
            relation = type.isNewRelationTable() ? this.relationFactory.createRelation(aNode, type, bNode, relatedArtifact, relOrder) : this.relationFactory.createRelation(aNode, type, bNode, rationale, id);
            ((RelationNodeAdjacencies)graph.getAdjacencies((ArtifactId)aNode)).add(type, relation);
            ((RelationNodeAdjacencies)graph.getAdjacencies((ArtifactId)bNode)).add(type, relation);
            updated = true;
        }
        if (relation.isDeleted()) {
            relation.unDelete();
            updated = true;
        }
        if (updated) {
            relation.setDirty();
            if (!type.isNewRelationTable()) {
                this.order(session, type, aNode, RelationSide.SIDE_A, sortType, OrderOp.ADD_TO_ORDER, Collections.singleton(bNode));
            } else {
                relation.setRelOrder(relOrder);
            }
        }
    }

    private GraphData getGraph(Artifact aNode, Artifact bNode) {
        OrcsConditions.checkBranch(aNode, bNode);
        return aNode.getGraph().getTransaction().isOlderThan(bNode.getGraph().getTransaction()) ? bNode.getGraph() : aNode.getGraph();
    }

    private void checkMultiplicityCanAdd(RelationTypeToken type, Artifact aNode, Artifact bNode, TxData txData) {
        int aSideMax;
        int bSideMax;
        List<Relation> relations = this.getRelations(type, aNode, RelationSide.SIDE_A, DeletionFlag.EXCLUDE_DELETED, txData);
        int bSideCount = relations.stream().filter(a -> a.getOrcsData().getVersion().getTxCurrent().equals(TxCurrent.CURRENT)).collect(Collectors.toList()).size();
        if (bSideCount >= (bSideMax = this.validity.getMaximumRelationsAllowed(type, bNode.getArtifactType(), RelationSide.SIDE_B))) {
            throw new OseeStateException("Relation type [%s] on [%s] exceeds max occurrence rule on [%s]", new Object[]{type, RelationSide.SIDE_B, aNode.getExceptionString()});
        }
        int aSideCount = this.getRelations(type, bNode, RelationSide.SIDE_B, DeletionFlag.EXCLUDE_DELETED, txData).stream().filter(a -> a.getOrcsData().getVersion().getTxCurrent().equals(TxCurrent.CURRENT)).collect(Collectors.toList()).size();
        if (aSideCount >= (aSideMax = this.validity.getMaximumRelationsAllowed(type, aNode.getArtifactType(), RelationSide.SIDE_A))) {
            throw new OseeStateException("Relation type [%s] on [%s] exceeds max occurrence rule on [%s]", new Object[]{type, RelationSide.SIDE_A, bNode.getExceptionString()});
        }
    }

    @Override
    public Relation unrelate(OrcsSession session, Artifact aNode, RelationTypeToken type, Artifact bNode) {
        Relation relation = (Relation)this.getRelation(aNode, type, bNode, DeletionFlag.EXCLUDE_DELETED).getOneOrNull();
        boolean modified = false;
        if (relation != null) {
            relation.delete();
            modified = true;
        }
        if (modified && !type.isNewRelationTable()) {
            this.order(session, type, aNode, RelationSide.SIDE_A, OrderOp.REMOVE_FROM_ORDER, Collections.singleton(bNode));
        }
        return relation;
    }

    @Override
    public void unrelateFromAll(OrcsSession session, RelationTypeToken type, Artifact node, RelationSide side) {
        List<Relation> relations = this.getRelations(type, node, side, DeletionFlag.EXCLUDE_DELETED);
        RelationSide otherSide = side.oppositeSide();
        GraphData graph = node.getGraph();
        this.resolver.resolve(session, graph, relations, otherSide);
        boolean modified = false;
        LinkedHashSet<Artifact> otherNodes = new LinkedHashSet<Artifact>();
        for (Relation relation : relations) {
            relation.delete();
            Artifact otherNode = (Artifact)graph.getNode(relation.getIdForSide(otherSide));
            otherNodes.add(otherNode);
            modified = true;
        }
        if (modified && !type.isNewRelationTable()) {
            this.order(session, type, node, side, OrderOp.REMOVE_FROM_ORDER, otherNodes);
        }
    }

    @Override
    public void unrelateFromAll(OrcsSession session, Artifact node) {
        this.unrelate(session, node, true);
    }

    private void unrelate(OrcsSession session, Artifact node, boolean reorderRelations) {
        Conditions.checkNotNull((Object)node, (String)"node");
        if (node.isDeleteAllowed()) {
            GraphData graph = node.getGraph();
            List<Relation> relations = this.getRelations(node, DeletionFlag.EXCLUDE_DELETED);
            this.resolver.resolve(session, graph, relations, RelationSide.values());
            ResultSet children = this.getChildren(session, node);
            for (Artifact child : children) {
                this.unrelate(session, child, false);
            }
            try {
                node.delete();
                if (relations != null && !relations.isEmpty()) {
                    HashMap<RelationTypeToken, RelationSide> typesToRemove = new HashMap<RelationTypeToken, RelationSide>();
                    for (Relation relation : relations) {
                        relation.delete();
                        RelationTypeToken type = relation.getRelationType();
                        RelationSide otherSide = relation.getIdForSide(RelationSide.SIDE_A).equals(node) ? RelationSide.SIDE_B : RelationSide.SIDE_A;
                        typesToRemove.put(type, otherSide);
                    }
                    if (!typesToRemove.isEmpty()) {
                        OrderManager orderManager = this.orderFactory.createOrderManager(node);
                        for (Map.Entry entry : typesToRemove.entrySet()) {
                            RelationTypeToken type = (RelationTypeToken)entry.getKey();
                            RelationSide side = (RelationSide)entry.getValue();
                            List<Relation> sideLinks = this.getRelations(type, node, side, DeletionFlag.EXCLUDE_DELETED);
                            List nodes = this.resolver.resolve(session, graph, sideLinks, side);
                            RelationTypeSide asTypeSide = RelationTypeSide.create((RelationTypeToken)type, (RelationSide)side);
                            orderManager.setOrder(asTypeSide, nodes);
                        }
                    }
                }
            }
            catch (OseeCoreException ex) {
                node.unDelete();
                throw ex;
            }
        }
    }

    private void ensureRelationsInitialized(GraphData graph, Artifact node) {
        if (graph.getAdjacencies((ArtifactId)node) == null) {
            RelationNodeAdjacencies container = this.relationFactory.createRelationContainer();
            graph.addAdjacencies((ArtifactId)node, container);
        }
    }

    private ResultSet<Relation> getRelation(Artifact aNode, RelationTypeToken type, Artifact bNode, DeletionFlag inludeDeleted) {
        GraphData graph = this.getGraph(aNode, bNode);
        Conditions.checkNotNull((Object)type, (String)"relationType");
        this.ensureRelationsInitialized(graph, aNode);
        this.ensureRelationsInitialized(graph, bNode);
        RelationNodeAdjacencies aAdjacencies = (RelationNodeAdjacencies)graph.getAdjacencies((ArtifactId)aNode);
        RelationNodeAdjacencies bAdjacencies = (RelationNodeAdjacencies)graph.getAdjacencies((ArtifactId)bNode);
        Relation relation = aAdjacencies.getRelation(aNode, type, bNode, inludeDeleted);
        if (relation != null) {
            bAdjacencies.add(type, relation);
        } else {
            relation = bAdjacencies.getRelation(aNode, type, bNode, inludeDeleted);
            if (relation != null) {
                aAdjacencies.add(type, relation);
            }
        }
        return ResultSets.singleton((Object)relation);
    }

    private ResultSet<Relation> getRelation(Artifact aNode, RelationTypeToken type, Artifact bNode, int relOrder, DeletionFlag includeDeleted) {
        GraphData graph = this.getGraph(aNode, bNode);
        Conditions.checkNotNull((Object)type, (String)"relationType");
        this.ensureRelationsInitialized(graph, aNode);
        this.ensureRelationsInitialized(graph, bNode);
        RelationNodeAdjacencies aAdjacencies = (RelationNodeAdjacencies)graph.getAdjacencies((ArtifactId)aNode);
        RelationNodeAdjacencies bAdjacencies = (RelationNodeAdjacencies)graph.getAdjacencies((ArtifactId)bNode);
        Relation relation = aAdjacencies.getRelation((ArtifactId)aNode, type, (ArtifactId)bNode, relOrder, includeDeleted);
        if (relation != null) {
            bAdjacencies.add(type, relation);
        } else {
            relation = bAdjacencies.getRelation((ArtifactId)aNode, type, (ArtifactId)bNode, relOrder, includeDeleted);
            if (relation != null) {
                aAdjacencies.add(type, relation);
            }
        }
        return ResultSets.singleton((Object)relation);
    }

    private List<Relation> getRelations(RelationTypeToken type, Artifact node, RelationSide side, DeletionFlag includeDeleted) {
        return this.getRelations(type, node, side, includeDeleted, null);
    }

    private List<Relation> getRelations(RelationTypeToken type, Artifact node, RelationSide side, DeletionFlag includeDeleted, TxData txData) {
        Conditions.checkNotNull((Object)type, (String)"relationType");
        Conditions.checkNotNull((Object)side, (String)"relationSide");
        Conditions.checkNotNull((Object)node, (String)"node");
        GraphData graph = node.getGraph();
        this.ensureRelationsInitialized(graph, node);
        RelationNodeAdjacencies adjacencies = (RelationNodeAdjacencies)graph.getAdjacencies((ArtifactId)node);
        List<Relation> relations = adjacencies.getList(type, includeDeleted, (ArtifactId)node, side);
        if (txData != null) {
            for (Relation relation : txData.getRelations()) {
                if (!relation.isDeleted()) continue;
                relations.remove(relation);
            }
        }
        return relations;
    }

    @Override
    public List<Relation> getRelations(Artifact node, DeletionFlag includeDeleted) {
        GraphData graph = node.getGraph();
        this.ensureRelationsInitialized(graph, node);
        RelationNodeAdjacencies adjacencies = (RelationNodeAdjacencies)graph.getAdjacencies((ArtifactId)node);
        return adjacencies.getList(includeDeleted);
    }

    private void order(OrcsSession session, RelationTypeToken type, Artifact node1, RelationSide side, OrderOp op, Collection<? extends Artifact> node2) {
        this.order(session, type, node1, side, RelationSorter.PREEXISTING, op, node2);
    }

    private void order(OrcsSession session, RelationTypeToken type, Artifact node1, RelationSide side, RelationSorter sorterId, OrderOp op, Collection<? extends Artifact> node2) {
        OrderManager orderManager = this.orderFactory.createOrderManager(node1);
        RelationSide orderSide = side.oppositeSide();
        RelationTypeSide key = RelationTypeSide.create((RelationTypeToken)type, (RelationSide)orderSide);
        RelationSorter sorterIdToUse = sorterId;
        if (sorterIdToUse == RelationSorter.PREEXISTING) {
            sorterIdToUse = orderManager.getSorterId(key);
        }
        List relatives = Collections.emptyList();
        if (RelationSorter.USER_DEFINED == sorterIdToUse) {
            ResultSet arts = this.getRelated(session, type, node1, side);
            relatives = new LinkedList();
            for (Artifact art : arts) {
                relatives.add(art);
            }
            relatives.removeAll(node2);
            if (OrderOp.ADD_TO_ORDER == op) {
                relatives.addAll(node2);
            }
        }
        orderManager.setOrder(key, sorterIdToUse, relatives);
    }

    @Override
    public void order(Artifact node1, RelationTypeToken type, RelationSide side, List<? extends Artifact> node2) {
        OrderManager orderManager = this.orderFactory.createOrderManager(node1);
        RelationTypeSide key = RelationTypeSide.create((RelationTypeToken)type, (RelationSide)side);
        orderManager.setOrder(key, RelationSorter.USER_DEFINED, node2);
    }

    @Override
    public void cloneRelations(Artifact source, Artifact destination) {
        Collection all;
        this.ensureRelationsInitialized(source.getGraph(), source);
        RelationNodeAdjacencies adjacencies1 = (RelationNodeAdjacencies)source.getGraph().getAdjacencies((ArtifactId)source);
        if (adjacencies1 != null && !(all = adjacencies1.getAll()).isEmpty()) {
            RelationNodeAdjacencies adjacencies2 = this.relationFactory.createRelationContainer();
            destination.getGraph().addAdjacencies((ArtifactId)destination, adjacencies2);
            for (Relation relation : adjacencies1.getAll()) {
                Relation newRel = this.relationFactory.clone(relation);
                adjacencies2.add((RelationTypeToken)newRel.getOrcsData().getType(), newRel);
            }
        }
    }

    @Override
    public void introduce(BranchId branch, Artifact source, Artifact destination) {
        String orderData;
        this.ensureRelationsInitialized(source.getGraph(), source);
        Collection<RelationTypeToken> validRelationTypes = this.getValidRelationTypes(destination);
        RelationNodeAdjacencies sourceAdjacencies = (RelationNodeAdjacencies)source.getGraph().getAdjacencies((ArtifactId)source);
        RelationNodeAdjacencies destinationAdjacencies = (RelationNodeAdjacencies)destination.getGraph().getAdjacencies((ArtifactId)destination);
        if (sourceAdjacencies != null) {
            for (Relation sourceRel : sourceAdjacencies.getAll()) {
                if (!validRelationTypes.contains(sourceRel.getRelationType())) continue;
                Relation destinationRel = sourceRel.getRelationType().isNewRelationTable() ? this.findRelationByRelTypeArtABOrder(destinationAdjacencies, sourceRel.getRelationType(), sourceRel.getArtifactIdA(), sourceRel.getArtifactIdB(), sourceRel.getRelOrder()) : this.findRelationByLocalId(destinationAdjacencies, sourceRel.getOrcsData());
                Relation introduceRelation = this.relationFactory.introduce(branch, sourceRel.getOrcsData());
                if (destinationRel == null) continue;
                destinationRel.setOrcsData(introduceRelation.getOrcsData());
                destinationRel.setDirty();
            }
        }
        if (!(orderData = source.getOrderData()).isEmpty()) {
            destination.storeOrderData(OrderChange.Forced, source.getOrderData());
        }
    }

    @Override
    public void setApplicabilityId(Artifact aNode, RelationTypeToken type, Artifact bNode, ApplicabilityId applicId) {
        ResultSet<Relation> result = this.getRelation(aNode, type, bNode, DeletionFlag.EXCLUDE_DELETED);
        Relation relation = (Relation)result.getExactlyOne();
        relation.setApplicabilityId(applicId);
    }

    private Relation findRelationByRelTypeArtABOrder(RelationNodeAdjacencies adjacencies, RelationTypeToken type, ArtifactId artA, ArtifactId artB, int relOrder) {
        for (Relation rel : adjacencies.getAll()) {
            if (!type.getIdString().equals(rel.getRelationType().getIdString()) || !artA.equals(rel.getArtifactIdA()) || !artB.equals(rel.getArtifactIdB()) || relOrder != rel.getRelOrder()) continue;
            return rel;
        }
        return null;
    }

    private Relation findRelationByLocalId(RelationNodeAdjacencies adjacencies, RelationData id) {
        for (Relation rel : adjacencies.getAll()) {
            if (!id.getLocalId().equals(rel.getOrcsData().getLocalId())) continue;
            return rel;
        }
        return null;
    }

    @Override
    public void unrelateFromInvalidArtifact(OrcsSession session, Artifact validArt, ArtifactId invalidArt) {
        List<Relation> relations = this.getRelations(validArt, DeletionFlag.INCLUDE_DELETED);
        Relation matchRel = relations.stream().filter(relation -> invalidArt.getIdIntValue() == relation.getArtifactIdA().getIdIntValue()).findAny().orElse(null);
        if (matchRel == null) {
            matchRel = relations.stream().filter(relation -> invalidArt.getIdIntValue() == relation.getArtifactIdB().getIdIntValue()).findAny().orElse(null);
        }
        if (matchRel != null) {
            matchRel.delete();
        }
    }

    private static enum OrderOp {
        ADD_TO_ORDER,
        REMOVE_FROM_ORDER;

    }
}

