/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.attribute;

import java.lang.ref.WeakReference;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.exception.AttributeDoesNotExist;
import org.eclipse.osee.orcs.core.ds.ArtifactData;
import org.eclipse.osee.orcs.core.ds.Attribute;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.ds.AttributeDataFactory;
import org.eclipse.osee.orcs.core.ds.DataProxy;
import org.eclipse.osee.orcs.core.ds.ResourceNameResolver;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeContainer;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeManager;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeResourceNameResolver;
import org.eclipse.osee.orcs.core.internal.attribute.primitives.ArtifactReferenceAttribute;
import org.eclipse.osee.orcs.core.internal.attribute.primitives.AttributeImpl;
import org.eclipse.osee.orcs.core.internal.attribute.primitives.BooleanAttribute;
import org.eclipse.osee.orcs.core.internal.attribute.primitives.BranchReferenceAttribute;
import org.eclipse.osee.orcs.core.internal.attribute.primitives.CompressedContentAttribute;
import org.eclipse.osee.orcs.core.internal.attribute.primitives.DateAttribute;
import org.eclipse.osee.orcs.core.internal.attribute.primitives.EnumeratedAttribute;
import org.eclipse.osee.orcs.core.internal.attribute.primitives.FloatingPointAttribute;
import org.eclipse.osee.orcs.core.internal.attribute.primitives.IntegerAttribute;
import org.eclipse.osee.orcs.core.internal.attribute.primitives.JavaObjectAttribute;
import org.eclipse.osee.orcs.core.internal.attribute.primitives.LongAttribute;
import org.eclipse.osee.orcs.core.internal.attribute.primitives.MapEntryAttribute;
import org.eclipse.osee.orcs.core.internal.attribute.primitives.StringAttribute;

public class AttributeFactory {
    private final AttributeDataFactory dataFactory;
    private final OrcsTokenService tokenService;

    public AttributeFactory(AttributeDataFactory dataFactory, OrcsTokenService tokenService) {
        this.dataFactory = dataFactory;
        this.tokenService = tokenService;
    }

    public <T> Attribute<T> createAttributeWithDefaults(AttributeContainer container, ArtifactData artifactData, AttributeTypeToken attributeType) {
        AttributeData data = this.dataFactory.create(artifactData, this.tokenService.getAttributeType(attributeType.getId()));
        return this.createAttribute(container, data, true, true);
    }

    public <T> Attribute<T> createAttributeWithDefaults(AttributeContainer container, ArtifactData artifactData, AttributeTypeToken attributeType, AttributeId attributeId) {
        AttributeData data = this.dataFactory.create(artifactData, this.tokenService.getAttributeType(attributeType.getId()), attributeId);
        return this.createAttribute(container, data, true, true);
    }

    public <T> Attribute<T> createAttribute(AttributeContainer container, AttributeData<T> data) {
        return this.createAttribute(container, data, false, false);
    }

    private <T> Attribute<T> createAttribute(AttributeContainer container, AttributeData<T> data, boolean isDirty, boolean createWithDefaults) {
        Attribute<T> attribute = this.createAttribute((AttributeTypeId)data.getType(), data);
        DataProxy<T> proxy = data.getDataProxy();
        ResourceNameResolver resolver = this.createResolver(attribute);
        proxy.setResolver(resolver);
        proxy.setAttribute(attribute);
        WeakReference<AttributeContainer> artifactRef = new WeakReference<AttributeContainer>(container);
        attribute.internalInitialize(artifactRef, data, isDirty, createWithDefaults, this.tokenService);
        container.add((AttributeTypeToken)data.getType(), attribute);
        return attribute;
    }

    private <T> Attribute<T> createAttribute(AttributeTypeId attributeTypeId, AttributeId attributeId) {
        AttributeTypeGeneric attributeType = this.tokenService.getAttributeType(attributeTypeId.getId());
        Long id = attributeId.getId();
        AttributeImpl attribute = attributeType.isString() ? new StringAttribute(id) : (attributeType.isBoolean() ? new BooleanAttribute(id) : (attributeType.isEnumerated() ? new EnumeratedAttribute(id) : (attributeType.isDate() ? new DateAttribute(id) : (attributeType.isInteger() ? new IntegerAttribute(id) : (attributeType.isDouble() ? new FloatingPointAttribute(id) : (attributeType.isLong() ? new LongAttribute(id) : (attributeType.isArtifactId() ? new ArtifactReferenceAttribute(id) : (attributeType.isBranchId() ? new BranchReferenceAttribute(id) : (attributeType.isJavaObject() ? new JavaObjectAttribute(id) : (attributeType.isInputStream() ? new CompressedContentAttribute(id) : (attributeType.isMapEntry() ? new MapEntryAttribute(id) : new StringAttribute(id))))))))))));
        return attribute;
    }

    public <T> Attribute<T> copyAttribute(AttributeData<T> source, BranchId ontoBranch, AttributeContainer destinationContainer) {
        AttributeData<T> attributeData = this.dataFactory.copy(ontoBranch, source);
        return this.createAttribute(destinationContainer, attributeData, true, false);
    }

    public <T> Attribute<T> cloneAttribute(AttributeData<T> source, AttributeContainer destinationContainer) {
        AttributeData<T> attributeData = this.dataFactory.clone(source);
        Attribute<T> destinationAttribute = this.createAttribute(destinationContainer, attributeData, false, false);
        return destinationAttribute;
    }

    public <T> Attribute<T> introduceAttribute(AttributeData<T> source, BranchId ontoBranch, AttributeManager destination) {
        AttributeData<T> attributeData = this.dataFactory.introduce(ontoBranch, source);
        Attribute<T> destinationAttribute = null;
        if (source.getVersion().isInStorage()) {
            try {
                destinationAttribute = destination.getAttributeById(source, DeletionFlag.INCLUDE_DELETED);
                WeakReference<AttributeContainer> artifactRef = new WeakReference<AttributeContainer>(destination);
                destinationAttribute.internalInitialize(artifactRef, attributeData, true, false, this.tokenService);
            }
            catch (AttributeDoesNotExist attributeDoesNotExist) {
                destinationAttribute = this.createAttribute(destination, attributeData);
            }
        }
        return destinationAttribute;
    }

    private ResourceNameResolver createResolver(Attribute<?> attribute) {
        return new AttributeResourceNameResolver(attribute);
    }
}

