/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.publishing.FormatIndicator;
import org.eclipse.osee.framework.core.publishing.RendererOption;
import org.eclipse.osee.framework.core.publishing.relation.table.RelationTableOptions;
import org.eclipse.osee.framework.core.server.OseeInfo;
import org.eclipse.osee.framework.core.util.OseeInf;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.core.util.PublishingTemplate;
import org.eclipse.osee.orcs.core.util.PublishingTemplateContentMapEntry;
import org.eclipse.osee.orcs.core.util.PublishingTemplateMatchCriterion;
import org.eclipse.osee.orcs.core.util.PublishingTemplateMatchCriterionListBuilder;
import org.eclipse.osee.orcs.core.util.PublishingTemplateSetter;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class SetupPublishing {
    private static final boolean matchPreviewTemplatesByName = true;
    private static Boolean newValues = false;
    private static Boolean noTags = false;
    private static final String previewTemplatesNotMatchByNameSuffix = " (NOT MATCHED BY NAME)";
    private static Supplier<List<PublishingTemplate>> publishingTemplatesSupplier = new Supplier<List<PublishingTemplate>>(){

        @Override
        public List<PublishingTemplate> get() {
            return List.of(new PublishingTemplate(CoreArtifactTokens.DocumentTemplates, "WordEditTemplate", new PublishingTemplate.FileSupplierOseeInf("templates/EDIT_TEMPLATE.json"), null, List.of(new PublishingTemplateContentMapEntry(FormatIndicator.WORD_ML, "templates/EDIT_TEMPLATE.xml"), new PublishingTemplateContentMapEntry(FormatIndicator.MARKDOWN, "templates/EDIT_TEMPLATE.md")), new PublishingTemplateMatchCriterionListBuilder(true).appendAlways(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_WORD_TEMPLATE, PresentationType.SPECIALIZED_EDIT.name())).appendAlways(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_MARKDOWN, PresentationType.SPECIALIZED_EDIT.name())).toList(), null), new PublishingTemplate(CoreArtifactTokens.DocumentTemplates, "WordMergeTemplate", new PublishingTemplate.FileSupplierOseeInf("templates/WordMergeTemplate.json"), new PublishingTemplate.FileSupplierOseeInf("templates/PREVIEW_ALL.xml"), List.of(), List.of(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_WORD_TEMPLATE, PresentationType.MERGE.name()), new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_WORD_TEMPLATE, PresentationType.DIFF.name(), RendererOption.THREE_WAY_MERGE.getKey())), null), new PublishingTemplate(CoreArtifactTokens.DocumentTemplates, SetupPublishing.previewTemplateName(RendererOption.PREVIEW_ALL_VALUE.getKey()), null, new PublishingTemplate.FileSupplierOseeInf("templates/PREVIEW_ALL.xml"), List.of(new PublishingTemplateContentMapEntry(FormatIndicator.WORD_ML, "templates/PREVIEW_ALL.xml"), new PublishingTemplateContentMapEntry(FormatIndicator.MARKDOWN, "templates/PREVIEW_ALL.md")), new PublishingTemplateMatchCriterionListBuilder(true).appendAlways(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_WORD_TEMPLATE, PresentationType.DIFF.name())).appendAlways(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_WORD_TEMPLATE, PresentationType.PREVIEW.name(), RendererOption.PREVIEW_ALL_VALUE.getKey())).appendAlways(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_MARKDOWN, PresentationType.PREVIEW.name(), RendererOption.PREVIEW_ALL_VALUE.getKey())).toList(), null), new PublishingTemplate(CoreArtifactTokens.DocumentTemplates, SetupPublishing.previewTemplateName(RendererOption.PREVIEW_ALL_NO_ATTRIBUTES_VALUE.getKey()), new PublishingTemplate.FileSupplierOseeInf("templates/PREVIEW_ALL_NO_ATTRIBUTES.json"), null, List.of(new PublishingTemplateContentMapEntry(FormatIndicator.WORD_ML, "templates/PREVIEW_ALL.xml"), new PublishingTemplateContentMapEntry(FormatIndicator.MARKDOWN, "templates/PREVIEW_ALL.md")), new PublishingTemplateMatchCriterionListBuilder(true).appendAlways(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_WORD_TEMPLATE, "DIFF_NO_ATTRIBUTES")).appendAlways(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_WORD_TEMPLATE, PresentationType.PREVIEW.name(), RendererOption.PREVIEW_ALL_NO_ATTRIBUTES_VALUE.getKey())).appendAlways(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_MARKDOWN, PresentationType.PREVIEW.name(), RendererOption.PREVIEW_ALL_NO_ATTRIBUTES_VALUE.getKey())).toList(), null), new PublishingTemplate(CoreArtifactTokens.DocumentTemplates, SetupPublishing.previewTemplateName(RendererOption.PREVIEW_ALL_RECURSE_VALUE.getKey()), new PublishingTemplate.FileSupplierOseeInf("templates/PREVIEW_ALL_RECURSE.json"), null, List.of(new PublishingTemplateContentMapEntry(FormatIndicator.WORD_ML, "templates/PREVIEW_ALL.xml"), new PublishingTemplateContentMapEntry(FormatIndicator.MARKDOWN, "templates/PREVIEW_ALL.md")), new PublishingTemplateMatchCriterionListBuilder(true).appendAlways(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_WORD_TEMPLATE, PresentationType.PREVIEW.name(), RendererOption.PREVIEW_ALL_RECURSE_VALUE.getKey())).appendAlways(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_MARKDOWN, PresentationType.PREVIEW.name(), RendererOption.PREVIEW_ALL_RECURSE_VALUE.getKey())).toList(), null), new PublishingTemplate(CoreArtifactTokens.DocumentTemplates, SetupPublishing.previewTemplateName(RendererOption.PREVIEW_ALL_RECURSE_NO_ATTRIBUTES_VALUE.getKey()), new PublishingTemplate.FileSupplierOseeInf("templates/PREVIEW_ALL_RECURSE_NO_ATTRIBUTES.json"), null, List.of(new PublishingTemplateContentMapEntry(FormatIndicator.WORD_ML, "templates/PREVIEW_ALL.xml"), new PublishingTemplateContentMapEntry(FormatIndicator.MARKDOWN, "templates/PREVIEW_ALL.md")), new PublishingTemplateMatchCriterionListBuilder(true).appendAlways(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_WORD_TEMPLATE, PresentationType.PREVIEW.name(), RendererOption.PREVIEW_ALL_RECURSE_NO_ATTRIBUTES_VALUE.getKey())).appendAlways(new PublishingTemplateMatchCriterion(RENDERER_IDENTIFIER_MARKDOWN, PresentationType.PREVIEW.name(), RendererOption.PREVIEW_ALL_RECURSE_NO_ATTRIBUTES_VALUE.getKey())).toList(), null), new PublishingTemplate(CoreArtifactTokens.DocumentTemplates, "PreviewAll_HeadingsNoMainContent_RelationTable", new PublishingTemplate.FileSupplierOseeInf("templates/PreviewAllRecurse_HeadersOnlyHeading_HeadingsNoMainContent.json"), null, List.of(new PublishingTemplateContentMapEntry(FormatIndicator.WORD_ML, "templates/PREVIEW_ALL.xml"), new PublishingTemplateContentMapEntry(FormatIndicator.MARKDOWN, "templates/EDIT_TEMPLATE.md")), null, new RelationTableOptions(Collections.emptyList(), Collections.emptyList(), Arrays.asList(String.valueOf(CoreRelationTypes.RequirementTrace.getName()) + "|" + CoreRelationTypes.RequirementTrace.getSideName(RelationSide.SIDE_A), String.valueOf(CoreRelationTypes.RequirementTrace.getName()) + "|" + CoreRelationTypes.RequirementTrace.getSideName(RelationSide.SIDE_B)))));
        }
    };
    private static String RENDERER_IDENTIFIER_WORD_TEMPLATE = "org.eclipse.osee.framework.ui.skynet.render.WordTemplateRenderer";
    private static String RENDERER_IDENTIFIER_MARKDOWN = "org.eclipse.osee.framework.ui.skynet.render.MarkdownRenderer";

    private static void createDataRights(TransactionBuilder tx) {
        ArtifactToken dataRightsArt = tx.createArtifact((ArtifactId)CoreArtifactTokens.DocumentTemplates, CoreArtifactTokens.DataRightsFooters);
        tx.createAttribute((ArtifactId)dataRightsArt, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)OseeInf.getResourceContents((String)"Unspecified.xml", SetupPublishing.class));
        tx.createAttribute((ArtifactId)dataRightsArt, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)OseeInf.getResourceContents((String)"Default.xml", SetupPublishing.class));
        tx.createAttribute((ArtifactId)dataRightsArt, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)OseeInf.getResourceContents((String)"GovernmentPurposeRights.xml", SetupPublishing.class));
        tx.createAttribute((ArtifactId)dataRightsArt, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)OseeInf.getResourceContents((String)"RestrictedRights.xml", SetupPublishing.class));
    }

    private static void createWordTemplates(final TransactionBuilder tx) {
        PublishingTemplate.load(publishingTemplatesSupplier, new PublishingTemplateSetter(){

            @Override
            public String set(ArtifactToken parent, String name, String content, String rendererOptions, List<Map.Entry<String, String>> publishingTemplateContentMapEntries, List<String> matchCriteria, RelationTableOptions relationTableOptions) {
                Objects.requireNonNull(tx, "SetupPublishing::createPublishingTemplate, parameter \"tx\" cannot be null.");
                ArtifactToken publishingTemplateArtifact = tx.createArtifact((ArtifactId)parent, CoreArtifactTypes.RendererTemplateWholeWord, name);
                if (Objects.nonNull(rendererOptions)) {
                    tx.setSoleAttributeValue((ArtifactId)publishingTemplateArtifact, (AttributeTypeToken)CoreAttributeTypes.RendererOptions, (Object)rendererOptions);
                }
                if (Objects.nonNull(content)) {
                    tx.setSoleAttributeValue((ArtifactId)publishingTemplateArtifact, (AttributeTypeToken)CoreAttributeTypes.WholeWordContent, (Object)content);
                }
                if (Objects.nonNull(publishingTemplateContentMapEntries)) {
                    publishingTemplateContentMapEntries.forEach(mapEntry -> {
                        AttributeId attributeId = tx.createAttribute((ArtifactId)publishingTemplateArtifact, (AttributeTypeToken)CoreAttributeTypes.PublishingTemplateContentByFormatMapEntry, mapEntry);
                    });
                }
                if (Objects.nonNull(matchCriteria)) {
                    matchCriteria.forEach(matchCriterion -> {
                        AttributeId attributeId = tx.createAttribute((ArtifactId)publishingTemplateArtifact, (AttributeTypeToken)CoreAttributeTypes.TemplateMatchCriteria, matchCriterion);
                    });
                }
                if (Objects.nonNull(relationTableOptions)) {
                    List artTypes = relationTableOptions.getRelationTableArtifactTypeNamesAndOrIds();
                    List cols = relationTableOptions.getRelationTableColumns();
                    List relTypeSides = relationTableOptions.getRelationTableRelationTypeSides();
                    if (Objects.nonNull(artTypes)) {
                        for (String artType : artTypes) {
                            tx.createAttribute((ArtifactId)publishingTemplateArtifact, (AttributeTypeToken)CoreAttributeTypes.PublishingRelationTableArtifactTypeNameOrId, (Object)artType);
                        }
                    }
                    if (Objects.nonNull(cols)) {
                        for (String col : cols) {
                            tx.createAttribute((ArtifactId)publishingTemplateArtifact, (AttributeTypeToken)CoreAttributeTypes.PublishingRelationTableColumn, (Object)col);
                        }
                    }
                    if (Objects.nonNull(relTypeSides)) {
                        for (String relTypeSide : relTypeSides) {
                            tx.createAttribute((ArtifactId)publishingTemplateArtifact, (AttributeTypeToken)CoreAttributeTypes.PublishingRelationTableRelationTypeSide, (Object)relTypeSide);
                        }
                    }
                }
                return "AT-".concat(publishingTemplateArtifact.getIdString());
            }
        }, SetupPublishing.class, true);
    }

    private static String previewTemplateName(String templateBaseName) {
        return templateBaseName;
    }

    public static void setup(TransactionBuilder tx) {
        Objects.requireNonNull(tx, "SetupPublishing::setup, the parameter \"tx\" cannot be null.");
        SetupPublishing.createWordTemplates(tx);
        SetupPublishing.createDataRights(tx);
    }

    public static void setupConfiguration(OrcsApi orcsApi) {
        try {
            JdbcClient jdbcClient = orcsApi.getJdbcService().getClient();
            OseeInfo.setValue((JdbcClient)jdbcClient, (String)"osee.publish.no.tags", (String)noTags.toString());
            OseeInfo.setValue((JdbcClient)jdbcClient, (String)"osee.publish.new.values", (String)newValues.toString());
        }
        catch (Exception exception) {}
    }

    private SetupPublishing() {
    }
}

