/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal;

import java.net.URI;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchCategoryToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.CoreActivityTypes;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.UserService;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsBranch;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.BranchDataStore;
import org.eclipse.osee.orcs.core.internal.branch.BranchDataFactory;
import org.eclipse.osee.orcs.core.internal.branch.CommitBranchCallable;
import org.eclipse.osee.orcs.core.internal.branch.PurgeBranchCallable;
import org.eclipse.osee.orcs.data.CreateBranchData;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.search.TransactionQuery;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class OrcsBranchImpl
implements OrcsBranch {
    private final OrcsApi orcsApi;
    private final Log logger;
    private final OrcsSession session;
    private final BranchDataStore branchStore;
    private final BranchDataFactory branchDataFactory;
    private final OrcsTokenService tokenService;
    private final QueryFactory queryFactory;
    private final UserService userService;

    public OrcsBranchImpl(OrcsApi orcsApi, Log logger, OrcsSession session, BranchDataStore branchStore, QueryFactory queryFactory) {
        this.orcsApi = orcsApi;
        this.logger = logger;
        this.session = session;
        this.branchStore = branchStore;
        this.branchDataFactory = new BranchDataFactory(queryFactory);
        this.tokenService = orcsApi.tokenService();
        this.queryFactory = queryFactory;
        this.userService = orcsApi.userService();
    }

    public XResultData createBranchValidation(CreateBranchData branchData) {
        return this.branchStore.createBranchValidation(branchData, this.userService, this.orcsApi.tokenService());
    }

    public Branch createBranch(CreateBranchData branchData) {
        Conditions.checkNotNull((Object)branchData, (String)"branchData");
        Conditions.checkNotNull((Object)branchData.getBranch(), (String)"branchUuid");
        Conditions.checkNotNull((Object)branchData.getName(), (String)"branchName");
        Conditions.checkNotNull((Object)branchData.getBranchType(), (String)"branchType");
        if (branchData.isTxCopyBranchType()) {
            TransactionQuery txQuery = this.queryFactory.transactionQuery();
            TransactionToken givenTx = branchData.getFromTransaction();
            Conditions.checkNotNull((Object)givenTx, (String)"Transaction used for copy");
            branchData.setSavedTransaction((TransactionId)givenTx);
            TransactionToken priorTx = (TransactionToken)((TransactionQuery)txQuery.andIsPriorTx(givenTx)).getResults().getExactlyOne();
            branchData.setFromTransaction(priorTx);
            this.branchStore.createBranchCopyTx(branchData, this.userService, this.orcsApi.tokenService());
        } else {
            TransactionToken txData = null;
            txData = branchData.getParentBranch().isValid() ? (TransactionToken)((TransactionQuery)this.orcsApi.getQueryFactory().transactionQuery().andIsHead(branchData.getParentBranch())).getTokens().getExactlyOne() : branchData.getFromTransaction();
            Conditions.checkNotNull((Object)txData, (String)"sourceTransaction");
            branchData.setFromTransaction(txData);
            this.branchStore.createBranch(branchData, this.userService, this.orcsApi.tokenService());
        }
        if (!branchData.getCategories().isEmpty()) {
            for (BranchCategoryToken bc : branchData.getCategories()) {
                this.orcsApi.getBranchOps().setBranchCategory(branchData.getBranch(), bc);
            }
            this.orcsApi.getBranchOps().setBranchState(branchData.getBranch(), BranchState.CREATED);
        }
        return (Branch)((BranchQuery)this.queryFactory.branchQuery().andId((BranchId)branchData.getNewBranch())).getResults().getExactlyOne();
    }

    public BranchToken createTopLevelBranch(BranchToken branch) {
        return this.createTopLevelBranch(new CreateBranchData(branch), ArtifactId.SENTINEL);
    }

    private BranchToken createTopLevelBranch(CreateBranchData createData, ArtifactId associatedArtifact) {
        createData.setBranchType(BranchType.BASELINE);
        BranchToken parentBranch = CoreBranches.SYSTEM_ROOT;
        TransactionToken parentTx = (TransactionToken)((TransactionQuery)this.orcsApi.getQueryFactory().transactionQuery().andIsHead((BranchId)parentBranch)).getTokens().getExactlyOne();
        String creationComment = String.format("New Branch from %s (%s)", parentBranch, parentTx.getId());
        createData.setCreationComment(creationComment);
        createData.setAssociatedArtifact(associatedArtifact);
        createData.setFromTransaction(parentTx);
        createData.setParentBranch((BranchId)parentBranch);
        createData.setCategories(this.orcsApi.getQueryFactory().branchQuery().getBranchCategories((BranchId)parentBranch));
        createData.setTxCopyBranchType(false);
        return this.createBranch(createData);
    }

    public XResultData archiveBranch(BranchId branch) {
        return this.branchStore.archiveBranch(this.session, branch);
    }

    public XResultData unarchiveBranch(BranchId branch) {
        return this.branchStore.unArchiveBranch(this.session, branch);
    }

    public XResultData deleteBranch(BranchId branch) {
        return this.branchStore.deleteBranch(this.session, branch);
    }

    public Callable<List<BranchId>> purgeBranch(BranchId branch, boolean recurse) {
        return new PurgeBranchCallable(this.logger, this.session, this.branchStore, branch, recurse, this.queryFactory);
    }

    public Callable<TransactionToken> commitBranch(ArtifactId committer, BranchId source, BranchId destination) {
        return new CommitBranchCallable(this.logger, this.session, this.branchStore, this.orcsApi, committer, source, destination, this.tokenService);
    }

    public List<ChangeItem> compareBranch(TransactionToken sourceTx, TransactionToken destinationTx) {
        return this.branchStore.compareBranch(this.session, this.tokenService, sourceTx, destinationTx, this.orcsApi);
    }

    public List<ChangeItem> compareBranch(BranchId branch) {
        TransactionId baseTransaction = ((Branch)((BranchQuery)this.queryFactory.branchQuery().andId(branch)).getResults().getExactlyOne()).getBaselineTx();
        TransactionToken fromTx = (TransactionToken)((TransactionQuery)this.queryFactory.transactionQuery().andTxId(baseTransaction)).getResults().getExactlyOne();
        TransactionToken toTx = (TransactionToken)((TransactionQuery)this.queryFactory.transactionQuery().andIsHead(branch)).getResults().getExactlyOne();
        return this.branchStore.compareBranch(this.session, this.tokenService, fromTx, toTx, this.orcsApi);
    }

    public void setBranchPermission(ArtifactId subject, BranchId branch, PermissionEnum permission) {
        this.branchStore.setBranchPermission(subject, branch, permission);
    }

    public XResultData changeBranchState(BranchId branch, BranchState branchState) {
        return this.branchStore.changeBranchState(this.session, branch, branchState);
    }

    public XResultData changeBranchType(BranchId branch, BranchType branchType) {
        return this.branchStore.changeBranchType(this.session, branch, branchType);
    }

    public XResultData changeBranchName(BranchId branch, String branchName) {
        return this.branchStore.changeBranchName(this.session, branch, branchName);
    }

    public XResultData associateBranchToArtifact(BranchId branch, ArtifactId associatedArtifact) {
        Conditions.checkNotNull((Object)associatedArtifact, (String)"associatedArtifact");
        return this.branchStore.changeBranchAssociatedArt(this.session, branch, associatedArtifact);
    }

    public XResultData unassociateBranch(BranchId branch) {
        return this.branchStore.changeBranchAssociatedArt(this.session, branch, ArtifactId.SENTINEL);
    }

    public Callable<URI> exportBranch(List<? extends BranchId> branches, PropertyStore options, String exportName) {
        return this.branchStore.exportBranch(this.session, branches, options, exportName);
    }

    public Callable<URI> importBranch(URI fileToImport, List<? extends BranchId> branches, PropertyStore options) {
        return this.branchStore.importBranch(this.session, fileToImport, branches, options);
    }

    public Branch createBaselineBranch(BranchToken branch, BranchToken parent, ArtifactId associatedArtifact) {
        CreateBranchData branchData = this.branchDataFactory.createBaselineBranchData(branch, parent, associatedArtifact);
        Branch newBranch = this.createBranch(branchData);
        this.setBranchPermission((ArtifactId)this.userService.getUser(), (BranchId)newBranch, PermissionEnum.FULLACCESS);
        return newBranch;
    }

    public Branch createWorkingBranch(BranchToken branch, BranchToken parent, ArtifactId associatedArtifact) {
        CreateBranchData branchData = this.branchDataFactory.createWorkingBranchData(branch, parent, associatedArtifact);
        return this.createBranch(branchData);
    }

    public Branch createCopyTxBranch(BranchToken branch, TransactionId fromTransaction, ArtifactId associatedArtifact) {
        CreateBranchData branchData = this.branchDataFactory.createCopyTxBranchData(branch, fromTransaction, associatedArtifact);
        return this.createBranch(branchData);
    }

    public Branch createPortBranch(BranchToken branch, TransactionId fromTransaction, ArtifactId associatedArtifact) {
        CreateBranchData branchData = this.branchDataFactory.createPortBranchData(branch, fromTransaction, associatedArtifact);
        return this.createBranch(branchData);
    }

    public void addMissingApplicabilityFromParentBranch(BranchId branch) {
        this.branchStore.addMissingApplicabilityFromParentBranch(branch);
    }

    public BranchToken createProgramBranch(BranchToken branch, BranchToken parent) {
        Branch newBranch = this.createBaselineBranch(branch, parent, ArtifactId.SENTINEL);
        this.setBranchPermission((ArtifactId)this.userService.getUser(), (BranchId)newBranch, PermissionEnum.FULLACCESS);
        return newBranch;
    }

    public BranchToken createProgramBranch(BranchToken branch) {
        BranchToken newBranch = this.createTopLevelBranch(branch);
        this.setBranchPermission((ArtifactId)this.userService.getUser(), (BranchId)branch, PermissionEnum.FULLACCESS);
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction((BranchId)branch, "Create Program Hierarchy");
        tx.createOrIntroduceArtifact((ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot, CoreArtifactTokens.SystemRequirementsFolder);
        tx.createOrIntroduceArtifact((ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot, CoreArtifactTokens.SubSystemRequirementsFolder);
        tx.createOrIntroduceArtifact((ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot, CoreArtifactTokens.SoftwareRequirementsFolder);
        tx.createOrIntroduceArtifact((ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot, CoreArtifactTokens.HardwareRequirementsFolder);
        tx.createOrIntroduceArtifact((ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot, CoreArtifactTokens.InterfaceMessagesFolder);
        tx.createOrIntroduceArtifact((ArtifactId)CoreArtifactTokens.InterfaceMessagesFolder, CoreArtifactTokens.InterfacePlatformTypesFolder);
        tx.createOrIntroduceArtifact((ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot, CoreArtifactTokens.SystemRequirementsFolderMarkdown);
        tx.createOrIntroduceArtifact((ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot, CoreArtifactTokens.SubSystemRequirementsFolderMarkdown);
        tx.createOrIntroduceArtifact((ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot, CoreArtifactTokens.SoftwareRequirementsFolderMarkdown);
        tx.createOrIntroduceArtifact((ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot, CoreArtifactTokens.VerificationTestsFolder);
        tx.createOrIntroduceArtifact((ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot, CoreArtifactTokens.ValidationTestsFolder);
        tx.createOrIntroduceArtifact((ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot, CoreArtifactTokens.IntegrationTestsFolder);
        tx.createOrIntroduceArtifact((ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot, CoreArtifactTokens.ApplicabilityTestsFolder);
        tx.createOrIntroduceArtifact((ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot, CoreArtifactTokens.GitRepoFolder);
        tx.createOrIntroduceArtifact((ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot, CoreArtifactTokens.CustomerReqFolder);
        tx.commit();
        return newBranch;
    }

    public XResultData setBranchCategory(BranchId branch, BranchCategoryToken category) {
        XResultData result = new XResultData();
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, "Set Branch Category");
        tx.createBranchCategory(branch, category);
        tx.commit();
        return result;
    }

    public XResultData deleteBranchCategory(BranchId branch, BranchCategoryToken category) {
        XResultData result = new XResultData();
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, "Delete Branch Category");
        tx.deleteBranchCategory(branch, category);
        tx.commit();
        return result;
    }

    public boolean setBranchState(BranchId branchId, BranchState newState) {
        Branch branch = (Branch)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(branchId)).getResults().getExactlyOne();
        XResultData rd = this.branchStore.changeBranchState(this.session, branchId, newState);
        if (rd.isSuccess()) {
            this.orcsApi.getActivityLog().createEntry(CoreActivityTypes.BRANCH_OPERATION, ActivityLog.INITIAL_STATUS, new Object[]{String.format("Branch Operation Branch State Changed {branchId: %s prevState: %s newState: %s}", branchId, branch.getBranchType(), newState)});
            return true;
        }
        return false;
    }
}

