/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.workdef.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.review.ReviewRequiredMinimum;
import org.eclipse.osee.ats.api.review.ReviewRole;
import org.eclipse.osee.ats.api.review.ReviewRoleType;
import org.eclipse.osee.ats.api.task.create.CreateTasksDefinition;
import org.eclipse.osee.ats.api.task.create.CreateTasksDefinitionBuilder;
import org.eclipse.osee.ats.api.team.ChangeTypes;
import org.eclipse.osee.ats.api.team.Priorities;
import org.eclipse.osee.ats.api.workdef.WidgetOption;
import org.eclipse.osee.ats.api.workdef.model.AbstractWorkDefItem;
import org.eclipse.osee.ats.api.workdef.model.HeaderDefinition;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workdef.model.WidgetDefinition;
import org.eclipse.osee.ats.api.workdef.model.WorkDefOption;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.CountingMap;

public class WorkDefinition
extends AbstractWorkDefItem {
    private final List<StateDefinition> states = new ArrayList<StateDefinition>(5);
    @JsonIgnore
    private final CountingMap<String> labelCount = new CountingMap();
    @JsonIgnore
    private final List<CreateTasksDefinition> createTasksDefs = new ArrayList<CreateTasksDefinition>();
    @JsonIgnore
    private final Map<ReviewRole, Integer> reviewRoleMap = new ConcurrentHashMap<ReviewRole, Integer>();
    @JsonIgnore
    private final Map<ReviewRoleType, Integer> reviewRoleTypeMap = new ConcurrentHashMap<ReviewRoleType, Integer>();
    @JsonIgnore
    private StateDefinition startState;
    @JsonIgnore
    private HeaderDefinition headerDef;
    private boolean showStateMetrics = false;
    @JsonIgnore
    private List<XViewerColumn> reviewDefectColumns = new ArrayList<XViewerColumn>();
    @JsonIgnore
    private XResultData results = new XResultData();
    private final List<WorkDefOption> options = new ArrayList<WorkDefOption>();
    private final List<ChangeTypes> changeTypes = new ArrayList<ChangeTypes>();
    private AttributeTypeToken pointsAttrType = AtsAttributeTypes.PointsNumeric;
    private final List<Priorities> priorities = new ArrayList<Priorities>();
    private final List<ReviewRequiredMinimum> reviewRequiredMinimums = new ArrayList<ReviewRequiredMinimum>();

    public WorkDefinition(Long id, String name) {
        this(id, name, ArtifactTypeToken.SENTINEL);
    }

    public WorkDefinition(Long id, String name, ArtifactTypeToken artType) {
        super(id, name, artType);
        if (artType == null) {
            this.results.errorf("Artifact Type can not be null Work Def [%s]", new Object[]{name});
        }
        this.headerDef = new HeaderDefinition(this);
    }

    public StateDefinition getStateByName(String name) {
        for (StateDefinition state : this.states) {
            if (!state.getName().equals(name)) continue;
            return state;
        }
        return null;
    }

    public StateDefinition getStartState() {
        return this.startState;
    }

    public void setStartState(StateDefinition startState) {
        this.startState = startState;
    }

    public StateDefinition addState(StateDefinition state) {
        this.states.add(state);
        return state;
    }

    public List<StateDefinition> getStates() {
        return this.states;
    }

    public HeaderDefinition getHeaderDef() {
        return this.headerDef;
    }

    public boolean hasHeaderDefinitionItems() {
        return this.headerDef != null && !this.headerDef.getLayoutItems().isEmpty();
    }

    @JsonIgnore
    public HeaderDefinition getDefaultHeaderDef() {
        HeaderDefinition defaultHeaderDef = new HeaderDefinition(this);
        defaultHeaderDef.setShowMetricsHeader(true);
        defaultHeaderDef.getLayoutItems().add(new WidgetDefinition("Work Package", "XHyperlinkWorkPackageDam", new WidgetOption[0]));
        return defaultHeaderDef;
    }

    public void setHeaderDefinition(HeaderDefinition headerDef) {
        this.headerDef = headerDef;
    }

    public boolean isShowStateMetrics() {
        return this.showStateMetrics;
    }

    public void setShowStateMetrics(boolean showStateMetrics) {
        this.showStateMetrics = showStateMetrics;
    }

    public void addTaskSetDef(CreateTasksDefinition createTasksDef) {
        this.createTasksDefs.add(createTasksDef);
    }

    public List<CreateTasksDefinition> getCreateTasksDefs() {
        return this.createTasksDefs;
    }

    public CountingMap<String> getLabelCount() {
        return this.labelCount;
    }

    public List<XViewerColumn> getReviewDefectColumns() {
        return this.reviewDefectColumns;
    }

    public void setReviewDefectColumns(List<XViewerColumn> reviewDefectColumns) {
        this.reviewDefectColumns = reviewDefectColumns;
    }

    public void addReviewRole(ReviewRole role, int minimum) {
        this.reviewRoleMap.put(role, minimum);
    }

    public Set<ReviewRole> getReviewRoles() {
        return this.reviewRoleMap.keySet();
    }

    public void andReviewRoleTypeMinimum(ReviewRoleType reviewRoleType, int minimum) {
        this.reviewRoleTypeMap.put(reviewRoleType, minimum);
    }

    public Map<ReviewRoleType, Integer> getReviewRoleTypeMap() {
        return this.reviewRoleTypeMap;
    }

    public Map<ReviewRole, Integer> getReviewRoleMap() {
        return this.reviewRoleMap;
    }

    public ReviewRole fromName(String name) {
        for (ReviewRole role : this.reviewRoleMap.keySet()) {
            if (!role.getName().equals(name)) continue;
            return role;
        }
        ReviewRole newRole = new ReviewRole(Long.valueOf(this.reviewRoleMap.size()), name, ReviewRoleType.Reviewer);
        this.reviewRoleMap.put(newRole, 0);
        return newRole;
    }

    public XResultData getResults() {
        return this.results;
    }

    public void setResults(XResultData results) {
        this.results = results;
    }

    public List<WorkDefOption> getOptions() {
        return this.options;
    }

    public boolean hasOption(WorkDefOption workDefOption) {
        return this.options.contains((Object)workDefOption);
    }

    public void addCreateTasksDefinition(CreateTasksDefinitionBuilder createTasksDefBldr) {
        this.getCreateTasksDefs().add(createTasksDefBldr.getCreateTasksDef());
    }

    public List<ChangeTypes> getChangeTypes() {
        return this.changeTypes;
    }

    public AttributeTypeToken getPointsAttrType() {
        return this.pointsAttrType;
    }

    public void setPointsAttrType(AttributeTypeToken pointsAttrType) {
        this.pointsAttrType = pointsAttrType;
    }

    public List<Priorities> getPriorities() {
        return this.priorities;
    }

    public String getStartStateName() {
        return this.getStartState().getName();
    }

    public List<String> getStateNames() {
        ArrayList<String> stateNames = new ArrayList<String>();
        for (StateDefinition state : this.getStates()) {
            stateNames.add(state.getName());
        }
        return stateNames;
    }

    public void andRequiredMinimum(ReviewRequiredMinimum reviewRequiredMinimum) {
        this.reviewRequiredMinimums.add(reviewRequiredMinimum);
    }

    public List<ReviewRequiredMinimum> getReviewRequiredMinimums() {
        return this.reviewRequiredMinimums;
    }
}

