/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.task;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.task.NewTaskData;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;

public class NewTaskSet {
    private List<NewTaskData> taskDatas = new LinkedList<NewTaskData>();
    private XResultData results;
    private String commitComment;
    private String asUserId;
    private TransactionToken transaction = TransactionToken.SENTINEL;

    public NewTaskSet() {
        this.results = new XResultData();
    }

    public List<NewTaskData> getNewTaskDatas() {
        return this.taskDatas;
    }

    public void setTaskDatas(List<NewTaskData> taskDatas) {
        this.taskDatas = taskDatas;
    }

    public String getAsUserId() {
        return this.asUserId;
    }

    public void setAsUserId(String asUserId) {
        this.asUserId = asUserId;
    }

    public void add(NewTaskData newTaskData) {
        this.taskDatas.add(newTaskData);
    }

    public String toString() {
        return "newTaskSet [datas=" + this.taskDatas + "]";
    }

    public XResultData getResults() {
        return this.results;
    }

    public void setResults(XResultData results) {
        this.results = results;
    }

    public String getCommitComment() {
        return this.commitComment;
    }

    public void setCommitComment(String commitComment) {
        this.commitComment = commitComment;
    }

    public NewTaskData getTaskData() {
        return this.getNewTaskDatas().iterator().next();
    }

    public boolean isErrors() {
        return this.results.isErrors();
    }

    public boolean isSuccess() {
        return !this.isErrors();
    }

    public static NewTaskSet create(NewTaskData newTaskData, String comment, UserToken user) {
        return NewTaskSet.create(newTaskData, comment, user.getUserId());
    }

    public static NewTaskSet create(String comment, AtsUser user) {
        return NewTaskSet.create(comment, user.getUserId());
    }

    public static NewTaskSet create(String comment, String asUserId) {
        NewTaskSet newTaskSet = new NewTaskSet();
        newTaskSet.setAsUserId(asUserId);
        newTaskSet.setCommitComment(comment);
        return newTaskSet;
    }

    public static NewTaskSet create(String comment, UserToken user) {
        return NewTaskSet.create(comment, user.getUserId());
    }

    public static NewTaskSet create(NewTaskData newTaskData, String comment, String asUserId) {
        NewTaskSet newTaskSet = new NewTaskSet();
        newTaskSet.setAsUserId(asUserId);
        newTaskSet.setCommitComment(comment);
        newTaskSet.getNewTaskDatas().add(newTaskData);
        return newTaskSet;
    }

    public static NewTaskSet createWithData(String comment, Long teamWfId, String asUserId) {
        NewTaskSet newTaskSet = NewTaskSet.create(comment, asUserId);
        NewTaskData newTaskData = new NewTaskData();
        newTaskSet.getNewTaskDatas().add(newTaskData);
        newTaskData.setTeamWfId(teamWfId);
        return newTaskSet;
    }

    public static NewTaskSet createWithData(IAtsTeamWorkflow teamWf, String comment, AtsUser atsUser) {
        return NewTaskSet.createWithData(comment, teamWf.getId(), atsUser.getUserId());
    }

    public TransactionToken getTransaction() {
        return this.transaction;
    }

    public void setTransaction(TransactionToken transaction) {
        this.transaction = transaction;
    }
}

