/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.eclipse.osee.framework.core.enums.OseeEnum;

public class WorkType
extends OseeEnum {
    private static final Long ENUM_ID = 233285922899L;
    public static final WorkType All = new WorkType("All");
    public static final WorkType Applicability = new WorkType("Applicability");
    public static final WorkType ARB = new WorkType("ARB", "Architecture Review Board", true);
    public static final WorkType ChangeRequest = new WorkType("Change Request", "Top level Change Request");
    public static final WorkType Code = new WorkType("Code");
    public static final WorkType Custom = new WorkType("Custom", "Custom Work Type that doesn't match a WorkType enum");
    public static final WorkType Hardware = new WorkType("Hardware");
    public static final WorkType ICDs = new WorkType("ICDs");
    public static final WorkType ImplDetails = new WorkType("ImplDetails", "Implementation Details", "Impl Details");
    public static final WorkType Integration = new WorkType("Integration");
    public static final WorkType IntegrationTest = new WorkType("IntegrationTest", "Integration Test", "");
    public static final WorkType Issues = new WorkType("Issues");
    public static final WorkType Maintenance = new WorkType("Maintenance");
    public static final WorkType MIM = new WorkType("MIM", "MIM", "Message Interface Modeling", true);
    public static final WorkType MissionCode = new WorkType("MissionCode", "Mission Code", "");
    public static final WorkType None = new WorkType("None");
    public static final WorkType PIDS = new WorkType("PIDS");
    public static final WorkType ProblemReport = new WorkType("Problem Report");
    public static final WorkType Program = new WorkType("Program", "Top Level item of given type for a Program");
    public static final WorkType Requirements = new WorkType("Requirements");
    public static final WorkType Software = new WorkType("Software");
    public static final WorkType SoftwareTest = new WorkType("SoftwareTest", "Software Test", "");
    public static final WorkType SSDD = new WorkType("SSDD");
    public static final WorkType SubSystems = new WorkType("SubSystems");
    public static final WorkType Support = new WorkType("Support");
    public static final WorkType SW_Design = new WorkType("SW_Design", "Software Design", "");
    public static final WorkType SW_TechAppr = new WorkType("SW_TechAppr", "Software Tech Approach", "");
    public static final WorkType Systems = new WorkType("Systems");
    public static final WorkType Test = new WorkType("Test");
    public static final WorkType Test_Librarian = new WorkType("Test_Librarian", "Test Librarian", "");
    public static final WorkType Test_Procedures = new WorkType("Test_Procedures", "Test Procedures", "");
    private String humanReadableName;
    private String description;
    private boolean createBranchDefault;

    public WorkType() {
        super(ENUM_ID, "");
    }

    private WorkType(String name) {
        this(name, "");
    }

    private WorkType(String name, String humanReadableName, boolean createBranch) {
        this(name, name, "", createBranch);
    }

    private WorkType(String name, String description) {
        this(name, name, description);
    }

    private WorkType(String name, String humanReadableName, String description) {
        this(name, humanReadableName, description, false);
    }

    private WorkType(String name, String humanReadableName, String description, boolean createBranchDefault) {
        super(ENUM_ID, name);
        this.humanReadableName = humanReadableName;
        this.description = description;
        this.createBranchDefault = createBranchDefault;
    }

    public String getHumanReadableName() {
        return this.humanReadableName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getCreateBranchDefault() {
        return this.createBranchDefault;
    }

    public static WorkType valueOfOrNone(String workTypeStr) {
        WorkType workType = (WorkType)None.get(workTypeStr);
        if (workType == null) {
            workType = None;
        }
        return workType;
    }

    @JsonIgnore
    public Long getTypeId() {
        return ENUM_ID;
    }

    @JsonIgnore
    public OseeEnum getDefault() {
        return None;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonIgnore
    public boolean isNotNone() {
        return !this.equals((Object)None);
    }
}

