/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc;

import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.MapEntryAttributeUtil;
import org.eclipse.osee.framework.jdk.core.type.IVariantData;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public interface JdbcStatement
extends AutoCloseable {
    public void runPreparedQuery(String var1, Object ... var2);

    public void runPreparedQueryWithMaxFetchSize(String var1, Object ... var2);

    public void runPreparedQuery(int var1, String var2, Object ... var3);

    public boolean next();

    @Override
    public void close();

    public void cancel();

    public InputStream getBinaryStream(String var1);

    public InputStream getAsciiStream(String var1);

    public String getString(String var1);

    public float getFloat(String var1);

    public long getLong(String var1);

    public int getInt(String var1);

    public boolean getBoolean(String var1);

    public Timestamp getTimestamp(String var1);

    public BigDecimal getBigDecimal(String var1);

    public Time getTime(String var1);

    public double getDouble(String var1);

    public Date getDate(String var1);

    public boolean wasNull();

    public int getColumnCount();

    public String getColumnName(int var1);

    public int getColumnType(int var1);

    public String getColumnTypeName(int var1);

    public Object getObject(int var1);

    public Object getObject(String var1);

    public int getRowCount();

    public boolean isNullable(int var1);

    public double getCallableDouble(int var1);

    public int getInt(int var1);

    public int getCallableInt(int var1);

    public long getLong(int var1);

    public String getString(int var1);

    public void updateObject(String var1, Object var2);

    public void updateRow();

    public IVariantData parse();

    default public Object loadAttributeValue(AttributeTypeToken attributeType) {
        if (attributeType.isBoolean()) {
            return this.getBoolean("value");
        }
        if (attributeType.isDouble()) {
            return this.getDouble("value");
        }
        if (attributeType.isInteger()) {
            return this.getInt("value");
        }
        if (attributeType.isLong()) {
            return this.getLong("value");
        }
        if (attributeType.isDate()) {
            return new Date(this.getLong("value"));
        }
        if (attributeType.isArtifactId()) {
            return ArtifactId.valueOf((String)this.getString("value"));
        }
        if (attributeType.isBranchId()) {
            return BranchId.valueOf((String)this.getString("value"));
        }
        if (attributeType.isEnumerated()) {
            return Strings.intern((String)this.getString("value"));
        }
        if (attributeType.isMapEntry()) {
            return MapEntryAttributeUtil.jsonDecode((String)this.getString("value"));
        }
        return this.getString("value");
    }
}

