/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.disposition.rest.internal.report;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import org.eclipse.osee.disposition.model.DispoAnnotationData;
import org.eclipse.osee.disposition.model.DispoItem;
import org.eclipse.osee.disposition.model.DispoSet;
import org.eclipse.osee.disposition.rest.DispoApi;
import org.eclipse.osee.disposition.rest.internal.DispoConnector;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;

public class STRSReport {
    private final DispoApi dispoApi;

    public STRSReport(DispoApi dispoApi) {
        this.dispoApi = dispoApi;
    }

    public void runReport(BranchId branch, DispoSet setPrimary, DispoSet setSecondary, OutputStream outputStream) {
        List<DispoItem> itemsFromPrimary = this.dispoApi.getDispoItems(branch, (String)setPrimary.getGuid(), true);
        List<DispoItem> itemsFromSecondary = this.dispoApi.getDispoItems(branch, (String)setSecondary.getGuid(), true);
        HashMap<String, DispoItem> idsToDryRun = this.convertToMap(itemsFromSecondary);
        try {
            OutputStreamWriter writer = new OutputStreamWriter(outputStream, "UTF-8");
            ExcelXmlWriter sheetWriter = new ExcelXmlWriter((Writer)writer);
            Object[] headers = STRSReport.getHeaders();
            int columns = headers.length;
            sheetWriter.startSheet("STRS Report", headers.length);
            sheetWriter.writeRow(headers);
            for (DispoItem demoItem : itemsFromPrimary) {
                DispoConnector connector = new DispoConnector();
                List<String> allUncoveredDiscprepancies = connector.getAllUncoveredDiscrepancies(demoItem);
                Object[] row = new String[columns];
                int index = 0;
                DispoItem dryrunItem = idsToDryRun.get(demoItem.getName());
                List annotationsList = demoItem.getAnnotationsList();
                HashMap<String, Integer> issueTypeToCount = this.convertToIssueTypeToCounttMap(annotationsList);
                row[index++] = String.valueOf(demoItem.getName());
                if (dryrunItem != null) {
                    row[index++] = String.valueOf(dryrunItem.getTotalPoints());
                    row[index++] = String.valueOf(dryrunItem.getDiscrepanciesList().size());
                } else {
                    row[index++] = "No corresponding Item";
                    row[index++] = "No corresponding Item";
                }
                row[index++] = String.valueOf(demoItem.getTotalPoints());
                row[index++] = String.valueOf(issueTypeToCount.get("CODE"));
                row[index++] = String.valueOf(issueTypeToCount.get("SCRIPT"));
                row[index++] = String.valueOf(issueTypeToCount.get("REQ"));
                row[index++] = String.valueOf(allUncoveredDiscprepancies.size());
                row[index++] = String.valueOf(issueTypeToCount.get("OTHER"));
                row[index++] = String.valueOf(demoItem.getDiscrepanciesList().size());
                row[index++] = " ";
                row[index++] = String.valueOf(this.getCustomerNotes(demoItem.getAnnotationsList()));
                sheetWriter.writeRow(row);
            }
            sheetWriter.endSheet();
            sheetWriter.endWorkbook();
        }
        catch (Exception ex) {
            throw new OseeCoreException((Throwable)ex);
        }
    }

    private HashMap<String, DispoItem> convertToMap(List<DispoItem> list) {
        HashMap<String, DispoItem> toReturn = new HashMap<String, DispoItem>();
        for (DispoItem item : list) {
            toReturn.put(item.getName(), item);
        }
        return toReturn;
    }

    private String getCustomerNotes(List<DispoAnnotationData> annotations) {
        StringBuilder sb = new StringBuilder();
        for (DispoAnnotationData annotation : annotations) {
            String customerNotes = annotation.getCustomerNotes();
            if (customerNotes.equalsIgnoreCase("--Enter Notes--")) continue;
            sb.append(annotation.getCustomerNotes());
            sb.append("\n");
        }
        if (sb.length() == 0) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private static String[] getHeaders() {
        String[] toReturn = new String[]{"Test Case", "Dry Run Results:Test Points", "Dry Run Results:Total Fails", "DemoResults:Total Test Points", "Demo: Code Problems", "Script Problems", "Requirements", "Under Investigation", "Other", "Total Fails", "Verification of RPCR", "Commnets"};
        return toReturn;
    }

    private HashMap<String, Integer> convertToIssueTypeToCounttMap(List<DispoAnnotationData> annotationList) {
        HashMap<String, Integer> toReturn = new HashMap<String, Integer>();
        int codeCount = 0;
        int scriptCount = 0;
        int reqCount = 0;
        int other = 0;
        for (DispoAnnotationData annotation : annotationList) {
            String resolutionType;
            if (!annotation.isResolutionValid() || (resolutionType = annotation.getResolutionType()) == null) continue;
            if (resolutionType.equalsIgnoreCase("CODE")) {
                codeCount += this.getTotalLocationOfAnnotation(annotation);
                continue;
            }
            if (resolutionType.equalsIgnoreCase("TEST")) {
                scriptCount += this.getTotalLocationOfAnnotation(annotation);
                continue;
            }
            if (resolutionType.equalsIgnoreCase("REQ")) {
                reqCount += this.getTotalLocationOfAnnotation(annotation);
                continue;
            }
            other += this.getTotalLocationOfAnnotation(annotation);
        }
        toReturn.put("CODE", codeCount);
        toReturn.put("SCRIPT", scriptCount);
        toReturn.put("REQ", reqCount);
        toReturn.put("OTHER", other);
        return toReturn;
    }

    private int getTotalLocationOfAnnotation(DispoAnnotationData annotation) {
        String locationRefs = annotation.getLocationRefs();
        String[] locationsRefsArray = locationRefs.split(",");
        int toReturn = 0;
        int i = 0;
        while (i < locationsRefsArray.length) {
            String singleRef = locationsRefsArray[i].trim();
            if (singleRef.contains("-")) {
                String[] split = singleRef.split("-");
                int gap = Integer.valueOf(split[1]) - Integer.valueOf(split[0]);
                toReturn += gap + 1;
            } else {
                ++toReturn;
            }
            ++i;
        }
        return toReturn;
    }
}

