/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.metrics;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.api.workdef.model.WorkDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.log.IAtsLogItem;
import org.eclipse.osee.ats.rest.metrics.SoftwareReqVolatilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.model.change.ChangeIgnoreType;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.model.change.ChangeType;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public final class SoftwareReqVolatilityMetrics
implements StreamingOutput {
    private final OrcsApi orcsApi;
    private final AtsApi atsApi;
    private String programVersion;
    private final String targetVersion;
    private final Date startDate;
    private final Date endDate;
    private final boolean allTime;
    Collection<IAtsTask> tasksMissingChangeType = new ArrayList<IAtsTask>();
    private ExcelXmlWriter writer;
    private final String VERIFY = "Verify";
    private final String DEMONSTRATE = "Demonstrate";
    private final String CLOSED = "Closed";
    private final SoftwareReqVolatilityId[] reportColumns = new SoftwareReqVolatilityId[]{SoftwareReqVolatilityId.ACT, SoftwareReqVolatilityId.TW, SoftwareReqVolatilityId.ActionName, SoftwareReqVolatilityId.Program, SoftwareReqVolatilityId.Build, SoftwareReqVolatilityId.Date, SoftwareReqVolatilityId.VerifyOrComplete, SoftwareReqVolatilityId.AddedReq, SoftwareReqVolatilityId.ModifiedReq, SoftwareReqVolatilityId.DeletedReq, SoftwareReqVolatilityId.AddedSub, SoftwareReqVolatilityId.ModifiedSub, SoftwareReqVolatilityId.DeletedSub, SoftwareReqVolatilityId.AddedHeading, SoftwareReqVolatilityId.ModifiedHeading, SoftwareReqVolatilityId.DeletedHeading, SoftwareReqVolatilityId.AddedImpl, SoftwareReqVolatilityId.ModifiedImpl, SoftwareReqVolatilityId.DeletedImpl};

    public SoftwareReqVolatilityMetrics(OrcsApi orcsApi, AtsApi atsApi, String targetVersion, Date startDate, Date endDate, boolean allTime) {
        this.orcsApi = orcsApi;
        this.atsApi = atsApi;
        this.programVersion = null;
        this.targetVersion = targetVersion;
        this.startDate = startDate;
        this.endDate = endDate;
        this.allTime = allTime;
    }

    public void write(OutputStream output) {
        try {
            this.writer = new ExcelXmlWriter((Writer)new OutputStreamWriter(output, "UTF-8"));
            this.writeReport();
            this.writer.endWorkbook();
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    private void writeReport() throws IOException {
        Collection<IAtsTeamWorkflow> reqWorkflows = this.getDatedWorkflows();
        if (!reqWorkflows.isEmpty()) {
            this.writer.startSheet("SRV", this.reportColumns.length);
            this.fillActionableData(reqWorkflows);
        }
    }

    private Collection<IAtsTeamWorkflow> getDatedWorkflows() {
        ArtifactToken versionId = this.atsApi.getQueryService().getArtifactFromTypeAndAttribute(AtsArtifactTypes.Version, (AttributeTypeToken)CoreAttributeTypes.Name, this.targetVersion, (BranchId)this.atsApi.getAtsBranch());
        Version version = this.atsApi.getVersionService().getVersionById((ArtifactId)versionId);
        Collection workflowArts = this.atsApi.getVersionService().getTargetedForTeamWorkflows((IAtsVersion)version);
        ArrayList<IAtsTeamWorkflow> reqWorkflows = new ArrayList<IAtsTeamWorkflow>();
        for (IAtsTeamWorkflow workflow : workflowArts) {
            try {
                boolean isReqWf = false;
                isReqWf = workflow.isWorkType(WorkType.Requirements);
                WorkDefinition workDef = workflow.getWorkDefinition();
                if (!isReqWf && workDef != null) {
                    isReqWf = workDef.getName().contains("Requirements");
                }
                Date stateStartedDate = new Date();
                if (!isReqWf) continue;
                if (this.atsApi.getWorkItemService().stateExists((IAtsWorkItem)workflow, "Verify")) {
                    stateStartedDate = this.getStateStartedDate((IAtsWorkItem)workflow, "Verify");
                } else if (this.atsApi.getWorkItemService().stateExists((IAtsWorkItem)workflow, "Demonstrate")) {
                    stateStartedDate = this.getStateStartedDate((IAtsWorkItem)workflow, "Demonstrate");
                } else if (workflow.isCompleted()) {
                    stateStartedDate = workflow.getCompletedDate();
                } else {
                    if (!this.atsApi.getWorkItemService().stateExists((IAtsWorkItem)workflow, "Closed")) continue;
                    stateStartedDate = this.getStateStartedDate((IAtsWorkItem)workflow, "Closed");
                }
                if (!this.allTime && (!stateStartedDate.after(this.startDate) || !stateStartedDate.before(this.endDate))) continue;
                reqWorkflows.add(workflow);
            }
            catch (Exception exception) {}
        }
        this.programVersion = this.atsApi.getRelationResolver().getRelatedOrSentinel((IAtsObject)version, AtsRelationTypes.TeamDefinitionToVersion_TeamDefinition).getName();
        return reqWorkflows;
    }

    private List<ChangeItem> getChangeItems(IAtsTeamWorkflow reqWorkflow) {
        BranchToken branch = this.atsApi.getBranchService().getBranch(reqWorkflow);
        if (branch == null || branch.isInvalid()) {
            return List.of();
        }
        String changeReportData = "";
        List<Object> changeItems = new ArrayList<ChangeItem>();
        try {
            boolean attributeExists = this.atsApi.getAttributeResolver().hasAttribute((IAtsWorkItem)reqWorkflow, new AttributeTypeToken[]{CoreAttributeTypes.BranchDiffData});
            if (attributeExists) {
                changeReportData = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)reqWorkflow, (AttributeTypeToken)CoreAttributeTypes.BranchDiffData, (Object)"");
            }
            if (changeReportData.isEmpty() && !(changeItems = this.orcsApi.getBranchOps().compareBranch((BranchId)branch)).isEmpty() && !attributeExists) {
                changeReportData = JsonUtil.toJson(changeItems);
                TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction((BranchId)this.atsApi.getAtsBranch(), "Generate Diff for Requirement Metrics");
                tx.createAttribute(this.atsApi.getArtifactResolver().get((IAtsObject)reqWorkflow), (AttributeTypeToken)CoreAttributeTypes.BranchDiffData, (Object)changeReportData);
                tx.commit();
            }
        }
        catch (Exception exception) {
            return List.of();
        }
        if (changeItems.isEmpty() && !changeReportData.isEmpty()) {
            changeItems = JsonUtil.readValues((String)changeReportData, ChangeItem.class);
        }
        return changeItems;
    }

    private void fillActionableData(Collection<IAtsTeamWorkflow> reqWorkflows) throws IOException {
        int numColumns = this.reportColumns.length;
        Object[] buffer = new Object[numColumns];
        int i = 0;
        while (i < numColumns) {
            buffer[i] = this.reportColumns[i].getDisplayName();
            ++i;
        }
        this.writer.writeRow(buffer);
        for (IAtsTeamWorkflow reqWorkflow : reqWorkflows) {
            List<ChangeItem> changeItems = this.getChangeItems(reqWorkflow);
            try {
                buffer[6] = this.atsApi.getWorkItemService().stateExists((IAtsWorkItem)reqWorkflow, "Verify") ? this.getStateStartedDate((IAtsWorkItem)reqWorkflow, "Verify") : (this.atsApi.getWorkItemService().stateExists((IAtsWorkItem)reqWorkflow, "Demonstrate") ? this.getStateStartedDate((IAtsWorkItem)reqWorkflow, "Demonstrate") : (reqWorkflow.isCompleted() ? reqWorkflow.getCompletedDate() : (this.atsApi.getWorkItemService().stateExists((IAtsWorkItem)reqWorkflow, "Closed") ? this.getStateStartedDate((IAtsWorkItem)reqWorkflow, "Closed") : "")));
            }
            catch (Exception exception) {
                buffer[6] = "Missing or Multiple Values";
            }
            try {
                buffer[0] = reqWorkflow.getParentAction().getAtsId();
            }
            catch (Exception exception) {
                buffer[0] = "";
            }
            try {
                buffer[1] = reqWorkflow.getAtsId();
            }
            catch (Exception exception) {
                buffer[1] = "";
            }
            try {
                buffer[2] = reqWorkflow.getName();
            }
            catch (Exception exception) {
                buffer[2] = "";
            }
            buffer[3] = this.programVersion;
            buffer[4] = this.targetVersion;
            Date createdDate = new Date();
            try {
                createdDate = reqWorkflow.getCreatedDate();
                buffer[5] = !createdDate.equals(new Date(0L)) ? createdDate : "";
            }
            catch (Exception exception) {
                buffer[5] = "Missing or Multiple Values";
            }
            ArrayList<ChangeItem> attrChangeItems = new ArrayList<ChangeItem>();
            HashMap<ArtifactId, ChangeItem> artChangeItems = new HashMap<ArtifactId, ChangeItem>();
            for (ChangeItem changeItem : changeItems) {
                if (changeItem.getChangeType().equals((Object)ChangeType.Attribute) && changeItem.getIgnoreType().equals((Object)ChangeIgnoreType.NONE) && (changeItem.getItemTypeId().equals(CoreAttributeTypes.WordTemplateContent) || changeItem.getItemTypeId().equals(CoreAttributeTypes.PlainTextContent))) {
                    attrChangeItems.add(changeItem);
                    continue;
                }
                if (!changeItem.getChangeType().equals((Object)ChangeType.Artifact)) continue;
                artChangeItems.put(changeItem.getArtId(), changeItem);
            }
            int swAdded = 0;
            int swModified = 0;
            int swDeleted = 0;
            int subAdded = 0;
            int subModified = 0;
            int subDeleted = 0;
            int headAdded = 0;
            int headModified = 0;
            int headDeleted = 0;
            int implAdded = 0;
            int implModified = 0;
            int implDeleted = 0;
            for (ChangeItem changeItem : attrChangeItems) {
                ModificationType modType;
                BranchToken workingBranch = this.atsApi.getBranchService().getBranch(reqWorkflow);
                BranchId parentBranch = this.atsApi.getBranchService().getParentBranch((BranchId)workingBranch);
                ArtifactTypeToken artType = ArtifactTypeToken.SENTINEL;
                artType = this.orcsApi.getQueryFactory().fromBranch(parentBranch).includeDeletedAttributes(true).includeDeletedArtifacts(true).andId(changeItem.getArtId()).asArtifactTokenOrSentinel().getArtifactType();
                if (artType.isInvalid() && (artType = this.orcsApi.tokenService().getArtifactTypeOrSentinel(((ChangeItem)artChangeItems.get(changeItem.getArtId())).getItemTypeId().getId())).isInvalid() && (artType = this.orcsApi.getQueryFactory().fromBranch((BranchId)workingBranch).includeDeletedAttributes(true).includeDeletedArtifacts(true).andId(changeItem.getArtId()).asArtifactTokenOrSentinel().getArtifactType()).isInvalid()) continue;
                if (artType.inheritsFrom((ArtifactTypeId)CoreArtifactTypes.AbstractSoftwareRequirement)) {
                    modType = changeItem.getNetChange().getModType();
                    if (modType.equals(ModificationType.NEW)) {
                        ++swAdded;
                        continue;
                    }
                    if (modType.equals(ModificationType.MODIFIED) || modType.equals(ModificationType.MERGED)) {
                        ++swModified;
                        continue;
                    }
                    if (!modType.equals(ModificationType.DELETED) && !modType.equals(ModificationType.ARTIFACT_DELETED)) continue;
                    ++swDeleted;
                    continue;
                }
                if (artType.inheritsFrom((ArtifactTypeId)CoreArtifactTypes.AbstractSubsystemRequirement)) {
                    modType = changeItem.getNetChange().getModType();
                    if (modType.equals(ModificationType.NEW)) {
                        ++subAdded;
                        continue;
                    }
                    if (modType.equals(ModificationType.MODIFIED) || modType.equals(ModificationType.MERGED)) {
                        ++subModified;
                        continue;
                    }
                    if (!modType.equals(ModificationType.DELETED) && !modType.equals(ModificationType.ARTIFACT_DELETED)) continue;
                    ++subDeleted;
                    continue;
                }
                if (artType.inheritsFrom((ArtifactTypeId)CoreArtifactTypes.AbstractHeading)) {
                    modType = changeItem.getNetChange().getModType();
                    if (modType.equals(ModificationType.NEW)) {
                        ++headAdded;
                        continue;
                    }
                    if (modType.equals(ModificationType.MODIFIED) || modType.equals(ModificationType.MERGED)) {
                        ++headModified;
                        continue;
                    }
                    if (!modType.equals(ModificationType.DELETED) && !modType.equals(ModificationType.ARTIFACT_DELETED)) continue;
                    ++headDeleted;
                    continue;
                }
                if (!artType.inheritsFrom((ArtifactTypeId)CoreArtifactTypes.AbstractImplementationDetails)) continue;
                modType = changeItem.getNetChange().getModType();
                if (modType.equals(ModificationType.NEW)) {
                    ++implAdded;
                    continue;
                }
                if (modType.equals(ModificationType.MODIFIED) || modType.equals(ModificationType.MERGED)) {
                    ++implModified;
                    continue;
                }
                if (!modType.equals(ModificationType.DELETED) && !modType.equals(ModificationType.ARTIFACT_DELETED)) continue;
                ++implDeleted;
            }
            buffer[7] = swAdded;
            buffer[8] = swModified;
            buffer[9] = swDeleted;
            buffer[10] = subAdded;
            buffer[11] = subModified;
            buffer[12] = subDeleted;
            buffer[13] = headAdded;
            buffer[14] = headModified;
            buffer[15] = headDeleted;
            buffer[16] = implAdded;
            buffer[17] = implModified;
            buffer[18] = implDeleted;
            try {
                this.writer.writeRow(buffer);
            }
            catch (IOException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        }
        this.writer.endSheet();
    }

    private Date getStateStartedDate(IAtsWorkItem teamWf, String stateName) {
        try {
            IAtsLogItem stateStartedData = this.atsApi.getWorkItemService().getStateStartedData(teamWf, stateName);
            return stateStartedData.getDate();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

