/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem.workdef;

import java.util.Collection;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.workdef.AtsWorkDefEndpointApi;
import org.eclipse.osee.ats.api.workdef.model.WorkDefinition;
import org.eclipse.osee.ats.rest.internal.workitem.operations.ConvertWorkDefinitionOperations;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.orcs.OrcsApi;

@Path(value="workdef")
public class AtsWorkDefEndpointImpl
implements AtsWorkDefEndpointApi {
    private final AtsApi atsApi;
    private final OrcsApi orcsApi;

    public AtsWorkDefEndpointImpl(AtsApi atsApi, OrcsApi orcsApi) {
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
    }

    @GET
    @Produces(value={"application/json"})
    public Collection<WorkDefinition> get() {
        return this.atsApi.getWorkDefinitionService().getAllWorkDefinitions();
    }

    @Path(value="{id}")
    @GET
    @Produces(value={"application/json"})
    public WorkDefinition getWorkDef(@PathParam(value="id") String id) {
        IAtsWorkItem workItem = this.atsApi.getWorkItemService().getWorkItem(Long.valueOf(id));
        return workItem.getWorkDefinition();
    }

    @Path(value="teamdef/{id}")
    @GET
    @Produces(value={"application/json"})
    public WorkDefinition getWorkDefForTeam(@PathParam(value="id") String id) {
        TeamDefinition teamDef = this.atsApi.getTeamDefinitionService().getTeamDefinitionById(ArtifactId.valueOf((String)id));
        WorkDefinition workDef = this.atsApi.getWorkDefinitionService().computeWorkDefinitionForTeamWfNotYetCreated((IAtsTeamDefinition)teamDef, null);
        return workDef;
    }

    @GET
    @Path(value="convert/artrefattr")
    @Produces(value={"application/json"})
    public String convertToWorkDefRefs() {
        ConvertWorkDefinitionOperations ops = new ConvertWorkDefinitionOperations(this.atsApi, this.orcsApi);
        XResultData data = new XResultData();
        ops.convert(data);
        return data.toString();
    }

    @GET
    @Path(value="validate")
    @Produces(value={"application/json"})
    public XResultData validate() {
        XResultData results = this.atsApi.getWorkDefinitionService().validateWorkDefinitions();
        return results;
    }
}

