/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.demo;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.demo.DemoArtifactToken;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.team.ChangeTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.model.ReviewBlockType;
import org.eclipse.osee.ats.api.workflow.ActionResult;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.INewActionListener;
import org.eclipse.osee.ats.core.demo.DemoUtil;
import org.eclipse.osee.ats.core.workflow.state.TeamState;
import org.eclipse.osee.ats.rest.internal.demo.AbstractPopulateDemoDatabase;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.type.Pair;

public class Pdd23CreateNoBranchAction
extends AbstractPopulateDemoDatabase {
    public Pdd23CreateNoBranchAction(XResultData rd, AtsApi atsApi) {
        super(rd, atsApi);
    }

    @Override
    public void run() {
        this.rd.logf("Running [%s]...\n", new Object[]{this.getClass().getSimpleName()});
        String title = "SAW (no-branch) Even More Requirement Changes for Diagram View";
        Collection aias = DemoUtil.getActionableItems((ArtifactToken[])new ArtifactToken[]{DemoArtifactToken.SAW_Code_AI, DemoArtifactToken.SAW_SW_Design_AI, DemoArtifactToken.SAW_Requirements_AI, DemoArtifactToken.SAW_Test_AI});
        Date createdDate = new Date();
        AtsUser createdBy = this.atsApi.getUserService().getCurrentUser();
        String priority = "3";
        IAtsChangeSet changes = this.atsApi.createChangeSet(this.getClass().getSimpleName());
        ActionResult actionResult = this.atsApi.getActionService().createAction(null, title, "Problem with the Diagram View", ChangeTypes.Problem, priority, false, null, aias, createdDate, createdBy, Arrays.asList(new ArtifactTokenActionListener()), changes);
        changes.execute();
        IAtsTeamWorkflow reqTeamWf = null;
        for (IAtsTeamWorkflow teamWf : actionResult.getTeamWfs()) {
            Pair<IAtsTeamWorkflow, Result> result;
            boolean isSwDesign = teamWf.getTeamDefinition().getName().contains("SW Design");
            if (isSwDesign) {
                teamWf = this.transitionAndReload(teamWf, TeamState.Analyze);
                if (this.atsApi.getReviewService().getReviews(teamWf).size() != 1) {
                    throw new OseeCoreException("Error, 1 review should have been created instead of " + this.atsApi.getReviewService().getReviews(teamWf).size(), new Object[0]);
                }
                changes = this.atsApi.createChangeSet("Transition Workflows");
                for (IAtsAbstractReview review : this.atsApi.getReviewService().getReviews(teamWf)) {
                    changes.setSoleAttributeValue((IAtsWorkItem)review, (AttributeTypeToken)AtsAttributeTypes.ReviewBlocks, ReviewBlockType.None.name());
                }
                changes.execute();
                teamWf = this.reload(teamWf);
                teamWf = this.transitionAndReload(teamWf, TeamState.Authorize);
                teamWf = this.reload(teamWf);
                if (this.atsApi.getReviewService().getReviews(teamWf).size() != 2) {
                    throw new OseeCoreException("Error, 2 atsApi.getReviewService().getReviews(teamWf) should exist instead of " + this.atsApi.getReviewService().getReviews(teamWf).size(), new Object[0]);
                }
                changes = this.atsApi.createChangeSet("Transition Workflows");
                for (IAtsAbstractReview review : this.atsApi.getReviewService().getReviews(teamWf)) {
                    changes.setSoleAttributeValue((IAtsWorkItem)review, (AttributeTypeToken)AtsAttributeTypes.ReviewBlocks, ReviewBlockType.None.name());
                }
                changes.execute();
                teamWf = this.reload(teamWf);
            }
            if (((Result)(result = this.transitionToWithPersist(teamWf, TeamState.Implement, (AtsUser)teamWf.getAssignees().iterator().next(), teamWf.getAssignees(), this.atsApi)).getSecond()).isFalse()) {
                throw new OseeStateException("Error transitioning " + ((Result)result.getSecond()).toString(), new Object[0]);
            }
            teamWf = (IAtsTeamWorkflow)result.getFirst();
            if (!(teamWf = this.setVersionAndReload(teamWf, (ArtifactToken)DemoArtifactToken.SAW_Bld_2)).getTeamDefinition().getName().contains("Requirements")) continue;
            reqTeamWf = teamWf;
        }
        if (reqTeamWf == null) {
            throw new OseeArgumentException("Can't locate Req team.", new Object[0]);
        }
    }

    private static class ArtifactTokenActionListener
    implements INewActionListener {
        private ArtifactTokenActionListener() {
        }

        public ArtifactToken getArtifactToken(List<IAtsActionableItem> applicableAis) {
            if (applicableAis.iterator().next().equals(DemoArtifactToken.SAW_Test_AI)) {
                return DemoArtifactToken.SAW_NoBranch_Test_TeamWf;
            }
            if (applicableAis.iterator().next().equals(DemoArtifactToken.SAW_Code_AI)) {
                return DemoArtifactToken.SAW_NoBranch_Code_TeamWf;
            }
            if (applicableAis.iterator().next().equals(DemoArtifactToken.SAW_Requirements_AI)) {
                return DemoArtifactToken.SAW_NoBranch_Req_TeamWf;
            }
            if (applicableAis.iterator().next().equals(DemoArtifactToken.SAW_SW_Design_AI)) {
                return DemoArtifactToken.SAW_NoBranch_SWDesign_TeamWf;
            }
            throw new UnsupportedOperationException();
        }
    }
}

