/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.demo;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.branch.BranchData;
import org.eclipse.osee.ats.api.demo.DemoArtifactToken;
import org.eclipse.osee.ats.api.demo.DemoCscis;
import org.eclipse.osee.ats.api.team.ChangeTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.ActionResult;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.INewActionListener;
import org.eclipse.osee.ats.core.demo.DemoUtil;
import org.eclipse.osee.ats.core.workflow.state.TeamState;
import org.eclipse.osee.ats.rest.internal.demo.AbstractPopulateDemoDatabase;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.DemoSubsystems;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public class Pdd20CreateCommittedAction
extends AbstractPopulateDemoDatabase {
    public Pdd20CreateCommittedAction(XResultData rd, AtsApi atsApi) {
        super(rd, atsApi);
    }

    @Override
    public void run() {
        this.rd.logf("Running [%s]...\n", new Object[]{this.getClass().getSimpleName()});
        Collection aias = DemoUtil.getActionableItems((AtsApi)this.atsApi, (ArtifactToken[])new ArtifactToken[]{DemoArtifactToken.SAW_Requirements_AI, DemoArtifactToken.SAW_Code_AI, DemoArtifactToken.SAW_Test_AI});
        Date createdDate = new Date();
        AtsUser createdBy = this.atsApi.getUserService().getCurrentUser();
        String priority = "1";
        IAtsChangeSet changes = this.atsApi.createChangeSet(String.valueOf(this.getClass().getSimpleName()) + " - 1");
        ActionResult actionResult = this.atsApi.getActionService().createAction(null, "SAW (committed) Reqt Changes for Diagram View", "Problem with the Diagram View", ChangeTypes.Problem, priority, false, null, aias, createdDate, createdBy, Arrays.asList(new ArtifactTokenActionListener()), changes);
        changes.execute();
        IAtsTeamWorkflow reqTeamWf = null;
        for (IAtsTeamWorkflow teamWf : actionResult.getTeamWfs()) {
            if (teamWf.getTeamDefinition().getName().contains("Req") && !teamWf.getWorkDefinition().getName().equals("WorkDef_Team_Demo_Req")) {
                throw new OseeCoreException("Req workflow expected work def [WorkDef_Team_Demo_Req] actual [%s]", new Object[]{teamWf.getWorkDefinition().getName()});
            }
            if (teamWf.getTeamDefinition().getName().contains("Code") && !teamWf.getWorkDefinition().getName().equals("WorkDef_Team_Demo_Code")) {
                throw new OseeCoreException("Code workflow expected work def [WorkDef_Team_Demo_Code] actual [%s]", new Object[]{teamWf.getWorkDefinition().getName()});
            }
            if (teamWf.getTeamDefinition().getName().contains("Test") && !teamWf.getWorkDefinition().getName().equals("WorkDef_Team_Demo_Test")) {
                throw new OseeCoreException("Test workflow expected work def [WorkDef_Team_Demo_Test] actual [%s]", new Object[]{teamWf.getWorkDefinition().getName()});
            }
            Pair<IAtsTeamWorkflow, Result> result = this.transitionToWithPersist(teamWf, TeamState.Implement, (AtsUser)teamWf.getAssignees().iterator().next(), teamWf.getAssignees(), this.atsApi);
            if (((Result)result.getSecond()).isFalse()) {
                throw new OseeCoreException("Error transitioning [%s] to state [%s]: [%s]", new Object[]{teamWf.toStringWithId(), TeamState.Implement.getName(), ((Result)result.getSecond()).getText()});
            }
            teamWf = (IAtsTeamWorkflow)result.getFirst();
            if (!(teamWf = this.setVersionAndReload(teamWf, (ArtifactToken)DemoArtifactToken.SAW_Bld_2)).getTeamDefinition().getName().contains("Requirements")) continue;
            reqTeamWf = teamWf;
        }
        if (reqTeamWf == null) {
            throw new OseeArgumentException("Can't locate Req team.", new Object[0]);
        }
        Result result = this.atsApi.getBranchService().createWorkingBranchValidate(reqTeamWf);
        if (result.isFalse()) {
            throw new OseeArgumentException("Error creating working branch: " + result, new Object[0]);
        }
        BranchData bData = this.atsApi.getBranchService().createWorkingBranch(reqTeamWf);
        if (bData.getResults().isErrors()) {
            throw new OseeStateException("Error creating working branch %s\n", new Object[]{bData.getResults().toString()});
        }
        if (bData.getNewBranch().isInvalid()) {
            throw new OseeStateException("New Branch is invalid\n", new Object[0]);
        }
        BranchToken workingBranch = this.atsApi.getBranchService().getWorkingBranchPend(reqTeamWf);
        if (workingBranch.isInvalid()) {
            throw new OseeStateException("Working Branch is invalid\n", new Object[0]);
        }
        changes = this.atsApi.createChangeSet(String.valueOf(this.getClass().getSimpleName()) + " - 2", workingBranch);
        for (ArtifactToken art : DemoUtil.getSoftwareRequirements((boolean)false, (DemoUtil.SoftwareRequirementStrs)DemoUtil.SoftwareRequirementStrs.Robot, (BranchToken)workingBranch)) {
            changes.setSoleAttributeValue((ArtifactId)art, (AttributeTypeToken)CoreAttributeTypes.CSCI, (Object)DemoCscis.Navigation.name());
            changes.setSoleAttributeValue((ArtifactId)art, (AttributeTypeToken)CoreAttributeTypes.Subsystem, (Object)DemoSubsystems.Navigation.name());
            ArtifactToken navArt = this.atsApi.getQueryService().getArtifactFromName(CoreArtifactTypes.Component, DemoSubsystems.Navigation.name(), workingBranch);
            changes.relate((ArtifactId)art, CoreRelationTypes.Allocation_Component, (ArtifactId)navArt);
        }
        ArtifactToken testArtifactToken = null;
        ArtifactToken testRelArtifactToken = null;
        for (ArtifactToken art : DemoUtil.getSoftwareRequirements((boolean)false, (DemoUtil.SoftwareRequirementStrs)DemoUtil.SoftwareRequirementStrs.Event, (BranchToken)workingBranch)) {
            changes.setSoleAttributeValue((ArtifactId)art, (AttributeTypeToken)CoreAttributeTypes.CSCI, (Object)DemoCscis.Interface.name());
            changes.setSoleAttributeValue((ArtifactId)art, (AttributeTypeToken)CoreAttributeTypes.Subsystem, (Object)DemoSubsystems.Communications.name());
            ArtifactToken robotArt = this.atsApi.getQueryService().getArtifactFromName(CoreArtifactTypes.Component, DemoSubsystems.Robot_API.name(), workingBranch);
            changes.relate((ArtifactId)art, CoreRelationTypes.Allocation_Component, (ArtifactId)robotArt);
            testArtifactToken = art;
            testRelArtifactToken = robotArt;
        }
        changes.execute();
        Conditions.requireNonNull(testArtifactToken);
        Conditions.requireNonNull(testRelArtifactToken);
        changes = this.atsApi.createChangeSet(String.valueOf(this.getClass().getSimpleName()) + " - 3", workingBranch);
        for (ArtifactToken art : DemoUtil.getSoftwareRequirements((boolean)false, (DemoUtil.SoftwareRequirementStrs)DemoUtil.SoftwareRequirementStrs.daVinci, (BranchToken)workingBranch)) {
            changes.deleteArtifact((ArtifactId)art);
        }
        ArtifactToken parentArt = DemoUtil.getInterfaceInitializationSoftwareRequirement((boolean)false, (BranchToken)workingBranch);
        int x = 1;
        while (x < 4) {
            String name = "Robot Interface Init " + x;
            ArtifactToken newArt = changes.createArtifact(CoreArtifactTypes.SoftwareRequirementMsWord, name);
            changes.setSoleAttributeValue((ArtifactId)newArt, (AttributeTypeToken)CoreAttributeTypes.Subsystem, (Object)DemoSubsystems.Communications.name());
            changes.addChild((ArtifactId)parentArt, (ArtifactId)newArt);
            ++x;
        }
        changes.execute();
        ArtifactToken parentArtifactToken = this.testCommitBranchHttpRequestOperationSetup(reqTeamWf, testArtifactToken, testRelArtifactToken);
        XResultData rd = this.atsApi.getBranchService().commitWorkingBranch(reqTeamWf, false, true, (BranchId)this.atsApi.getBranchService().getBranch((IAtsConfigObject)this.atsApi.getVersionService().getTargetedVersion((IAtsWorkItem)reqTeamWf)), true, new XResultData());
        if (rd.isErrors()) {
            throw new OseeCoreException(rd.toString(), new Object[0]);
        }
        BranchToken parentBranch = this.atsApi.getBranchService().getBranch((BranchId)parentArtifactToken.getBranch());
        parentArtifactToken = this.atsApi.getQueryService().getArtifact((ArtifactId)parentArtifactToken.getToken(), (BranchId)parentBranch);
        ArtifactToken testRelArtifact = this.atsApi.getQueryService().getArtifact((ArtifactId)testRelArtifactToken.getToken(), (BranchId)parentBranch);
        this.testCommitBranchHttpRequestOperation(testRelArtifact, parentArtifactToken, parentBranch);
    }

    private void testCommitBranchHttpRequestOperation(ArtifactToken testRelArtifact, ArtifactToken parentArtifact, BranchToken parentBranch) {
        int loops = 1;
        int x = 0;
        while (x <= loops) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            String subsystemStrAfter = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)parentArtifact, (AttributeTypeToken)CoreAttributeTypes.Subsystem, (Object)"");
            if (!subsystemStrAfter.equals(DemoSubsystems.Communications.name())) {
                if (x >= loops) {
                    throw new OseeArgumentException("ArtifactToken Attribute did not update in Parent Branch after commit", new Object[0]);
                }
            } else {
                ArtifactToken testRelOnSameBranch = ArtifactToken.valueOf((ArtifactToken)testRelArtifact, (BranchToken)parentBranch);
                if (!this.atsApi.getRelationResolver().getRelated((ArtifactId)parentArtifact, CoreRelationTypes.Allocation_Component).contains(testRelOnSameBranch) && x >= loops) {
                    throw new OseeArgumentException("ArtifactToken Relation does NOT exist in Parent branch after commit.", new Object[0]);
                }
            }
            ++x;
        }
    }

    private ArtifactToken testCommitBranchHttpRequestOperationSetup(IAtsTeamWorkflow reqTeamArt, ArtifactToken testArtifact, ArtifactToken testRelArtifact) {
        BranchToken parentBranch = this.atsApi.getBranchService().getBranch((IAtsConfigObject)this.atsApi.getVersionService().getTargetedVersion((IAtsWorkItem)reqTeamArt));
        ArtifactToken parentArtifactToken = this.atsApi.getQueryService().getArtifact((ArtifactId)testArtifact.getToken(), (BranchId)parentBranch);
        String subsystemStrBefore = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)parentArtifactToken, (AttributeTypeToken)CoreAttributeTypes.Subsystem, (Object)"");
        if (subsystemStrBefore.equals(DemoSubsystems.Communications.name())) {
            throw new OseeArgumentException("ArtifactToken Attribute matches between Working and Parent branch before commit.  Invalid Test. ", new Object[0]);
        }
        for (ArtifactToken art : this.atsApi.getRelationResolver().getRelatedArtifacts((ArtifactId)parentArtifactToken, CoreRelationTypes.Allocation_Component)) {
            if (art.getId() != testRelArtifact.getId()) continue;
            throw new OseeArgumentException("ArtifactToken Relation exists in Working and Parent branch before commit.  Invalid Test. ", new Object[0]);
        }
        return parentArtifactToken;
    }

    private class ArtifactTokenActionListener
    implements INewActionListener {
        private ArtifactTokenActionListener() {
        }

        public ArtifactToken getArtifactToken(List<IAtsActionableItem> applicableAis) {
            if (applicableAis.iterator().next().equals(DemoArtifactToken.SAW_Test_AI)) {
                return DemoArtifactToken.SAW_Commited_Test_TeamWf;
            }
            if (applicableAis.iterator().next().equals(DemoArtifactToken.SAW_Code_AI)) {
                return DemoArtifactToken.SAW_Commited_Code_TeamWf;
            }
            if (applicableAis.iterator().next().equals(DemoArtifactToken.SAW_Requirements_AI)) {
                return DemoArtifactToken.SAW_Commited_Req_TeamWf;
            }
            throw new UnsupportedOperationException();
        }
    }
}

