/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.IAtsDatabaseConversion;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.ElapsedTime;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public class ConvertWorkPackageArtsToStrAttr
implements IAtsDatabaseConversion {
    private static final String WFSEXIST = "wfsexist";
    private final boolean debug = false;
    private final String TITLE = "Convert Work Packages to String Attribute";
    private AtsApi atsApi;

    public void run(XResultData rd, boolean reportOnly, AtsApi atsApi) {
        this.atsApi = atsApi;
        List allWorkPackArts = atsApi.getQueryService().getArtifacts(AtsArtifactTypes.WorkPackage);
        this.validateWorkPackages(allWorkPackArts, rd);
        List<ArtifactToken> referencedWorkPackArts = this.deleteUnusedWorkPackages(allWorkPackArts, rd, reportOnly, atsApi);
        this.convertWorkItemsToStringAttr(referencedWorkPackArts, rd, reportOnly, atsApi);
        this.convertActivityIdToWorkPkgAttr(rd, reportOnly, atsApi);
        rd.log("Complete");
    }

    private void validateWorkPackages(List<ArtifactToken> workPackArts, XResultData rd) {
        for (ArtifactToken workPackArt : workPackArts) {
            try {
                Pair<String, String> idAndFull = this.getId(workPackArt);
                System.err.println("Id: " + (String)idAndFull.getFirst());
            }
            catch (Exception exception) {
                System.err.println("Exception on " + workPackArt.getId());
            }
        }
    }

    private Pair<String, String> getId(ArtifactToken workPackArt) {
        String activityId = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)workPackArt, (AttributeTypeToken)AtsAttributeTypes.ActivityId, (Object)"Unknown");
        String workPkgId = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)workPackArt, (AttributeTypeToken)AtsAttributeTypes.WorkPackageId, (Object)"Unknown");
        String id = String.format("wpid: %s actId: %s artId: %s", workPkgId, activityId, workPackArt.getIdString());
        return new Pair((Object)id, (Object)id);
    }

    private List<ArtifactToken> deleteUnusedWorkPackages(List<ArtifactToken> workPackArts, XResultData rd, boolean reportOnly, AtsApi atsApi) {
        ArrayList<ArtifactToken> referencedWorkPackArts = new ArrayList<ArtifactToken>();
        int size = workPackArts.size();
        int count = 1;
        List subDivide = Collections.subDivide(workPackArts, (int)200);
        for (Collection workPackArtsColl : subDivide) {
            IAtsChangeSet changes = null;
            if (!reportOnly) {
                changes = atsApi.createChangeSet(String.valueOf(this.getName()) + " - Delete", AtsCoreUsers.SYSTEM_USER);
            }
            for (ArtifactToken workPackArt : workPackArtsColl) {
                System.err.println(String.format("Processing %s/%s...", count++, size));
                if (atsApi.getAttributeResolver().hasTag(workPackArt, WFSEXIST)) {
                    System.err.println("---> Skipping already processed: " + workPackArt.getIdString());
                    referencedWorkPackArts.add(workPackArt);
                    continue;
                }
                ElapsedTime time3 = new ElapsedTime("Load work package wfs");
                Collection wfArts = atsApi.getQueryService().getArtifacts(AtsArtifactTypes.AbstractWorkflowArtifact, (AttributeTypeToken)AtsAttributeTypes.WorkPackageReference, workPackArt.getIdString(), atsApi.getAtsBranch());
                System.err.println("orcs query 2 found " + wfArts.size());
                time3.end(ElapsedTime.Units.SEC);
                String msg = String.format("Work Package %s found %s workItems\n", workPackArt.getIdString(), wfArts.size());
                System.err.print(msg);
                rd.logf(msg, new Object[0]);
                if (wfArts.isEmpty()) {
                    String delMsg = "---> Need to delete work package " + workPackArt.getIdString();
                    System.err.println(delMsg);
                    rd.logf(delMsg, new Object[0]);
                    if (reportOnly) continue;
                    changes.deleteArtifact((ArtifactId)workPackArt);
                    continue;
                }
                if (reportOnly) continue;
                changes.addTag(workPackArt, WFSEXIST);
                referencedWorkPackArts.add(workPackArt);
            }
            if (reportOnly || changes.isEmpty()) continue;
            TransactionToken tx = changes.execute();
            rd.logf("Transaction %s\n", new Object[]{tx.getIdString()});
        }
        return referencedWorkPackArts;
    }

    private void convertActivityIdToWorkPkgAttr(XResultData rd, boolean reportOnly, AtsApi atsApi) {
        try {
            Collection workItems = atsApi.getQueryService().getWorkItemsAtrTypeExists((AttributeTypeToken)AtsAttributeTypes.ActivityId);
            int size = workItems.size();
            int count = 1;
            IAtsChangeSet changes = null;
            if (!reportOnly) {
                changes = atsApi.createChangeSet(String.valueOf(this.getName()) + " - Convert", AtsCoreUsers.SYSTEM_USER);
            }
            for (IAtsWorkItem workItem : workItems) {
                System.err.println(String.format("Convert: Processing %s/%s...", count++, size));
                List actIds = atsApi.getAttributeResolver().getAttributesToStringList((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.ActivityId);
                if (actIds.isEmpty()) continue;
                String msg = String.format("Activity Id(s) [%s] needs to be converted for %s", Collections.toString((String)",", (Iterable)actIds), workItem.toStringWithId());
                System.err.println(msg);
                rd.log(String.valueOf(msg) + "\n");
                if (reportOnly) continue;
                changes.deleteAttributes((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.ActivityId);
                changes.setAttributeValues((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.WorkPackage, Collections.cast((Collection)actIds));
                rd.log("---> set and removed ref\n");
            }
            if (!reportOnly && !changes.isEmpty()) {
                TransactionToken tx = changes.execute();
                System.err.println("Transaction: " + tx.getIdString());
                rd.logf("Transaction %s\n", new Object[]{tx.getIdString()});
            }
        }
        catch (Exception ex) {
            System.err.println(Lib.exceptionToString((Exception)ex));
            rd.errorf("Exception processing ... %s\n", new Object[]{ex.getLocalizedMessage()});
        }
    }

    private void convertWorkItemsToStringAttr(List<ArtifactToken> referencedWorkPackArts, XResultData rd, boolean reportOnly, AtsApi atsApi) {
        try {
            int size = referencedWorkPackArts.size();
            int count = 1;
            List subDivide = Collections.subDivide(referencedWorkPackArts, (int)400);
            for (Collection workPackArtsColl : subDivide) {
                IAtsChangeSet changes = null;
                if (!reportOnly) {
                    changes = atsApi.createChangeSet(String.valueOf(this.getName()) + " - Convert", AtsCoreUsers.SYSTEM_USER);
                }
                for (ArtifactToken workPackArt : workPackArtsColl) {
                    System.err.println(String.format("Convert: Processing %s/%s...", count++, size));
                    ElapsedTime time3 = new ElapsedTime("Load work package wfs");
                    Collection workflowArts = atsApi.getQueryService().getArtifacts(AtsArtifactTypes.AbstractWorkflowArtifact, (AttributeTypeToken)AtsAttributeTypes.WorkPackageReference, workPackArt.getIdString(), atsApi.getAtsBranch());
                    System.err.println("query found " + workflowArts.size() + " for wp " + workPackArt.toStringWithId());
                    time3.end(ElapsedTime.Units.SEC);
                    if (workflowArts.isEmpty()) {
                        if (!reportOnly) {
                            changes.deleteArtifact((ArtifactId)workPackArt);
                            System.err.println("---> Deleted unused work package: " + workPackArt.toStringWithId());
                        } else {
                            System.err.println("---> Delete unused work package: " + workPackArt.toStringWithId());
                        }
                    }
                    for (ArtifactToken workflowArt : workflowArts) {
                        Pair<String, String> idAndFull = this.getId(workPackArt);
                        String storeId = (String)idAndFull.getFirst();
                        String msg = String.format("Work Package [%s] to be set on %s", storeId, workflowArt.toStringWithId());
                        System.err.println(msg);
                        rd.log(String.valueOf(msg) + "\n");
                        atsApi.getWorkItemService().getWorkItem(workflowArt);
                        if (reportOnly) {
                            System.err.println("---> need to set and removed ref");
                            continue;
                        }
                        changes.setSoleAttributeValue((ArtifactId)workflowArt, (AttributeTypeToken)AtsAttributeTypes.WorkPackage, (Object)storeId);
                        changes.deleteAttributes((ArtifactId)workflowArt, (AttributeTypeToken)AtsAttributeTypes.WorkPackageReference);
                        System.err.println("---> set and removed ref");
                    }
                }
                if (reportOnly || changes.isEmpty()) continue;
                TransactionToken tx = changes.execute();
                System.err.println("Transaction: " + tx.getIdString());
                rd.logf("Transaction %s\n", new Object[]{tx.getIdString()});
            }
        }
        catch (Exception ex) {
            System.err.println(Lib.exceptionToString((Exception)ex));
            rd.errorf("Exception processing ... %s\n", new Object[]{ex.getLocalizedMessage()});
        }
    }

    public String getDescription() {
        StringBuffer data = new StringBuffer();
        data.append("Convert Work Packages to String Attribute");
        data.append("This will create new attrs as needed and delete work package artifacts.\nCan be run multiple times without corruption.\nShould be run periodically on 0.26.11\n");
        return data.toString();
    }

    public String getName() {
        return "Convert Work Packages to String Attribute";
    }
}

