/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.IAtsDatabaseConversion;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;

public class ConvertMeetingAttendeesToIdAttr
implements IAtsDatabaseConversion {
    private final String TITLE = "Convert UserId Meeting Attendees to ArtifactId";

    public void run(XResultData rd, boolean reportOnly, AtsApi atsApi) {
        Iterator iterator;
        Collection reviews = atsApi.getQueryService().getWorkItemsAtrTypeExists((AttributeTypeToken)AtsAttributeTypes.MeetingAttendeeUserId);
        IAtsChangeSet changes = null;
        if (!reportOnly) {
            changes = atsApi.createChangeSet("MeetingAttendeeUserId - Convert", AtsCoreUsers.SYSTEM_USER);
        }
        if ((iterator = reviews.iterator()).hasNext()) {
            IAtsWorkItem review = (IAtsWorkItem)iterator.next();
            ArrayList<ArtifactId> meetingAttendees = new ArrayList<ArtifactId>();
            for (String userId : atsApi.getAttributeResolver().getAttributesToStringList((ArtifactId)review.getStoreObject(), (AttributeTypeToken)AtsAttributeTypes.MeetingAttendeeUserId)) {
                AtsUser user = atsApi.getUserService().getUserByUserId(userId);
                if (user == null || meetingAttendees.contains(user.getArtifactId())) continue;
                meetingAttendees.add(user.getArtifactId());
            }
            if (changes != null) {
                changes.setAttributeValues((IAtsObject)review, (AttributeTypeToken)AtsAttributeTypes.MeetingAttendeeId, meetingAttendees);
            }
            rd.logf("Converting Meeting Attendees for %s\n", new Object[]{review.toStringWithId()});
        }
        if (!reportOnly && changes != null && !changes.isEmpty()) {
            TransactionToken tx = changes.executeIfNeeded();
            System.err.println("Transaction: " + tx.getIdString());
            rd.logf("Transaction %s\n", new Object[]{tx.getIdString()});
        }
    }

    public String getName() {
        return "Convert UserId Meeting Attendees to ArtifactId";
    }

    public String getDescription() {
        return "Converts all Peer Review artifact meeting assignee attrs from UserId to user ArtifactId";
    }
}

