/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.ai.ActionableItem;
import org.eclipse.osee.ats.api.branch.BranchData;
import org.eclipse.osee.ats.api.column.AtsColumnUtil;
import org.eclipse.osee.ats.api.column.AtsCoreAttrTokColumnToken;
import org.eclipse.osee.ats.api.config.AtsConfigEndpointApi;
import org.eclipse.osee.ats.api.config.AtsConfigurations;
import org.eclipse.osee.ats.api.config.ColumnAlign;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.data.AtsArtifactImages;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.util.ColumnType;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.rest.AtsApiServer;
import org.eclipse.osee.ats.rest.internal.config.UpdateAtsConfiguration;
import org.eclipse.osee.ats.rest.internal.config.operation.AtsConfigOperations;
import org.eclipse.osee.ats.rest.internal.config.operation.ConvertAtsAisAndTeamDefsOperation;
import org.eclipse.osee.ats.rest.internal.demo.AtsDbConfigDemoOp;
import org.eclipse.osee.ats.rest.internal.demo.AtsDbConfigPopulateDemoDbAndTestOp;
import org.eclipse.osee.ats.rest.internal.util.health.AtsHealthCheckOperation;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactImage;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.executor.ExecutorAdmin;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.result.table.ExampleTableData;
import org.eclipse.osee.framework.jdk.core.type.ViewModel;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.orcs.OrcsApi;

public final class AtsConfigEndpointImpl
implements AtsConfigEndpointApi {
    private final OrcsApi orcsApi;
    private final AtsApi atsApi;
    private final ExecutorAdmin executorAdmin;
    private List<ArtifactImage> images;
    private final JdbcService jdbcService;
    private final Runnable getConfigService = new Runnable(){

        @Override
        public void run() {
            AtsConfigEndpointImpl.this.atsApi.getConfigService().getConfigurationsWithPend();
        }
    };

    public AtsConfigEndpointImpl(AtsApiServer atsApi, OrcsApi orcsApi, JdbcService jdbcService, ExecutorAdmin executorAdmin) {
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
        this.jdbcService = jdbcService;
        this.executorAdmin = executorAdmin;
    }

    public AtsConfigurations clearCachesWithPend() {
        return this.atsApi.getConfigService().getConfigurationsWithPend();
    }

    public String requestCacheReload() {
        this.executorAdmin.submit("REST requested ATS configuration cache reload", this.getConfigService);
        return "ATS configuration cache reload request submitted.";
    }

    public String convertAisAndTeamDefs() {
        ConvertAtsAisAndTeamDefsOperation op = new ConvertAtsAisAndTeamDefsOperation(this.atsApi);
        XResultData rd = op.run();
        rd.sortResults();
        return rd.getHtml();
    }

    public AtsConfigurations get() {
        return this.atsApi.getConfigService().getConfigurations();
    }

    public List<ArtifactImage> getArtifactImages() {
        if (this.images == null) {
            this.images = new LinkedList<ArtifactImage>();
            this.images.addAll(AtsArtifactImages.getImages());
            for (ArtifactTypeToken artifactType : AtsArtifactTypes.TeamWorkflow.getAllDescendantTypes()) {
                this.images.add(ArtifactImage.construct((ArtifactTypeToken)artifactType, (String)AtsArtifactImages.AGILE_TASK.getImageName(), (String)AtsArtifactImages.AGILE_TASK.getBaseUrl()));
            }
        }
        return this.images;
    }

    public AtsConfigurations getWithPend() {
        return this.atsApi.getConfigService().getConfigurationsWithPend();
    }

    public ViewModel getNewSource() {
        return new ViewModel("templates/newConfigBranch.html");
    }

    public XResultData createUpdateConfig() {
        XResultData resultData = new XResultData(false);
        UpdateAtsConfiguration update = new UpdateAtsConfiguration(this.atsApi, this.orcsApi);
        update.createUpdateConfig(resultData);
        if (resultData.isEmpty()) {
            resultData.log("Nothing to update");
        }
        return resultData;
    }

    public List<AtsCoreAttrTokColumnToken> generateAttrTypeViews() {
        HashMap<String, AttributeTypeToken> idToToken = new HashMap<String, AttributeTypeToken>();
        for (AttributeTypeToken attrType : this.orcsApi.tokenService().getAttributeTypes()) {
            idToToken.put(attrType.getName(), attrType);
        }
        LinkedList sortedIds = new LinkedList();
        sortedIds.addAll(idToToken.keySet());
        Collections.sort(sortedIds);
        LinkedList<AtsCoreAttrTokColumnToken> columns = new LinkedList<AtsCoreAttrTokColumnToken>();
        for (String id : sortedIds) {
            AttributeTypeToken attrType = (AttributeTypeToken)idToToken.get(id);
            ColumnAlign columnAlign = AtsColumnUtil.getColumnAlign((AttributeTypeToken)attrType);
            ColumnType columnType = AtsColumnUtil.getColumnType((AttributeTypeToken)attrType);
            int width = AtsColumnUtil.getColumnWidth((AttributeTypeToken)attrType);
            AtsCoreAttrTokColumnToken valueColumn = new AtsCoreAttrTokColumnToken();
            valueColumn.setAttrTypeId(attrType.getId().longValue());
            valueColumn.setAttrTypeName(attrType.getName());
            valueColumn.setWidth(width);
            valueColumn.setAlign(columnAlign);
            valueColumn.setVisible(true);
            valueColumn.setColumnType(columnType.name());
            valueColumn.setColumnMultiEdit(true);
            valueColumn.setDescription(attrType.getDescription());
            valueColumn.setNamespace("org.eclipse.osee.ats.WorldXViewer");
            String name = attrType.getName().replaceAll("^.*\\.", "");
            valueColumn.setName(name);
            valueColumn.setId(this.generateId(attrType.getName(), name));
            if (attrType.isBoolean()) {
                valueColumn.setBooleanNotSetShow("");
                valueColumn.setBooleanOnFalseShow("false");
                valueColumn.setBooleanOnTrueShow("true");
            }
            columns.add(valueColumn);
        }
        return columns;
    }

    private String generateId(String id, String name) {
        String cleanName = name.replaceAll("-", " ");
        cleanName = cleanName.replaceAll("\\(", " ");
        cleanName = cleanName.replaceAll("\\)", " ");
        cleanName = cleanName.replaceAll("/", " ");
        cleanName = cleanName.replaceAll(" +", " ");
        cleanName = cleanName.replaceAll("^ ", "");
        String replaceValue = Lib.toCamelCaseFromStringsWithSpaces((String)cleanName);
        String result = id.replaceFirst(Lib.escapeForRegex((String)name), replaceValue);
        return result;
    }

    public XResultData alive() {
        XResultData results = new XResultData();
        results.logf("Alive", new Object[0]);
        return results;
    }

    public XResultData atsDbInit() {
        XResultData rd = new XResultData();
        try {
            rd = this.atsApi.getConfigService().configAtsDatabase(this.atsApi);
        }
        catch (Exception ex) {
            rd.error(Lib.exceptionToString((Exception)ex));
        }
        return rd;
    }

    public XResultData demoDbInit() {
        XResultData rd = new XResultData();
        try {
            AtsDbConfigDemoOp config = new AtsDbConfigDemoOp(rd, this.atsApi);
            config.run();
        }
        catch (Exception ex) {
            rd.error(Lib.exceptionToString((Exception)ex));
        }
        return rd;
    }

    public XResultData demoDbPopulate() {
        XResultData rd = new XResultData();
        try {
            AtsDbConfigPopulateDemoDbAndTestOp populateDemoDb = new AtsDbConfigPopulateDemoDbAndTestOp(rd, this.atsApi);
            populateDemoDb.run();
        }
        catch (Exception ex) {
            rd.error(Lib.exceptionToString((Exception)ex));
        }
        return rd;
    }

    public ActionableItem getActionableItem(ArtifactId aiId) {
        return this.atsApi.getActionableItemService().getActionableItemById(aiId);
    }

    public Version getVersion(ArtifactId verId) {
        return this.atsApi.getVersionService().getVersionById(verId);
    }

    public Version createVersion(String name, String description, ArtifactId teamId) {
        return this.atsApi.getVersionService().createVersion(name, description, teamId);
    }

    public Collection<IAtsVersion> getParallelVersions(ArtifactId verId) {
        Version ver = this.getVersion(verId);
        return this.atsApi.getVersionService().getParallelVersions((IAtsVersion)ver);
    }

    public Collection<IAtsVersion> getAllParallelVersions(ArtifactId verId) {
        return this.atsApi.getVersionService().getParallelVersionsRecursive(verId);
    }

    public TeamDefinition getTeamDefinition(ArtifactId teamDefId) {
        return this.atsApi.getTeamDefinitionService().getTeamDefinitionById(teamDefId);
    }

    public List<ArtifactToken> getTeamLeads(ArtifactId teamDefId) {
        return this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.User}).andRelatedTo(AtsRelationTypes.TeamLead_Team, teamDefId).asArtifactTokens();
    }

    public TransactionId demoInitilize(UserToken superUser) {
        TransactionId txId = this.orcsApi.getAdminOps().createDatastoreAndSystemBranches(superUser);
        this.orcsApi.getAdminOps().createDemoBranches();
        this.atsApi.getConfigService().configAtsDatabase(this.atsApi);
        return txId;
    }

    public XResultData validate() {
        AtsHealthCheckOperation op = new AtsHealthCheckOperation(this.orcsApi, this.atsApi, this.jdbcService);
        return op.run();
    }

    public XResultData getResultTableTest() {
        return ExampleTableData.getResultTable();
    }

    public BranchData createBranch(BranchData branchData) {
        AtsConfigOperations ops = new AtsConfigOperations(this.atsApi);
        return ops.createBranch(branchData);
    }

    public XResultData configForDemoPl(BranchId branch) {
        try {
            this.orcsApi.getAdminOps().configForDemoPl(branch);
        }
        catch (Exception ex) {
            XResultData rd = new XResultData();
            rd.errorf("Error configForDemoPl %s", new Object[]{Lib.exceptionToString((Exception)ex)});
            return rd;
        }
        return XResultData.EMPTY_RD;
    }

    public ArtifactId getBranchView(ArtifactId version) {
        Version ver = this.atsApi.getVersionService().getVersionById(version, false);
        if (ver != null) {
            return this.atsApi.getBranchService().getBranchView((IAtsVersion)ver);
        }
        return ArtifactId.SENTINEL;
    }

    public Collection<ArtifactToken> getBranchViews(ArtifactId version) {
        Version ver = this.atsApi.getVersionService().getVersionById(version);
        if (ver != null) {
            return this.atsApi.getBranchService().getBranchViews((IAtsVersion)ver);
        }
        return Collections.emptyList();
    }

    public TransactionToken setBranchView(ArtifactId version, ArtifactId branchView) {
        Version ver = this.atsApi.getVersionService().getVersionById(version);
        if (ver != null) {
            return this.atsApi.getBranchService().setBranchView((IAtsVersion)ver, branchView);
        }
        return TransactionToken.SENTINEL;
    }
}

