/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.branch;

import java.util.Arrays;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.branch.BranchData;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.CreateBranchData;

public class AtsBranchOperations {
    private final AtsApi atsApi;
    private final OrcsApi orcsApi;

    public AtsBranchOperations(AtsApi atsApi, OrcsApi orcsApi) {
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
    }

    public BranchData createBranch(BranchData bd) {
        this.atsApi.getBranchService().validate(bd, this.atsApi);
        if (bd.isValidate() && bd.getResults().isErrors()) {
            return bd;
        }
        CreateBranchData cbd = new CreateBranchData();
        BranchType type = bd.getBranchType();
        ArtifactToken assocArt = bd.getAssociatedArt();
        if (type.equals((Object)BranchType.BASELINE) && assocArt.isInvalid()) {
            assocArt = AtsArtifactToken.AtsCmAccessControl;
        } else if (assocArt.isInvalid()) {
            bd.getResults().errorf("Associated Artifact is invalid for %s branch", new Object[]{bd.getBranchType()});
            return bd;
        }
        cbd.setBranchType(type);
        cbd.setName(bd.getBranchName());
        cbd.setAssociatedArtifact((ArtifactId)assocArt);
        cbd.setCreationComment(bd.getCreationComment());
        cbd.setInheritAccess(true);
        cbd.setParentBranch(bd.getParent());
        cbd.setCategories(this.orcsApi.getQueryFactory().branchQuery().getBranchCategories(bd.getParent()));
        Branch newBranch = this.orcsApi.getBranchOps().createBranch(cbd);
        bd.getResults().setIds(Arrays.asList(newBranch.getIdString()));
        bd.setNewBranch(BranchId.valueOf((Long)newBranch.getId()));
        return bd;
    }
}

