/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.testscript.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.accessor.types.ArtifactAccessorResultWithoutGammas;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.rest.model.transaction.Attribute;
import org.eclipse.osee.orcs.rest.model.transaction.CreateArtifact;
import org.eclipse.osee.testscript.internal.ScriptLogToken;

public class TraceToken
extends ArtifactAccessorResultWithoutGammas {
    public static final TraceToken SENTINEL = new TraceToken();
    private List<ScriptLogToken> logs;

    public TraceToken(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public TraceToken(ArtifactReadable art) {
        super(art);
        this.setId(art.getId());
        this.setName(art.getName());
        this.setLogs(art.getRelated(CoreRelationTypes.TraceToScriptLog_ScriptLog).getList().stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new ScriptLogToken((ArtifactReadable)a)).collect(Collectors.toList()));
    }

    public TraceToken(Long id, String name) {
        super(id, name);
        this.setLogs(new LinkedList<ScriptLogToken>());
    }

    public TraceToken() {
    }

    public List<ScriptLogToken> getLogs() {
        return this.logs;
    }

    public void setLogs(List<ScriptLogToken> logs) {
        this.logs = logs;
    }

    public CreateArtifact createArtifact(String key) {
        HashMap values = new HashMap();
        CreateArtifact art = new CreateArtifact();
        art.setName(this.getName());
        art.setTypeId(CoreArtifactTypes.Trace.getIdString());
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        for (AttributeTypeToken type : CoreArtifactTypes.Trace.getValidAttributeTypes()) {
            String value = (String)values.get(type);
            if (Strings.isInValid((String)value)) continue;
            Attribute attr = new Attribute(type.getIdString());
            attr.setValue(Arrays.asList(value));
            attrs.add(attr);
        }
        art.setAttributes(attrs);
        art.setkey(key);
        return art;
    }
}

