/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.testscript.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.accessor.types.ArtifactAccessorResultWithoutGammas;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.rest.model.transaction.Attribute;
import org.eclipse.osee.orcs.rest.model.transaction.CreateArtifact;
import org.eclipse.osee.testscript.internal.AttentionLocationToken;
import org.eclipse.osee.testscript.internal.InfoGroupToken;

public class TestPointToken
extends ArtifactAccessorResultWithoutGammas {
    public static final TestPointToken SENTINEL = new TestPointToken();
    private Double testNumber;
    private String result;
    private String overallResult;
    private String resultType;
    private boolean interactive;
    private String groupName;
    private String groupType;
    private String groupOperator;
    private String expected;
    private String actual;
    private String requirement;
    private int elapsedTime;
    private int transmissionCount;
    private String notes;
    private List<AttentionLocationToken> locations;
    private List<TestPointToken> subTestPoints;
    private List<InfoGroupToken> infoGroups;

    public TestPointToken(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public TestPointToken(ArtifactReadable art) {
        super(art);
        this.setId(art.getId());
        this.setName(art.getName());
        this.setTestNumber((Double)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.TestNumber, (Object)0.0));
        this.setResult(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Result, ""));
        this.setOverallResult(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.OverallResult, ""));
        this.setResultType(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.ResultType, ""));
        this.setInteractive((Boolean)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Interactive, (Object)false));
        this.setGroupName(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.TestPointGroupName, ""));
        this.setGroupType(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.TestPointGroupType, ""));
        this.setGroupOperator(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.TestPointGroupOperator, ""));
        this.setExpected(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Expected, ""));
        this.setActual(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Actual, ""));
        this.setRequirement(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.TestPointRequirement, ""));
        this.setElapsedTime((Integer)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.ElapsedTime, (Object)-1));
        this.setTransmissionCount((Integer)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.TransmissionCount, (Object)-1));
        this.setNotes(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Notes, ""));
        this.setLocations(art.getRelated(CoreRelationTypes.TestPointToAttentionLocation_AttentionLocation).getList().stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new AttentionLocationToken((ArtifactReadable)a)).collect(Collectors.toList()));
        this.setSubTestPoints(art.getRelated(CoreRelationTypes.TestPointGroupToTestPoint_TestPoint).getList().stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new TestPointToken((ArtifactReadable)a)).collect(Collectors.toList()));
        this.setInfoGroups(art.getRelated(CoreRelationTypes.TestPointToInfoGroup_InfoGroup).getList().stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new InfoGroupToken((ArtifactReadable)a)).collect(Collectors.toList()));
    }

    public TestPointToken(Long id, String name) {
        super(id, name);
        this.setTestNumber(0.0);
        this.setResult("");
        this.setOverallResult("");
        this.setResultType("");
        this.setInteractive(false);
        this.setGroupName("");
        this.setGroupType("");
        this.setGroupOperator("");
        this.setExpected("");
        this.setActual("");
        this.setRequirement("");
        this.setElapsedTime(-1);
        this.setTransmissionCount(-1);
        this.setNotes("");
        this.setLocations(new LinkedList<AttentionLocationToken>());
        this.setSubTestPoints(new LinkedList<TestPointToken>());
        this.setInfoGroups(new LinkedList<InfoGroupToken>());
    }

    public TestPointToken() {
    }

    public Double getTestNumber() {
        return this.testNumber;
    }

    public void setTestNumber(Double testNumber) {
        this.testNumber = testNumber;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getOverallResult() {
        return this.overallResult;
    }

    public void setOverallResult(String overallResult) {
        this.overallResult = overallResult;
    }

    @JsonIgnore
    public String getResultType() {
        return this.resultType;
    }

    public void setResultType(String resultType) {
        this.resultType = resultType;
    }

    public boolean getInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @JsonIgnore
    public String getGroupType() {
        return this.groupType;
    }

    public void setGroupType(String groupType) {
        this.groupType = groupType;
    }

    public String getGroupOperator() {
        return this.groupOperator;
    }

    public void setGroupOperator(String groupOperator) {
        this.groupOperator = groupOperator;
    }

    public String getExpected() {
        return this.expected;
    }

    public void setExpected(String expected) {
        this.expected = expected;
    }

    public String getActual() {
        return this.actual;
    }

    public void setActual(String actual) {
        this.actual = actual;
    }

    public String getRequirement() {
        return this.requirement;
    }

    public void setRequirement(String requirement) {
        this.requirement = requirement;
    }

    public int getElapsedTime() {
        return this.elapsedTime;
    }

    public void setElapsedTime(int elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    public int getTransmissionCount() {
        return this.transmissionCount;
    }

    public void setTransmissionCount(int transmissionCount) {
        this.transmissionCount = transmissionCount;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    @JsonIgnore
    public List<TestPointToken> getSubTestPoints() {
        return this.subTestPoints;
    }

    public void setSubTestPoints(List<TestPointToken> subTestPoints) {
        this.subTestPoints = subTestPoints;
    }

    @JsonIgnore
    public List<AttentionLocationToken> getLocations() {
        return this.locations;
    }

    public void setLocations(List<AttentionLocationToken> locations) {
        this.locations = locations;
    }

    @JsonIgnore
    public List<InfoGroupToken> getInfoGroups() {
        return this.infoGroups;
    }

    public void setInfoGroups(List<InfoGroupToken> infoGroups) {
        this.infoGroups = infoGroups;
    }

    public CreateArtifact createArtifact(String key) {
        HashMap<Object, String> values = new HashMap<Object, String>();
        values.put(CoreAttributeTypes.TestNumber, Double.toString(this.getTestNumber()));
        values.put(CoreAttributeTypes.Result, this.getResult());
        values.put(CoreAttributeTypes.ResultType, this.getResultType());
        values.put(CoreAttributeTypes.Interactive, Boolean.toString(this.getInteractive()));
        values.put(CoreAttributeTypes.TestPointGroupName, this.getGroupName());
        values.put(CoreAttributeTypes.TestPointGroupType, this.getGroupType());
        values.put(CoreAttributeTypes.TestPointGroupOperator, this.getGroupOperator());
        values.put(CoreAttributeTypes.Expected, this.getExpected());
        values.put(CoreAttributeTypes.Actual, this.getActual());
        values.put(CoreAttributeTypes.TestPointRequirement, this.getRequirement());
        values.put(CoreAttributeTypes.ElapsedTime, Integer.toString(this.getElapsedTime()));
        values.put(CoreAttributeTypes.TransmissionCount, Integer.toString(this.getTransmissionCount()));
        values.put(CoreAttributeTypes.Notes, this.getNotes());
        CreateArtifact art = new CreateArtifact();
        art.setName(this.getName());
        art.setTypeId(CoreArtifactTypes.TestPoint.getIdString());
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        for (AttributeTypeToken type : CoreArtifactTypes.TestPoint.getValidAttributeTypes()) {
            String value = (String)values.get(type);
            if (Strings.isInValid((String)value)) continue;
            Attribute attr = new Attribute(type.getIdString());
            attr.setValue(Arrays.asList(value));
            attrs.add(attr);
        }
        art.setAttributes(attrs);
        art.setkey(key);
        return art;
    }
}

