/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.testscript.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.testscript.ScriptResultApi;
import org.eclipse.osee.testscript.ScriptResultEndpoint;
import org.eclipse.osee.testscript.internal.ScriptResultToken;

public class ScriptResultEndpointImpl
implements ScriptResultEndpoint {
    private final ScriptResultApi scriptResultTypeApi;
    private final BranchId branch;

    public ScriptResultEndpointImpl(BranchId branch, ScriptResultApi scriptResultTypeApi) {
        this.scriptResultTypeApi = scriptResultTypeApi;
        this.branch = branch;
    }

    @Override
    public Collection<ScriptResultToken> getAllScriptResultTypes(String filter, ArtifactId viewId, long pageNum, long pageSize, AttributeTypeToken orderByAttributeType) {
        ArtifactId artifactId = viewId = viewId == null ? ArtifactId.SENTINEL : viewId;
        if (Strings.isValid((String)filter)) {
            return this.scriptResultTypeApi.getAllByFilter(this.branch, viewId, filter, pageNum, pageSize, (AttributeTypeId)orderByAttributeType);
        }
        return this.scriptResultTypeApi.getAll(this.branch, viewId, pageNum, pageSize, (AttributeTypeId)orderByAttributeType);
    }

    @Override
    public ScriptResultToken getScriptResultType(ArtifactId scriptResultTypeId) {
        return this.scriptResultTypeApi.get(this.branch, scriptResultTypeId);
    }

    @Override
    public int getCount(String filter, ArtifactId viewId) {
        return this.scriptResultTypeApi.getCountWithFilter(this.branch, viewId, filter);
    }

    @Override
    public List<ScriptResultToken> getScriptResultsByDef(ArtifactId scriptDefId) {
        try {
            ArrayList<ScriptResultToken> scriptResults = new ArrayList<ScriptResultToken>(this.scriptResultTypeApi.getAllByRelation(this.branch, CoreRelationTypes.TestScriptDefToTestScriptResults_TestScriptDef, scriptDefId));
            Collections.sort(scriptResults, Comparator.comparing(ScriptResultToken::getExecutionDate));
            return scriptResults;
        }
        catch (Exception exception) {
            return new LinkedList<ScriptResultToken>();
        }
    }

    @Override
    public Collection<ScriptResultToken> getAllForBatch(ArtifactId batchId, String filter, ArtifactId viewId, long pageNum, long pageSize, AttributeTypeToken orderByAttributeType) {
        return this.scriptResultTypeApi.getAllForBatch(this.branch, viewId, batchId, filter, pageNum, pageSize, (AttributeTypeId)orderByAttributeType);
    }

    @Override
    public int getAllForBatchCount(ArtifactId batchId, String filter, ArtifactId viewId) {
        return this.scriptResultTypeApi.getAllForBatchCount(this.branch, viewId, batchId, filter);
    }

    @Override
    public ScriptResultToken getScriptResultWithDetails(ArtifactId scriptResultId, String filter, int pageNum, int count) {
        return this.scriptResultTypeApi.getWithTestPointsAndFilter(this.branch, scriptResultId, filter, pageNum, count);
    }
}

