/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.testscript.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.xml.AbstractSaxHandler;
import org.eclipse.osee.testscript.internal.ScriptDefToken;
import org.eclipse.osee.testscript.internal.ScriptResultToken;
import org.eclipse.osee.testscript.internal.TestPointToken;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ImportTmoReader {
    private boolean inExecutedBy = false;
    private boolean inWitnesses = false;
    private ScriptDefToken currentScript;
    private ScriptResultToken currentScriptResult;
    private TestPointToken currentTestPoint;
    private TestPointToken currentCheckPoint;
    private TestPointToken currentCheckGroup;
    private final SimpleDateFormat executionDateFormat = new SimpleDateFormat("MMMM dd, yyyy hh:mm:ss a z", Locale.ENGLISH);
    private final SimpleDateFormat timeSummaryDateFormat = new SimpleDateFormat("EEE MMM dd kk:mm:ss z yyyy", Locale.ENGLISH);

    public ScriptDefToken getScriptDefinition(File file, ArtifactId ciSet) {
        try {
            return this.getScriptDefinition(new FileInputStream(file), ciSet);
        }
        catch (IOException ex) {
            System.out.println(ex);
            return new ScriptDefToken();
        }
    }

    public ScriptDefToken getScriptDefinition(InputStream stream, ArtifactId ciSet) {
        this.currentScript = new ScriptDefToken(-1L, "");
        this.currentScriptResult = new ScriptResultToken(-1L, "");
        this.currentScriptResult.setSetId(ciSet.getIdString());
        this.currentScript.getScriptResults().add(this.currentScriptResult);
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.parse(stream, (DefaultHandler)((Object)new TmoHandler()));
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            System.out.println(ex);
        }
        this.currentScriptResult.setName(this.currentScript.getName());
        return this.currentScript;
    }

    private class TmoHandler
    extends AbstractSaxHandler {
        private final Map<String, AbstractTmoHandler> handlers = new HashMap<String, AbstractTmoHandler>();

        public TmoHandler() {
            this.handlers.put("Actual", new ActualHandler());
            this.handlers.put("CheckGroup", new CheckGroupHandler());
            this.handlers.put("CheckPoint", new CheckPointHandler());
            this.handlers.put("Config", new ConfigHandler());
            this.handlers.put("CurrentProcessor", new CurrentProcessorHandler());
            this.handlers.put("ElapsedTime", new ElapsedTimeHandler());
            this.handlers.put("Environment", new EnvironmentHandler());
            this.handlers.put("ExecutedBy", new ExecutedByHandler());
            this.handlers.put("ExecutionDate", new ExecutionDateHandler());
            this.handlers.put("Expected", new ExpectedHandler());
            this.handlers.put("GroupName", new GroupNameHandler());
            this.handlers.put("isInteractive", new isInteractiveHandler());
            this.handlers.put("Name", new NameHandler());
            this.handlers.put("Number", new NumberHandler());
            this.handlers.put("NumberOfTransmissions", new NumberOfTransmissionsHandler());
            this.handlers.put("Qualification", new QualificationHandler());
            this.handlers.put("Result", new ResultHandler());
            this.handlers.put("RetryGroup", new CheckGroupHandler());
            this.handlers.put("ScriptName", new ScriptNameHandler());
            this.handlers.put("ScriptVersion", new ScriptVersionHandler());
            this.handlers.put("SystemInfo", new SystemInfoHandler());
            this.handlers.put("TestPoint", new TestPointHandler());
            this.handlers.put("TestPointName", new NameHandler());
            this.handlers.put("TestPointResults", new TestPointResultsHandler());
            this.handlers.put("TimeSummary", new TimeSummaryHandler());
            this.handlers.put("User", new UserHandler());
            this.handlers.put("Witnesses", new WitnessesHandler());
        }

        public void startElementFound(String uri, String localName, String qName, Attributes attributes) throws Exception {
            AbstractTmoHandler handler = this.handlers.get(qName);
            if (handler != null) {
                handler.startElementFound(uri, localName, qName, attributes);
            }
        }

        public void endElementFound(String uri, String localName, String qName) throws Exception {
            AbstractTmoHandler handler = this.handlers.get(qName);
            if (handler != null) {
                handler.endElementFound(uri, localName, qName, this.getContents().trim());
            }
        }

        private abstract class AbstractTmoHandler {
            private AbstractTmoHandler() {
            }

            public abstract void startElementFound(String var1, String var2, String var3, Attributes var4);

            public abstract void endElementFound(String var1, String var2, String var3, String var4);
        }

        private class ActualHandler
        extends AbstractTmoHandler {
            private ActualHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                if (Strings.isValid((String)content)) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentCheckPoint.setActual(content);
                }
            }
        }

        private class CheckGroupHandler
        extends AbstractTmoHandler {
            private CheckGroupHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentCheckGroup = new TestPointToken();
                String mode = attributes.getValue("Mode");
                if (Strings.isValid((String)mode)) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentCheckGroup.setGroupOperator(mode);
                }
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentCheckGroup = null;
            }
        }

        private class CheckPointHandler
        extends AbstractTmoHandler {
            private CheckPointHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentCheckPoint = new TestPointToken(-1L, "");
                ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentCheckPoint.setTestNumber(((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentTestPoint.getTestNumber());
                ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentCheckPoint.setInteractive(((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentTestPoint.getInteractive());
                ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentCheckPoint.setOverallResult(((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentTestPoint.getResult());
                if (((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentCheckGroup != null) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentCheckPoint.setGroupName(((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentCheckGroup.getGroupName());
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentCheckPoint.setGroupOperator(((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentCheckGroup.getGroupOperator());
                }
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentTestPoint.getSubTestPoints().add(((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentCheckPoint);
                ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentCheckPoint = null;
            }
        }

        private class ConfigHandler
        extends AbstractTmoHandler {
            private ConfigHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                String machineName = attributes.getValue("machineName");
                if (Strings.isValid((String)machineName)) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentScriptResult.setMachineName(machineName);
                }
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
            }
        }

        private class CurrentProcessorHandler
        extends AbstractTmoHandler {
            private CurrentProcessorHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                String proc = attributes.getValue("proc");
                if (Strings.isValid((String)proc)) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentScriptResult.setProcessorId(proc);
                }
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
            }
        }

        private class ElapsedTimeHandler
        extends AbstractTmoHandler {
            private ElapsedTimeHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                if (Strings.isValid((String)content)) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentCheckPoint.setElapsedTime(Integer.parseInt(content));
                }
            }
        }

        private class EnvironmentHandler
        extends AbstractTmoHandler {
            private EnvironmentHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                if (Strings.isValid((String)content)) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentScript.setExecutionEnvironment(content);
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentScriptResult.setExecutionEnvironment(content);
                }
            }
        }

        private class ExecutedByHandler
        extends AbstractTmoHandler {
            private ExecutedByHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                ((TmoHandler)TmoHandler.this).ImportTmoReader.this.inExecutedBy = true;
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                ((TmoHandler)TmoHandler.this).ImportTmoReader.this.inExecutedBy = false;
            }
        }

        private class ExecutionDateHandler
        extends AbstractTmoHandler {
            private ExecutionDateHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                try {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentScriptResult.setExecutionDate(((TmoHandler)TmoHandler.this).ImportTmoReader.this.executionDateFormat.parse(content));
                }
                catch (ParseException ex) {
                    System.out.println("Could not parse Execution Date");
                    System.out.println(ex);
                }
            }
        }

        private class ExpectedHandler
        extends AbstractTmoHandler {
            private ExpectedHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                if (Strings.isValid((String)content)) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentCheckPoint.setExpected(content);
                }
            }
        }

        private class GroupNameHandler
        extends AbstractTmoHandler {
            private GroupNameHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentCheckGroup.setGroupName(content);
            }
        }

        private class NameHandler
        extends AbstractTmoHandler {
            private NameHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                if (((TmoHandler)TmoHandler.this).ImportTmoReader.this.inExecutedBy) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentScriptResult.setExecutedBy(content);
                    return;
                }
                if (((TmoHandler)TmoHandler.this).ImportTmoReader.this.inWitnesses) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentScriptResult.getWitnesses().add(content);
                    return;
                }
                if (((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentCheckPoint != null) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentCheckPoint.setName(content);
                }
            }
        }

        private class NumberHandler
        extends AbstractTmoHandler {
            private NumberHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                double number = Double.parseDouble(content);
                if (((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentTestPoint != null) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentTestPoint.setTestNumber(number);
                }
            }
        }

        private class NumberOfTransmissionsHandler
        extends AbstractTmoHandler {
            private NumberOfTransmissionsHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                if (Strings.isValid((String)content)) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentCheckPoint.setTransmissionCount(Integer.parseInt(content));
                }
            }
        }

        private class QualificationHandler
        extends AbstractTmoHandler {
            private QualificationHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentScriptResult.setQualificationLevel(attributes.getValue("Level"));
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
            }
        }

        private class ResultHandler
        extends AbstractTmoHandler {
            private ResultHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                if (((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentCheckPoint != null) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentCheckPoint.setResult(content);
                } else if (((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentTestPoint != null) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentTestPoint.setResult(content);
                }
            }
        }

        private class ScriptNameHandler
        extends AbstractTmoHandler {
            private ScriptNameHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                if (Strings.isValid((String)content)) {
                    String[] split = content.split("\\.");
                    String name = content;
                    if (split.length > 1) {
                        name = split[split.length - 1];
                    }
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentScript.setName(name);
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentScript.setFullScriptName(content);
                }
            }
        }

        private class ScriptVersionHandler
        extends AbstractTmoHandler {
            private ScriptVersionHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                String revision = attributes.getValue("revision");
                String repositoryType = attributes.getValue("repositoryType");
                String lastAuthor = attributes.getValue("lastAuthor");
                String lastModified = attributes.getValue("lastModified");
                String modifiedFlag = attributes.getValue("modifiedFlag");
                String url = attributes.getValue("url");
                if (Strings.isValid((String)revision)) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentScript.setRevision(revision);
                }
                if (Strings.isValid((String)repositoryType)) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentScript.setRepositoryType(repositoryType);
                }
                if (Strings.isValid((String)lastAuthor)) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentScript.setLastAuthor(lastAuthor);
                }
                if (Strings.isValid((String)lastModified)) {
                    System.out.println("LAST MODIFIED: " + ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentScript.getName());
                }
                if (Strings.isValid((String)modifiedFlag)) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentScript.setModifiedFlag(modifiedFlag);
                }
                if (Strings.isValid((String)url)) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentScript.setRepositoryUrl(url);
                }
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
            }
        }

        private class SystemInfoHandler
        extends AbstractTmoHandler {
            private SystemInfoHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                String osName = attributes.getValue("osName");
                String osVersion = attributes.getValue("osVersion");
                String osArch = attributes.getValue("osArch");
                String oseeVersion = attributes.getValue("oseeVersion");
                String javaVersion = attributes.getValue("javaVersion");
                String oseeServerTitle = attributes.getValue("oseeServerTitle");
                if (Strings.isValid((String)osName)) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentScriptResult.setOsName(osName);
                }
                if (Strings.isValid((String)osVersion)) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentScriptResult.setOsVersion(osVersion);
                }
                if (Strings.isValid((String)osArch)) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentScriptResult.setOsArchitecture(osArch);
                }
                if (Strings.isValid((String)oseeVersion)) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentScriptResult.setOseeVersion(oseeVersion);
                }
                if (Strings.isValid((String)javaVersion)) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentScriptResult.setJavaVersion(javaVersion);
                }
                if (Strings.isValid((String)oseeServerTitle)) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentScriptResult.setOseeServer(oseeServerTitle);
                }
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
            }
        }

        private class TestPointHandler
        extends AbstractTmoHandler {
            private TestPointHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentTestPoint = new TestPointToken(-1L, "");
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentScriptResult.getTestPoints().addAll(((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentTestPoint.getSubTestPoints());
                ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentTestPoint = null;
            }
        }

        private class TestPointResultsHandler
        extends AbstractTmoHandler {
            private TestPointResultsHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                String pass = attributes.getValue("pass");
                String fail = attributes.getValue("fail");
                String aborted = attributes.getValue("aborted");
                if (Strings.isValid((String)pass)) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentScriptResult.setPassedCount(Integer.parseInt(pass));
                }
                if (Strings.isValid((String)fail)) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentScriptResult.setFailedCount(Integer.parseInt(fail));
                }
                if (Strings.isValid((String)aborted)) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentScriptResult.setScriptAborted(Boolean.parseBoolean(aborted));
                }
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
            }
        }

        private class TimeSummaryHandler
        extends AbstractTmoHandler {
            private TimeSummaryHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                String milliseconds = attributes.getValue("milliseconds");
                String startDate = attributes.getValue("startDate");
                String endDate = attributes.getValue("endDate");
                if (Strings.isValid((String)milliseconds)) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentScriptResult.setElapsedTime(Integer.parseInt(milliseconds));
                    try {
                        ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentScriptResult.setStartDate(((TmoHandler)TmoHandler.this).ImportTmoReader.this.timeSummaryDateFormat.parse(startDate));
                    }
                    catch (ParseException ex) {
                        System.out.println("Could not parse Start Date");
                        System.out.println(ex);
                    }
                    try {
                        ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentScriptResult.setEndDate(((TmoHandler)TmoHandler.this).ImportTmoReader.this.timeSummaryDateFormat.parse(endDate));
                    }
                    catch (ParseException ex) {
                        System.out.println("Could not parse End Date");
                        System.out.println(ex);
                    }
                }
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
            }
        }

        private class UserHandler
        extends AbstractTmoHandler {
            private UserHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                String name = attributes.getValue("name");
                String email = attributes.getValue("email");
                String id = attributes.getValue("id");
                if (Strings.isValid((String)name)) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentScriptResult.setUserName(name);
                }
                if (Strings.isValid((String)email)) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentScriptResult.setEmail(email);
                }
                if (Strings.isValid((String)id)) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentScriptResult.setUserId(id);
                }
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
            }
        }

        private class WitnessesHandler
        extends AbstractTmoHandler {
            private WitnessesHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
                ((TmoHandler)TmoHandler.this).ImportTmoReader.this.inWitnesses = true;
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                ((TmoHandler)TmoHandler.this).ImportTmoReader.this.inWitnesses = false;
            }
        }

        private class isInteractiveHandler
        extends AbstractTmoHandler {
            private isInteractiveHandler() {
            }

            @Override
            public void startElementFound(String uri, String localName, String qName, Attributes attributes) {
            }

            @Override
            public void endElementFound(String uri, String localName, String qName, String content) {
                if (((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentTestPoint != null) {
                    ((TmoHandler)TmoHandler.this).ImportTmoReader.this.currentTestPoint.setInteractive(Boolean.parseBoolean(content));
                }
            }
        }
    }
}

