/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.search.engines;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.jdk.core.type.BaseId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.Zip;
import org.eclipse.osee.framework.resource.management.DataResource;
import org.eclipse.osee.framework.resource.management.IResourceManager;

public class Attribute<T>
extends BaseId
implements IAttribute<T> {
    private final IResourceManager resourceManager;
    private final AttributeTypeGeneric<T> attributeType;
    private final String uri;
    private T value;
    private final GammaId gamma;
    private String error;

    public Attribute(Long id, AttributeTypeGeneric<T> attributeType, String value, String uri, GammaId gamma, IResourceManager resourceManager) {
        super(id);
        this.attributeType = attributeType;
        this.uri = uri;
        this.resourceManager = resourceManager;
        if (Strings.isValid((String)value)) {
            this.value = attributeType.valueFromStorageString(value);
        }
        this.gamma = gamma;
    }

    public String getDisplayableString() {
        return this.attributeType.storageStringFromValue(this.getValue());
    }

    private String loadBinaryAttribute() {
        byte[] rawData;
        block3: {
            try {
                DataResource dataResource = new DataResource();
                dataResource.setLocator(this.uri);
                rawData = this.resourceManager.acquire(dataResource);
                if (rawData != null) break block3;
                return "";
            }
            catch (IOException ex) {
                throw OseeCoreException.wrap((Throwable)ex);
            }
        }
        ByteBuffer decompressed = ByteBuffer.wrap(Zip.decompressBytes((InputStream)new ByteArrayInputStream(rawData)));
        return StandardCharsets.UTF_8.decode(decompressed).toString();
    }

    private InputStream loadBinaryAttributeAsInputStream() {
        byte[] rawData;
        block3: {
            try {
                DataResource dataResource = new DataResource();
                dataResource.setLocator(this.uri);
                rawData = this.resourceManager.acquire(dataResource);
                if (rawData != null) break block3;
                return null;
            }
            catch (IOException ex) {
                throw OseeCoreException.wrap((Throwable)ex);
            }
        }
        return new ByteArrayInputStream(Zip.decompressBytes((InputStream)new ByteArrayInputStream(rawData)));
    }

    public AttributeTypeToken getAttributeType() {
        return this.attributeType;
    }

    public T getValue() {
        if (Strings.isValid((String)this.uri) && this.value == null) {
            this.value = this.attributeType.isInputStream() ? this.loadBinaryAttributeAsInputStream() : this.loadBinaryAttribute();
        }
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.attributeType.getName()) + ": " + String.valueOf(this.value);
    }

    public GammaId getGammaId() {
        return this.gamma;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }
}

