/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader;

import java.util.Iterator;
import java.util.List;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.TxCurrent;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.QueryType;
import org.eclipse.osee.orcs.core.ds.Options;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.db.internal.loader.handlers.RelationSqlHandler2;
import org.eclipse.osee.orcs.db.internal.sql.AbstractSqlWriter;
import org.eclipse.osee.orcs.db.internal.sql.SqlContext;
import org.eclipse.osee.orcs.db.internal.sql.SqlHandler;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class LoadSqlWriter
extends AbstractSqlWriter {
    public LoadSqlWriter(SqlJoinFactory joinFactory, JdbcClient jdbcClient, SqlContext context, OrcsTokenService tokenService) {
        super(joinFactory, jdbcClient, context, new QueryData(QueryType.SELECT, tokenService));
    }

    @Override
    protected void writeSelectFields() {
        String txAlias = this.getLastAlias(OseeDb.TXS_TABLE);
        String artJoinAlias = this.getLastAlias(OseeDb.OSEE_JOIN_ID4_TABLE);
        this.writeSelectFields(txAlias, "gamma_id", txAlias, "mod_type", txAlias, "branch_id", txAlias, "transaction_id", txAlias, "app_id", txAlias, "tx_current");
        if (OptionsUtil.isHistorical((Options)this.getOptions())) {
            this.writeSelectFields(txAlias, "transaction_id as stripe_transaction_id");
        }
        this.writeSelectFields(artJoinAlias, "id2", artJoinAlias, "id4");
    }

    @Override
    public void writeGroupAndOrder(Iterable<SqlHandler<?>> handlers) {
        String artAlias = this.getLastAlias(OseeDb.OSEE_JOIN_ID4_TABLE);
        String txAlias = this.getLastAlias(OseeDb.TXS_TABLE);
        this.write("\n ORDER BY %s.branch_id, %s.id2", txAlias, artAlias);
        if (this.hasAlias(OseeDb.ATTRIBUTE_TABLE)) {
            this.write(", %s.attr_id", this.getLastAlias(OseeDb.ATTRIBUTE_TABLE));
        }
        if (this.hasAlias(OseeDb.RELATION_TABLE) && ((List)handlers).get(0).getClass().equals(RelationSqlHandler2.class)) {
            this.write(", %s.rel_order", this.getLastAlias(OseeDb.RELATION_TABLE2));
        }
        this.write(", %s.transaction_id desc", txAlias);
    }

    @Override
    public void writeTxBranchFilter(String txsAlias, boolean allowDeleted) {
        String artJoinAlias = this.getLastAlias(OseeDb.OSEE_JOIN_ID4_TABLE);
        this.writeTxFilter(txsAlias, artJoinAlias, allowDeleted);
        this.writeAnd();
        this.write(txsAlias);
        this.write(".branch_id = ");
        this.write(artJoinAlias);
        this.write(".id1");
    }

    private void writeTxFilter(String txsAlias, String artJoinAlias, boolean areDeletedIncluded) {
        boolean[] hasTable = new boolean[]{this.hasAlias(OseeDb.ARTIFACT_TABLE), this.hasAlias(OseeDb.ATTRIBUTE_TABLE), this.hasAlias(OseeDb.RELATION_TABLE)};
        boolean areDeletedSame = true;
        if (areDeletedIncluded) {
            int count = 0;
            boolean[] blArray = hasTable;
            int n = hasTable.length;
            int n2 = 0;
            while (n2 < n) {
                boolean add = blArray[n2];
                if (add) {
                    ++count;
                }
                ++n2;
            }
            if (count > 1) {
                boolean allowDeletedAtrifacts = OptionsUtil.areDeletedArtifactsIncluded((Options)this.getOptions());
                boolean allowDeletedAttributes = OptionsUtil.areDeletedAttributesIncluded((Options)this.getOptions());
                boolean allowDeletedRelations = OptionsUtil.areDeletedRelationsIncluded((Options)this.getOptions());
                boolean bl = areDeletedSame = !(hasTable[0] && !allowDeletedAtrifacts || hasTable[1] && !allowDeletedAttributes || hasTable[2] && !allowDeletedRelations);
            }
        }
        if (OptionsUtil.isHistorical((Options)this.getOptions())) {
            this.write(txsAlias);
            this.write(".transaction_id <= ");
            this.write(artJoinAlias);
            this.write(".id3");
            if (!areDeletedIncluded) {
                this.writeAnd();
                this.write(txsAlias);
                this.write(".mod_type");
                this.write(" != ");
                this.write(ModificationType.DELETED.getIdString());
            } else if (!areDeletedSame) {
                this.writeAnd();
                this.buildDeletedClause(txsAlias);
            }
        } else if (areDeletedIncluded) {
            if (areDeletedSame) {
                this.writeTxCurrentFilter(txsAlias, areDeletedIncluded);
            } else {
                this.buildDeletedClause(txsAlias);
            }
        } else {
            this.write(txsAlias);
            this.write(".tx_current = ");
            this.write(String.valueOf(TxCurrent.CURRENT));
        }
    }

    @Override
    public Options getOptions() {
        return this.getContext().getOptions();
    }

    private void buildDeletedClause(String txsAlias) {
        int count = 0;
        if (this.hasAlias(OseeDb.ARTIFACT_TABLE)) {
            List<String> artTables = this.getAliases(OseeDb.ARTIFACT_TABLE);
            if (OptionsUtil.areDeletedArtifactsIncluded((Options)this.getOptions())) {
                this.write("(");
                this.buildTableGamma(artTables, txsAlias);
                this.writeAnd();
                this.buildTxClause(txsAlias);
                this.write(")");
                ++count;
            }
        }
        if (this.hasAlias(OseeDb.ATTRIBUTE_TABLE)) {
            List<String> attrTables = this.getAliases(OseeDb.ATTRIBUTE_TABLE);
            if (OptionsUtil.areDeletedAttributesIncluded((Options)this.getOptions())) {
                this.write("(");
                this.buildTableGamma(attrTables, txsAlias);
                this.writeAnd();
                this.buildTxClause(txsAlias);
                this.write(")");
                ++count;
            }
        }
        if (this.hasAlias(OseeDb.RELATION_TABLE)) {
            List<String> relationTables = this.getAliases(OseeDb.RELATION_TABLE);
            if (OptionsUtil.areDeletedAttributesIncluded((Options)this.getOptions())) {
                if (count > 1) {
                    this.writeAnd();
                }
                this.write("(");
                this.buildTableGamma(relationTables, txsAlias);
                this.writeAnd();
                this.buildTxClause(txsAlias);
                this.write(")");
                ++count;
            }
        }
    }

    private void buildTableGamma(List<String> tableAliases, String txsAlias) {
        if (tableAliases.size() == 1) {
            this.write(tableAliases.get(0));
            this.write(".gamma_id = ");
            this.write(txsAlias);
            this.write(".gamma_id");
        } else {
            Iterator<String> iter = tableAliases.iterator();
            iter.next();
            this.write("(");
            this.write(iter.next());
            this.write(".gamma_id = ");
            this.write(txsAlias);
            this.write(".gamma_id");
            while (iter.hasNext()) {
                iter.next();
                this.write(" OR ");
                this.write(iter.next());
                this.write(".gamma_id = ");
                this.write(txsAlias);
                this.write(".gamma_id");
            }
            this.write(")");
        }
    }

    private void buildTxClause(String txsAlias) {
        this.write(txsAlias);
        if (!OptionsUtil.isHistorical((Options)this.getOptions())) {
            this.write(".tx_current = ");
            this.write(TxCurrent.CURRENT.getIdString());
        }
    }
}

