/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.callable;

import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.BranchArchivedState;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.orcs.data.ArchiveOperation;

public class ArchiveUnarchiveBranchOperation {
    private static final String INSERT_ADDRESSING = "insert into %s (transaction_id, gamma_id, tx_current, mod_type, branch_id, app_id) select transaction_id, gamma_id, tx_current, mod_type, branch_id, app_id from %s where branch_id = ?";
    private static final String DELETE_ADDRESSING = "delete from %s where branch_id = ?";
    private static final String UPDATE_BRANCH = "UPDATE osee_branch SET archived = ? WHERE branch_id = ?";
    private final BranchId branch;
    private final ArchiveOperation op;
    private final JdbcClient jdbcClient;

    public ArchiveUnarchiveBranchOperation(JdbcClient jdbcClient, BranchId branch, ArchiveOperation op) {
        this.jdbcClient = jdbcClient;
        this.branch = branch;
        this.op = op;
    }

    public XResultData run() {
        boolean archive = this.op == ArchiveOperation.ARCHIVE;
        String sourceTableName = archive ? "osee_txs" : "osee_txs_archived";
        String destinationTableName = archive ? "osee_txs_archived" : "osee_txs";
        String sql = String.format(INSERT_ADDRESSING, destinationTableName, sourceTableName);
        this.jdbcClient.runPreparedUpdate(sql, new Object[]{this.branch});
        sql = String.format(DELETE_ADDRESSING, sourceTableName);
        this.jdbcClient.runPreparedUpdate(sql, new Object[]{this.branch});
        BranchArchivedState newState = archive ? BranchArchivedState.ARCHIVED : BranchArchivedState.UNARCHIVED;
        Object[] params = new Object[]{newState, this.branch};
        this.jdbcClient.runPreparedUpdate(UPDATE_BRANCH, params);
        return XResultData.OK_STATUS;
    }
}

