/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.activity.internal;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.eclipse.osee.activity.ActivityConstants;
import org.eclipse.osee.activity.ActivityStorage;
import org.eclipse.osee.activity.api.ActivityEntry;
import org.eclipse.osee.activity.api.ActivityEntryId;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.activity.api.ThreadStats;
import org.eclipse.osee.activity.internal.ActivityMonitor;
import org.eclipse.osee.activity.internal.ThreadActivity;
import org.eclipse.osee.framework.core.data.ActivityTypeId;
import org.eclipse.osee.framework.core.data.ActivityTypeToken;
import org.eclipse.osee.framework.core.data.CoreActivityTypes;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.core.executor.ExecutorAdmin;
import org.eclipse.osee.framework.core.server.IApplicationServerManager;
import org.eclipse.osee.framework.jdk.core.type.DrainingIterator;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.time.GlobalTime;
import org.eclipse.osee.logger.Log;

public class ActivityLogImpl
implements ActivityLog,
Runnable {
    private final ConcurrentHashMap<Long, ActivityTypeToken> types = new ConcurrentHashMap(30);
    private final ConcurrentHashMap<Long, Object[]> newEntities = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, Object[]> updatedEntities = new ConcurrentHashMap();
    private final ThreadActivity threadActivity = new ThreadActivity();
    private Log logger;
    private ExecutorAdmin executorAdmin;
    private ActivityStorage storage;
    private ActivityMonitor activityMonitor;
    private volatile long freshnessMillis;
    private volatile int exceptionLineCount;
    private volatile long lastFlushTime;
    private volatile int cleanerKeepDays;
    private volatile boolean enabled = ActivityConstants.DEFAULT_ACTIVITY_LOGGER__ENABLED;
    private IApplicationServerManager applicationServerManager;
    private String host;
    private ThreadStats[] threadStats;
    private Long threadActivityParententryId;
    private final Random random = new Random();

    public void setApplicationServerManager(IApplicationServerManager applicationServerManager) {
        this.applicationServerManager = applicationServerManager;
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setActivityStorage(ActivityStorage storage) {
        this.storage = storage;
    }

    public void setExecutorAdmin(ExecutorAdmin executorAdmin) {
        this.executorAdmin = executorAdmin;
    }

    public void start(Map<String, Object> properties) throws Exception {
        for (ActivityTypeToken type : CoreActivityTypes.getTypes()) {
            this.types.put(type.getId(), type);
        }
        this.update(properties);
        this.host = this.applicationServerManager.getServerUri().toString();
        Object[] defaultRootEntry = this.createEntry(Id.SENTINEL, CoreActivityTypes.DEFAULT_ROOT, (UserId)SystemUser.OseeSystem, this.getThisServerId(), ActivityConstants.DEFAULT_CLIENT_ID, 0L, 0, "default root entry for " + this.host);
        this.activityMonitor = new ActivityMonitor(defaultRootEntry);
        this.setupThreadActivityLogging();
    }

    private Long getThisServerId() {
        return this.applicationServerManager.getPort();
    }

    private void setupThreadActivityLogging() {
        this.threadActivityParententryId = this.createActivityThread(CoreActivityTypes.THREAD_ACTIVITY, (UserId)SystemUser.OseeSystem, this.get(LogEntry.SERVER_ID), ActivityConstants.DEFAULT_CLIENT_ID, "Start of thread activity logging thread on " + this.host);
        int sampleWindowSecs = 100;
        this.threadStats = this.getThreadActivity();
        this.executorAdmin.scheduleWithFixedDelay("Thread Activity Log", this::continuouslyLogThreadActivity, (long)sampleWindowSecs, (long)sampleWindowSecs, TimeUnit.SECONDS);
    }

    private void continuouslyLogThreadActivity() {
        String threadReport = Collections.toString((String)"\n", (Object[])new Object[]{"", this.getThreadActivityDelta(this.threadStats)});
        this.threadStats = this.getThreadActivity();
        if (!threadReport.isEmpty()) {
            this.createEntry(CoreActivityTypes.THREAD_ACTIVITY, this.threadActivityParententryId, COMPLETE_STATUS, threadReport);
        }
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        StringBuilder sb = new StringBuilder("Mem Sats - ");
        sb.append(" start [");
        String startTime = DateFormat.getDateTimeInstance(1, 1).format(this.applicationServerManager.getDateStarted()).toString();
        sb.append(startTime);
        sb.append("] upTime [");
        int seconds = (int)(runtimeMxBean.getUptime() / 1000L) % 60;
        int minutes = (int)(runtimeMxBean.getUptime() / 60000L % 60L);
        int hours = (int)(runtimeMxBean.getUptime() / 3600000L % 24L);
        sb.append(String.format("%s h %s m %s s", hours, minutes, seconds));
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heapMem = memoryMXBean.getHeapMemoryUsage();
        sb.append("] heapUsed [");
        sb.append(Lib.toMBytes((long)heapMem.getUsed()));
        sb.append("] heapAlloc [");
        sb.append(Lib.toMBytes((long)heapMem.getCommitted()));
        sb.append("] heapMax [");
        sb.append(Lib.toMBytes((long)heapMem.getMax()));
        MemoryUsage nonHeapMem = memoryMXBean.getNonHeapMemoryUsage();
        sb.append("] nonHeapUsed [");
        sb.append(Lib.toMBytes((long)nonHeapMem.getUsed()));
        sb.append("] nonHeapAlloc [");
        sb.append(Lib.toMBytes((long)nonHeapMem.getCommitted()));
        sb.append("] nonHeapMax [");
        sb.append(Lib.toMBytes((long)nonHeapMem.getMax()));
        sb.append("] ");
        sb.append(this.getGarbageCollectionStats());
        this.createEntry(CoreActivityTypes.MEMORY_ACTIVITY, this.threadActivityParententryId, COMPLETE_STATUS, sb.toString());
    }

    public List<String> getGarbageCollectionStats() {
        List<GarbageCollectorMXBean> garbageCollectorMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
        ArrayList<String> stats = new ArrayList<String>(garbageCollectorMXBeans.size());
        for (GarbageCollectorMXBean gcBean : garbageCollectorMXBeans) {
            stats.add(String.format("%s: %s (count); %s (ms)", gcBean.getName(), gcBean.getCollectionCount(), gcBean.getCollectionTime()));
        }
        return stats;
    }

    public void stop() {
        this.flush(true);
        try {
            this.executorAdmin.shutdown(ActivityConstants.ACTIVITY_LOGGER__EXECUTOR_ID);
        }
        catch (Throwable th) {
            this.logger.error(th, "Error shutting down executor [%s]", new Object[]{ActivityConstants.ACTIVITY_LOGGER__EXECUTOR_ID});
        }
    }

    public ActivityEntry getEntry(ActivityEntryId entryId) {
        return this.storage.getEntry(entryId);
    }

    public void update(Map<String, Object> properties) {
        this.freshnessMillis = this.get(properties, ActivityConstants.ACTIVITY_LOGGER__WRITE_RATE_IN_MILLIS, ActivityConstants.DEFAULT_ACTIVITY_LOGGER__WRITE_RATE_IN_MILLIS);
        this.exceptionLineCount = this.get(properties, ActivityConstants.ACTIVITY_LOGGER__STACKTRACE_LINE_COUNT, ActivityConstants.DEFAULT_ACTIVITY_LOGGER__STACKTRACE_LINE_COUNT);
        String value = (String)properties.get(ActivityConstants.ACTIVITY_LOGGER__ENABLED);
        int newCleanerKeepDays = this.get(properties, ActivityConstants.ACTIVITY_LOGGER__CLEANER_KEEP_DAYS, ActivityConstants.DEFAULT_ACTIVITY_LOGGER__CLEANER_KEEP_DAYS);
        if (Strings.isValid((String)value)) {
            this.enabled = Boolean.valueOf(value);
        }
        if (newCleanerKeepDays != this.cleanerKeepDays) {
            this.cleanerKeepDays = newCleanerKeepDays;
            this.setupCleaner();
        }
    }

    private void clean() {
        this.storage.cleanEntries(this.cleanerKeepDays);
    }

    private void setupCleaner() {
        Calendar start = Calendar.getInstance();
        start.set(11, this.random.nextInt(4));
        start.set(12, this.random.nextInt(180));
        int day = start.get(6);
        start.set(6, day + 1);
        long startMil = start.getTimeInMillis();
        long curMil = System.currentTimeMillis();
        long startAfter = TimeUnit.MILLISECONDS.toMinutes(startMil - curMil);
        this.executorAdmin.shutdown(ActivityConstants.ACTIVITY_LOGGER__CLEANER_EXECUTOR_ID);
        this.executorAdmin.scheduleAtFixedRate(ActivityConstants.ACTIVITY_LOGGER__CLEANER_EXECUTOR_ID, this::clean, startAfter, 1440L, TimeUnit.MINUTES);
    }

    public Long createEntry(ActivityTypeToken type, Object ... messageArgs) {
        return this.createEntry(type, COMPLETE_STATUS, messageArgs);
    }

    public Long createUpdateableEntry(ActivityTypeToken type, Object ... messageArgs) {
        return this.createEntry(type, INITIAL_STATUS, messageArgs);
    }

    public Long createEntry(ActivityTypeToken type, Integer status, Object ... messageArgs) {
        Long parentId = this.get(LogEntry.ENTRY_ID);
        return this.createEntry(type, parentId, status, messageArgs);
    }

    public Long createEntry(UserId accountId, ActivityTypeToken type, Integer status, Object ... messageArgs) {
        Long parentId = this.get(LogEntry.ENTRY_ID);
        return this.createEntry(accountId, type, parentId, status, messageArgs);
    }

    public Long createEntry(ActivityTypeToken type, Long parentId, Integer status, Object ... messageArgs) {
        UserId accountId = UserId.valueOf((Long)this.get(LogEntry.ACCOUNT_ID));
        return this.createEntry(accountId, type, parentId, status, messageArgs);
    }

    private Long createEntry(UserId accountId, ActivityTypeToken type, Long parentId, Integer status, Object ... messageArgs) {
        if (this.isEnabled()) {
            Object[] rootEntry = this.activityMonitor.getThreadRootEntry(parentId);
            Long serverId = LogEntry.SERVER_ID.from(rootEntry);
            Long clientId = LogEntry.CLIENT_ID.from(rootEntry);
            Object[] entry = this.createEntry(parentId, type, accountId, serverId, clientId, this.computeDuration(parentId), status, messageArgs);
            return LogEntry.ENTRY_ID.from(entry);
        }
        return 0L;
    }

    private Long get(LogEntry entry) {
        return entry.from(this.activityMonitor.getThreadRootEntry());
    }

    public Long createEntry(UserId accountId, Long clientId, ActivityTypeToken type, Long parentId, Integer status, String ... messageArgs) {
        Object[] entry = this.createEntry(parentId, type, accountId, this.get(LogEntry.SERVER_ID), clientId, this.computeDuration(parentId), status, (Object[])messageArgs);
        return LogEntry.ENTRY_ID.from(entry);
    }

    private Object[] createEntry(Long parentId, ActivityTypeToken type, UserId accountId, Long serverId, Long clientId, Long duration, Integer status, Object ... messageArgs) {
        String msg;
        Long entryId = Lib.generateUuid();
        Timestamp startTime = GlobalTime.GreenwichMeanTimestamp();
        String fullMsg = null;
        try {
            String messageFormat = type.getMessageFormat();
            fullMsg = Strings.isValid((String)messageFormat) ? String.format(messageFormat, messageArgs) : Collections.toString((String)"\n", (Object[])messageArgs);
            msg = fullMsg.substring(0, Math.min(fullMsg.length(), 4000));
        }
        catch (Throwable th) {
            msg = th.toString();
            this.logger.error(th, "Error ActivityLog.createEntry", new Object[0]);
        }
        Object[] entry = new Object[]{entryId, parentId, type, accountId, serverId, clientId, startTime, duration, status, msg};
        this.newEntities.put(entryId, entry);
        if (fullMsg != null && fullMsg.length() > 4000) {
            Long parentCursor = entryId;
            int i = 4000;
            while (i < fullMsg.length()) {
                Long continueEntryId = Lib.generateUuid();
                Object[] continueEntry = new Object[]{continueEntryId, parentCursor, CoreActivityTypes.MSG_CONTINUATION, accountId, serverId, clientId, startTime, duration, status, fullMsg.substring(i, Math.min(fullMsg.length(), i + 4000))};
                this.newEntities.put(continueEntryId, continueEntry);
                parentCursor = continueEntryId;
                i += 4000;
            }
        }
        this.flush(false);
        return entry;
    }

    public Long createThrowableEntry(ActivityTypeToken type, Throwable throwable) {
        return this.createThrowableEntry(type, throwable, "");
    }

    public Long createThrowableEntry(ActivityTypeToken type, Throwable throwable, String messageSummary) {
        Long entryId = -1L;
        if (this.isEnabled()) {
            try {
                String stackTrace = this.captureStackTrace(throwable, this.exceptionLineCount);
                String message = Strings.isValid((String)messageSummary) ? String.valueOf(messageSummary) + ": " + stackTrace : stackTrace;
                entryId = this.createEntry(type, ABNORMALLY_ENDED_STATUS, message);
            }
            catch (Throwable th) {
                this.logger.error(th, "logging failed in ActivityLogImpl.createThrowableEntry", new Object[0]);
            }
        }
        return entryId;
    }

    public boolean updateEntry(Long entryId, Integer status) {
        boolean modified = false;
        if (this.isEnabled()) {
            try {
                if (!this.updateIfNew(entryId, status)) {
                    Object[] data = this.updatedEntities.get(entryId);
                    if (data == null || data.length < LogEntry.STATUS.ordinal()) {
                        this.addUpdatedEntryToMap(entryId, status);
                    } else {
                        data[LogEntry.STATUS.ordinal()] = status;
                        if (!this.updatedEntities.containsKey(entryId)) {
                            this.addUpdatedEntryToMap(entryId, status);
                        }
                    }
                    modified = true;
                }
            }
            catch (Throwable th) {
                this.logger.error(th, "Error in ActivityLog.updateEntry", new Object[0]);
            }
        }
        return modified;
    }

    private void addUpdatedEntryToMap(Long entryId, Integer status) {
        this.updatedEntities.put(entryId, new Object[]{status, this.computeDuration(), entryId});
    }

    private Long computeDuration() {
        return this.computeDuration(this.activityMonitor.getThreadRootEntry());
    }

    private Long computeDuration(Object[] threadRootEntry) {
        return System.currentTimeMillis() - LogEntry.START_TIME.from(threadRootEntry);
    }

    private Long computeDuration(Long parentId) {
        return this.computeDuration(this.activityMonitor.getThreadRootEntry(parentId));
    }

    private boolean updateIfNew(Long entryId, Integer status) {
        Object[] data = this.newEntities.get(entryId);
        if (data == null) {
            return false;
        }
        data[LogEntry.STATUS.ordinal()] = status;
        data[LogEntry.DURATION.ordinal()] = this.computeDuration();
        return this.newEntities.containsKey(entryId);
    }

    @Override
    public void run() {
        if (this.isEnabled()) {
            if (!this.newEntities.isEmpty()) {
                try {
                    this.storage.addEntries((Iterable<Object[]>)new DrainingIterator(this.newEntities.values().iterator()));
                }
                catch (Throwable ex) {
                    this.logger.error(ex, "Exception while storing updates to the activity log", new Object[0]);
                }
            }
            if (!this.updatedEntities.isEmpty()) {
                try {
                    this.storage.updateEntries((Iterable<Object[]>)new DrainingIterator(this.updatedEntities.values().iterator()));
                }
                catch (Throwable ex) {
                    this.logger.error(ex, "Exception while storing updates to the activity log", new Object[0]);
                }
            }
        } else {
            this.newEntities.clear();
            this.updatedEntities.clear();
        }
    }

    private void flush(boolean force) {
        long currentTime = System.currentTimeMillis();
        if (force || currentTime - this.lastFlushTime > this.freshnessMillis) {
            try {
                try {
                    this.executorAdmin.submit("Activity Log flush to datastore", (Runnable)this);
                }
                catch (Exception ex) {
                    this.logger.error((Throwable)ex, "Error scheduling activity log callable", new Object[0]);
                    this.lastFlushTime = currentTime;
                }
            }
            finally {
                this.lastFlushTime = currentTime;
            }
        }
    }

    public void completeEntry(Long entryId) {
        this.updateEntry(entryId, COMPLETE_STATUS);
    }

    public void endEntryAbnormally(Long entryId) {
        this.updateEntry(entryId, ABNORMALLY_ENDED_STATUS);
    }

    public void endEntryAbnormally(Long entryId, Integer status) {
        if (status > COMPLETE_STATUS) {
            this.updateEntry(entryId, status);
        } else {
            this.endEntryAbnormally(entryId);
        }
    }

    public Long createActivityThread(ActivityTypeToken type, UserId accountId, Long serverId, Long clientId, Object ... messageArgs) {
        return this.createActivityThread(Id.SENTINEL, type, accountId, serverId, clientId, messageArgs);
    }

    public Long createActivityThread(Long parentId, ActivityTypeToken type, UserId accountId, Long serverId, Long clientId, Object ... messageArgs) {
        Object[] entry = this.createEntry(parentId, type, accountId, serverId, clientId, 0L, 0, messageArgs);
        this.activityMonitor.addActivityThread(entry);
        return LogEntry.ENTRY_ID.from(entry);
    }

    public void removeActivityThread() {
        this.activityMonitor.removeActivityThread();
    }

    public ActivityTypeToken getActivityType(ActivityTypeId typeId) {
        ActivityTypeToken type = this.types.get(typeId);
        if (type == null) {
            type = this.storage.getActivityType(typeId);
            this.types.put(type.getId(), type);
        }
        return type;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public ActivityTypeToken createIfAbsent(ActivityTypeToken token) {
        ActivityTypeToken type = this.types.get(token);
        if (type == null) {
            type = this.storage.createIfAbsent(token);
            this.types.put(type.getId(), type);
        }
        return type;
    }

    public ThreadStats[] getThreadActivity() {
        return this.threadActivity.getThreadActivity();
    }

    public List<String> getThreadActivityDelta(ThreadStats[] threadStats) {
        return this.threadActivity.getThreadActivityDelta(threadStats);
    }

    public Log getDebugLogger() {
        return this.logger;
    }

    private String captureStackTrace(Throwable ex, int linesToCapture) {
        Throwable cause = ex;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(cause.toString()) + "\n");
        StackTraceElement[] stackElements = cause.getStackTrace();
        int i = 0;
        while (i < Math.min(stackElements.length, linesToCapture)) {
            sb.append(stackElements[i] + "\n");
            ++i;
        }
        return sb.toString();
    }

    private <T> T get(Map<String, Object> properties, String key, T defaultValue) {
        Object value;
        Object object = value = properties != null ? properties.get(key) : null;
        if (value == null) {
            value = defaultValue;
        }
        return (T)value;
    }

    public static enum LogEntry {
        ENTRY_ID,
        PARENT_ID,
        TYPE_ID,
        ACCOUNT_ID,
        SERVER_ID,
        CLIENT_ID,
        START_TIME,
        DURATION,
        STATUS,
        MESSAGE_ARGS;

        public static final Long SENTINEL;

        static {
            SENTINEL = Id.SENTINEL;
        }

        public Long from(Object[] entry) {
            if (entry == null) {
                return SENTINEL;
            }
            Object obj = entry[this.ordinal()];
            if (obj instanceof Long) {
                return (Long)obj;
            }
            if (obj instanceof Id) {
                return ((Id)obj).getId();
            }
            if (obj instanceof Timestamp) {
                return ((Timestamp)obj).getTime();
            }
            throw new OseeArgumentException("LogEntryIndex.from called with agrgument of unsupported type " + obj.getClass(), new Object[0]);
        }
    }
}

