/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model.change;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class CompareData
implements ToMessage {
    private final Map<String, String> dataToCompare;
    private final String generatorScriptPath;
    private final List<String> mergeList;
    private final String outputPath;
    private final String pathPrefix;
    private final PresentationType presentationType;

    public CompareData(PresentationType presentationType, CharSequence pathPrefix, CharSequence outputPath, CharSequence generatorScriptPath) {
        this.presentationType = Objects.requireNonNull(presentationType, "CompareData::new, The parameter \"presentationType\" cannot be null.");
        this.pathPrefix = Objects.requireNonNull(pathPrefix, "CompareData::new, The parameter \"pathPrefix\" cannot be null.").toString();
        this.outputPath = Objects.requireNonNull(outputPath, "COmpareData::new, The parameter \"outputPath\" cannot be null.").toString();
        this.generatorScriptPath = Objects.requireNonNull(generatorScriptPath, "CompareData::new, The parameter \"generatorScriptPath\" cannot be null.").toString();
        this.dataToCompare = new LinkedHashMap<String, String>();
        this.mergeList = new ArrayList<String>();
    }

    public void add(String file1Location, String file2Location) {
        this.dataToCompare.put(file1Location, file2Location);
    }

    public void addMerge(String fileLocation) {
        if (fileLocation != null && fileLocation.length() > 0) {
            this.mergeList.add(fileLocation);
        }
    }

    public void clear() {
        this.dataToCompare.clear();
    }

    public Set<Map.Entry<String, String>> entrySet() {
        return this.dataToCompare.entrySet();
    }

    public String getGeneratorScriptPath() {
        return this.generatorScriptPath;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public PresentationType getPresentationType() {
        return this.presentationType;
    }

    public boolean isEmpty() {
        return this.dataToCompare.isEmpty();
    }

    public boolean isMerge(String fileLocation) {
        return this.mergeList.contains(fileLocation);
    }

    public int size() {
        return this.dataToCompare.size();
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.indent(indent).title((CharSequence)"CompareData").indentInc().segment((CharSequence)"Presentation Type", (Object)this.presentationType).segment((CharSequence)"Path Prefix", (Object)this.pathPrefix).segment((CharSequence)"Output Path", (Object)this.outputPath).segment((CharSequence)"Generator Script Path", (Object)this.generatorScriptPath).segmentIndexed((CharSequence)"Merge List", this.mergeList).segmentMap((CharSequence)"Data To Compare", this.dataToCompare).indentDec();
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

