/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.osee.framework.core.data.Adaptable;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchCategoryToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.model.TransactionRecord;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;

public class Branch
extends NamedIdBase
implements BranchToken,
Adaptable {
    private final Set<Branch> childBranches = new HashSet<Branch>();
    private BranchType branchType;
    private BranchState branchState;
    private boolean isArchived;
    private boolean inheritsAccessControl;
    private TransactionRecord parentTx;
    private TransactionRecord baselineTx;
    private Branch parent;
    private ArtifactId associatedArtifact;
    private ArtifactId branchView;
    private List<BranchCategoryToken> categories;

    public Branch(Long uuid, String name, BranchType branchType, BranchState branchState, boolean isArchived, boolean inheritsAccessControl) {
        this(uuid, name, branchType, branchState, isArchived, inheritsAccessControl, ArtifactId.SENTINEL);
    }

    public Branch(Long uuid, String name, BranchType branchType, BranchState branchState, boolean isArchived, boolean inheritsAccessControl, ArtifactId viewId) {
        super(uuid, name);
        this.branchType = branchType;
        this.branchState = branchState;
        this.isArchived = isArchived;
        this.inheritsAccessControl = inheritsAccessControl;
        this.branchView = viewId;
    }

    public static Branch createBranchView(Branch branch, ArtifactId viewId, String name) {
        Branch viewBranch = new Branch(branch.getId(), branch.getName(), branch.getBranchType(), branch.getBranchState(), branch.isArchived, true);
        viewBranch.setAssociatedArtifact(branch.getAssociatedArtifactId());
        viewBranch.setBaseTransaction(branch.getBaseTransaction());
        viewBranch.setBranchView(viewId);
        viewBranch.setParentBranch(branch.getParentBranch());
        viewBranch.setName(name);
        return viewBranch;
    }

    public Branch getParentBranch() {
        return this.parent;
    }

    public BranchType getBranchType() {
        return this.branchType;
    }

    public BranchState getBranchState() {
        return this.branchState;
    }

    public boolean isArchived() {
        return this.isArchived;
    }

    public ArtifactId getAssociatedArtifactId() {
        return this.associatedArtifact;
    }

    public void setAssociatedArtifact(ArtifactId artifact) {
        this.associatedArtifact = artifact;
    }

    public TransactionRecord getBaseTransaction() {
        return this.baselineTx;
    }

    public TransactionRecord getSourceTransaction() {
        return this.parentTx;
    }

    public void setArchived(boolean isArchived) {
        this.isArchived = isArchived;
    }

    public void setBranchState(BranchState branchState) {
        this.branchState = branchState;
    }

    public void setBranchType(BranchType branchType) {
        this.branchType = branchType;
    }

    public void setParentBranch(Branch parentBranch) {
        if (this.parent != null) {
            this.parent.childBranches.remove((Object)this);
        }
        this.parent = parentBranch;
        parentBranch.childBranches.add(this);
    }

    public void setBaseTransaction(TransactionRecord baselineTx) {
        this.baselineTx = baselineTx;
    }

    public void setSourceTransaction(TransactionRecord parentTx) {
        this.parentTx = parentTx;
    }

    public boolean isInheritAccessControl() {
        return this.inheritsAccessControl;
    }

    public void setInheritAccessControl(boolean inheritsAccessControl) {
        this.inheritsAccessControl = inheritsAccessControl;
    }

    public Set<Branch> getChildren() {
        return this.childBranches;
    }

    public ArtifactId getBranchView() {
        return this.branchView;
    }

    public void setBranchView(ArtifactId branchView) {
        this.branchView = branchView;
    }

    public Collection<BranchToken> getAllChildBranches(boolean recurse) {
        HashSet<BranchToken> children = new HashSet<BranchToken>();
        this.getChildBranches(children, recurse, b -> true);
        return children;
    }

    public void getChildBranches(Collection<BranchToken> children, boolean recurse, Predicate<Branch> filter) {
        for (Branch branch : this.getChildren()) {
            if (!filter.test(branch)) continue;
            children.add(branch);
            if (!recurse) continue;
            branch.getChildBranches(children, recurse, filter);
        }
    }

    public Collection<BranchId> getAncestors() {
        ArrayList<BranchId> ancestors = new ArrayList<BranchId>();
        Branch branchCursor = this;
        ancestors.add((BranchId)branchCursor);
        while ((branchCursor = branchCursor.parent) != null) {
            ancestors.add((BranchId)branchCursor);
        }
        return ancestors;
    }

    public boolean isAncestorOf(BranchId branch) {
        return this.getAllChildBranches(true).contains(branch);
    }

    public boolean hasAncestor(BranchId ancestor) {
        Branch branchCursor = this;
        while ((branchCursor = branchCursor.parent) != null) {
            if (!branchCursor.equals(ancestor)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BranchId) {
            return super.equals(obj) && this.branchView.equals(((BranchId)obj).getViewId());
        }
        return false;
    }

    public ArtifactId getViewId() {
        return this.branchView;
    }

    public List<BranchCategoryToken> getCategories() {
        return this.categories;
    }

    public void setCategories(List<BranchCategoryToken> categories) {
        this.categories = categories;
    }
}

