/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.model.transaction;

import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.KeyValueOps;

public final class TransferFileLockUtil {
    private static final String LOCKED = "LOCKED";
    private static final String OPEN = "OPEN";

    public static boolean lock(KeyValueOps ops, Long lockId) {
        String lock = ops.getByKey(lockId);
        if (Strings.isInvalidOrBlank((String)lock)) {
            return ops.putWithKeyIfAbsent(lockId, LOCKED);
        }
        if (lock.equals(LOCKED)) {
            return false;
        }
        if (lock.equals(OPEN)) {
            return ops.updateByKey(lockId, LOCKED);
        }
        return false;
    }

    public static boolean unLock(KeyValueOps ops, Long lockId) {
        String lock = ops.getByKey(lockId);
        if (Strings.isInvalidOrBlank((String)lock)) {
            return ops.putWithKeyIfAbsent(lockId, OPEN);
        }
        if (lock.equals(OPEN)) {
            return false;
        }
        if (lock.equals(LOCKED)) {
            return ops.updateByKey(lockId, OPEN);
        }
        return false;
    }

    public static boolean isLocked(KeyValueOps ops, Long lockId) {
        String lock = ops.getByKey(lockId);
        if (Strings.isInvalidOrBlank((String)lock)) {
            return false;
        }
        if (lock.equals(LOCKED)) {
            return true;
        }
        if (lock.equals(OPEN)) {
            return false;
        }
        return false;
    }
}

