/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.internal;

import java.io.IOException;
import java.io.Writer;
import org.eclipse.osee.define.util.ComponentUtil;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ISheetWriter;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.QueryFactory;

public class SafetyReqtsOnlyReportGenerator {
    private final QueryFactory queryFactory;
    private final ComponentUtil componentUtil;
    private final ArtifactId view;
    private final BranchId branchId;
    private final String[] columnHeadings = new String[]{CoreArtifactTypes.SoftwareRequirementMsWord.getName(), "Development Assurance Level", "SW Partition", "SW CSU", "Requirement Type"};

    public SafetyReqtsOnlyReportGenerator(OrcsApi orcsApi, BranchId branchId, ArtifactId view) {
        this.queryFactory = orcsApi.getQueryFactory();
        this.view = view;
        this.branchId = branchId;
        this.componentUtil = new ComponentUtil(branchId, orcsApi);
    }

    private void writeCell(String value, String[] currentRow, int col) {
        currentRow[col] = value;
    }

    public void runOperation(Writer providedWriter) throws IOException {
        ExcelXmlWriter writer = new ExcelXmlWriter(providedWriter);
        this.generateReport((ISheetWriter)writer);
        writer.endWorkbook();
    }

    private void generateReport(ISheetWriter writer) throws IOException {
        writer.startSheet("Software Requirement Report", this.columnHeadings.length);
        writer.writeRow((Object[])this.columnHeadings);
        Object[] currentRowValues = new String[this.columnHeadings.length];
        ResultSet softwareReqts = this.queryFactory.fromBranch(this.branchId, this.view).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.AbstractSoftwareRequirement}).getResults();
        for (ArtifactReadable softwareRequirement : softwareReqts) {
            this.processSoftwareRequirement(softwareRequirement, (String[])currentRowValues);
            writer.writeRow(currentRowValues);
        }
        writer.endSheet();
    }

    private void writeCriticality(ArtifactReadable art, AttributeTypeToken thisType, String[] currentRowValues, int col) {
        String current = art.getSoleAttributeAsString(thisType, "Error");
        if ("Error".equals(current)) {
            this.writeCell("Error: invalid content", currentRowValues, col);
        } else if ("Unspecified".equals(current)) {
            this.writeCell("Unspecified", currentRowValues, col);
        } else {
            this.writeCell(current, currentRowValues, col);
        }
    }

    private void processSoftwareRequirement(ArtifactReadable softwareRequirement, String[] currentRowValues) {
        this.writeCell(softwareRequirement.getName(), currentRowValues, 0);
        this.writeCriticality(softwareRequirement, (AttributeTypeToken)CoreAttributeTypes.IDAL, currentRowValues, 1);
        this.writeCell(softwareRequirement.getAttributeValuesAsString((AttributeTypeToken)CoreAttributeTypes.Partition), currentRowValues, 2);
        try {
            this.writeCell(this.componentUtil.getQualifiedComponentNames(softwareRequirement), currentRowValues, 3);
        }
        catch (Exception exception) {
            this.writeCell("No component", currentRowValues, 3);
        }
        this.writeCell(softwareRequirement.getArtifactType().getName(), currentRowValues, 4);
    }

    public ComponentUtil getComponentUtil() {
        return this.componentUtil;
    }
}

