/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.importing.parsers;

import java.net.URI;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osee.define.rest.api.importing.IArtifactExtractor;
import org.eclipse.osee.define.rest.api.importing.IArtifactExtractorDelegate;
import org.eclipse.osee.define.rest.api.importing.RoughArtifact;
import org.eclipse.osee.define.rest.api.importing.RoughArtifactCollector;
import org.eclipse.osee.define.rest.importing.parsers.NullDelegate;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public abstract class AbstractArtifactExtractor
implements IArtifactExtractor {
    private static final IArtifactExtractorDelegate NULL_DELEGATE = new NullDelegate();
    private IArtifactExtractorDelegate delegate = NULL_DELEGATE;

    protected AbstractArtifactExtractor() {
    }

    protected abstract @NonNull XResultData extractFromSource(OrcsApi var1, @NonNull XResultData var2, @NonNull URI var3, RoughArtifactCollector var4) throws Exception;

    public String toString() {
        return this.getName();
    }

    public boolean isDelegateRequired() {
        return false;
    }

    public final void setDelegate(IArtifactExtractorDelegate delegate) {
        this.delegate = delegate != null ? delegate : NULL_DELEGATE;
    }

    public final IArtifactExtractorDelegate getDelegate() {
        return this.delegate;
    }

    public final boolean hasDelegate() {
        return !(this.delegate instanceof NullDelegate);
    }

    private void checkDelegate() {
        if (this.isDelegateRequired() && !this.hasDelegate()) {
            throw new OseeStateException("Delegate is required but is null delegate", new Object[0]);
        }
    }

    public final @NonNull XResultData process(OrcsApi orcsApi, @NonNull XResultData results, URI source, RoughArtifactCollector collector) throws Exception {
        Objects.requireNonNull(results, "AbstractArtifactExtractor::process, parameter \"results\" cannot be null.");
        this.checkDelegate();
        this.delegate.initialize();
        try {
            this.extractFromSource(orcsApi, results, source, collector);
            this.connectParentChildRelations(collector);
            this.connectCollectorParent(collector);
        }
        finally {
            this.delegate.dispose();
        }
        return results;
    }

    public boolean artifactCreated(TransactionBuilder transaction, ArtifactId theArtifact, RoughArtifact source) {
        return false;
    }

    private void connectCollectorParent(RoughArtifactCollector collector) {
        RoughArtifact parent = collector.getParentRoughArtifact();
        if (parent != null) {
            for (RoughArtifact roughArtifact : collector.getRoughArtifacts()) {
                if (roughArtifact.hasParent()) continue;
                parent.addChild(roughArtifact);
            }
        }
    }

    private void connectParentChildRelations(RoughArtifactCollector collector) {
        for (RoughArtifact roughArtifact : collector.getRoughArtifacts()) {
            if (!roughArtifact.hasHierarchicalRelation()) continue;
            this.connectParentChildRelationsFor(collector, roughArtifact);
        }
    }

    private void connectParentChildRelationsFor(RoughArtifactCollector collector, RoughArtifact parent) {
        for (RoughArtifact otherRoughArtifact : collector.getRoughArtifacts()) {
            if (parent.equals(otherRoughArtifact) || !parent.isChild(otherRoughArtifact)) continue;
            parent.addChild(otherRoughArtifact);
        }
    }
}

