/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.importing.operations;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osee.define.rest.api.importing.IArtifactExtractor;
import org.eclipse.osee.define.rest.api.importing.RoughArtifact;
import org.eclipse.osee.define.rest.api.importing.RoughArtifactCollector;
import org.eclipse.osee.define.rest.api.importing.RoughRelation;
import org.eclipse.osee.define.rest.importing.resolvers.IArtifactImportResolver;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class RoughToRealArtifactOperation {
    private final OrcsApi orcsApi;
    private final XResultData results;
    private final RoughArtifactCollector rawData;
    private final IArtifactImportResolver artifactResolver;
    private final Map<RoughArtifact, ArtifactReadable> roughToRealArtifacts;
    private final Collection<ArtifactId> createdArtifacts;
    private final ArtifactReadable destinationArtifact;
    private final RelationSorter importArtifactOrder;
    private final boolean deleteUnmatchedArtifacts;
    private Collection<ArtifactReadable> unmatchedArtifacts;
    private final IArtifactExtractor extractor;
    private final TransactionBuilder transaction;
    private boolean addRelation = true;
    private final List<Pair<ArtifactId, String>> artifactWordContent;
    private final HashMap<String, HashMap<ArtifactReadable, ArtifactId>> doorsIdArtIdMap;
    private static final Pattern referencePattern = Pattern.compile("\\[[^\\[]*\\]");

    public RoughToRealArtifactOperation(OrcsApi orcsApi, XResultData results, @NonNull TransactionBuilder transaction, ArtifactReadable destinationArtifact, RoughArtifactCollector rawData, IArtifactImportResolver artifactResolver, boolean deleteUnmatchedArtifacts, IArtifactExtractor extractor) {
        this.results = results;
        this.orcsApi = orcsApi;
        this.rawData = rawData;
        this.transaction = Objects.requireNonNull(transaction, "RoughToRealArtifactOperation::new, parameter \"transaction\" cannot be null.");
        this.artifactResolver = artifactResolver;
        this.destinationArtifact = destinationArtifact;
        this.importArtifactOrder = RelationSorter.USER_DEFINED;
        this.roughToRealArtifacts = new HashMap<RoughArtifact, ArtifactReadable>();
        this.createdArtifacts = new LinkedList<ArtifactId>();
        this.deleteUnmatchedArtifacts = deleteUnmatchedArtifacts;
        this.extractor = extractor;
        this.roughToRealArtifacts.put(rawData.getParentRoughArtifact(), this.destinationArtifact);
        this.artifactWordContent = new LinkedList<Pair<ArtifactId, String>>();
        this.doorsIdArtIdMap = new HashMap();
    }

    public void doWork() {
        if (this.deleteUnmatchedArtifacts) {
            this.unmatchedArtifacts = this.destinationArtifact.getDescendants();
        }
        for (RoughArtifact roughArtifact : this.rawData.getParentRoughArtifact().getChildren()) {
            ArtifactId child = this.createArtifact(roughArtifact, (ArtifactId)this.destinationArtifact);
            this.createdArtifacts.add(child);
            if (this.addRelation && child != null && this.noParent(child)) {
                this.transaction.relate((ArtifactId)this.destinationArtifact, (RelationTypeToken)CoreRelationTypes.DefaultHierarchical_Child, child, this.importArtifactOrder);
            }
            for (RoughRelation roughRelation : this.rawData.getRoughRelations()) {
                this.createRelation(roughRelation);
            }
        }
        if (this.deleteUnmatchedArtifacts) {
            for (ArtifactReadable toDelete : this.unmatchedArtifacts) {
                this.transaction.deleteArtifact((ArtifactId)toDelete);
            }
        }
    }

    private boolean noParent(ArtifactId artifact) {
        ArtifactReadable art = this.getArtifactReadable(artifact);
        ArtifactReadable parent = art.getParent();
        if (parent == null) {
            return true;
        }
        return !parent.isValid();
    }

    private ArtifactId createArtifact(RoughArtifact roughArtifact, ArtifactId realParent) {
        Collection objIds;
        Matcher matcher;
        ArtifactReadable realArtifact = this.roughToRealArtifacts.get(roughArtifact);
        if (realArtifact != null) {
            return realArtifact;
        }
        ArtifactId realArtifactId = this.artifactResolver.resolve(roughArtifact, this.transaction.getBranch(), realParent, (ArtifactId)this.destinationArtifact);
        String roughWTC = roughArtifact.getRoughAttribute(CoreAttributeTypes.WordTemplateContent.getName());
        if (roughWTC != null && (matcher = referencePattern.matcher(roughWTC)).find()) {
            this.artifactWordContent.add((Pair<ArtifactId, String>)new Pair((Object)realArtifactId, (Object)roughWTC));
        }
        if ((objIds = roughArtifact.getRoughAttributeAsList(CoreAttributeTypes.DoorsId.getName())) != null) {
            for (String objId : objIds) {
                HashMap<Object, Object> artMap;
                if (!this.doorsIdArtIdMap.containsKey(objId)) {
                    artMap = new HashMap<ArtifactReadable, ArtifactId>();
                    artMap.put(this.destinationArtifact, realArtifactId);
                    this.doorsIdArtIdMap.put(objId, artMap);
                    continue;
                }
                artMap = this.doorsIdArtIdMap.get(objId);
                if (artMap.containsKey(this.destinationArtifact)) continue;
                this.doorsIdArtIdMap.get(objId).put(this.destinationArtifact, realArtifactId);
            }
        }
        if (this.deleteUnmatchedArtifacts) {
            this.unmatchedArtifacts.remove(realArtifactId);
        }
        for (RoughArtifact childRoughArtifact : roughArtifact.getDescendants()) {
            ArtifactId childArtifact = this.createArtifact(childRoughArtifact, realArtifactId);
            if (this.areValid(realArtifactId, childArtifact)) {
                this.replaceParent(childArtifact, realArtifactId);
            }
            this.extractor.artifactCreated(this.transaction, childArtifact, childRoughArtifact);
        }
        this.results.logf("Added Art: %s\n", new Object[]{realArtifactId.getIdString()});
        return realArtifactId;
    }

    private void replaceParent(ArtifactId childId, ArtifactId parentId) {
        ArtifactReadable child = this.getArtifactReadable(childId);
        ArtifactReadable parent = this.getArtifactReadable(parentId);
        if (parent == null || child == null) {
            return;
        }
        if (this.hasDifferentParent(child, parent)) {
            this.transaction.unrelate((ArtifactId)child.getParent(), (RelationTypeToken)CoreRelationTypes.DefaultHierarchical_Child, (ArtifactId)child);
        }
        this.transaction.relate((ArtifactId)parent, (RelationTypeToken)CoreRelationTypes.DefaultHierarchical_Child, (ArtifactId)child, this.importArtifactOrder);
    }

    private ArtifactReadable getArtifactReadable(ArtifactId art) {
        if (art instanceof ArtifactReadable) {
            return (ArtifactReadable)art;
        }
        ArtifactReadable realArt = null;
        try {
            realArt = this.orcsApi.getQueryFactory().fromBranch(this.transaction.getBranch()).andId(art).getArtifact();
        }
        catch (Exception exception) {}
        return realArt;
    }

    private boolean hasDifferentParent(ArtifactReadable art, ArtifactReadable parent) {
        ArtifactReadable knownParent = art.getParent();
        return knownParent != null && knownParent.notEqual((Id)parent);
    }

    private boolean isValid(ArtifactId art) {
        return art != null;
    }

    private boolean areValid(ArtifactId ... artifacts) {
        boolean returnValue = true;
        ArtifactId[] artifactIdArray = artifacts;
        int n = artifacts.length;
        int n2 = 0;
        while (n2 < n) {
            ArtifactId art = artifactIdArray[n2];
            returnValue &= this.isValid(art);
            ++n2;
        }
        return returnValue;
    }

    private void createRelation(RoughRelation roughRelation) {
        RelationTypeToken relationType = this.getRelationType(roughRelation.getRelationTypeName());
        ArtifactReadable aArt = this.orcsApi.getQueryFactory().fromBranch(this.transaction.getBranch()).andGuid(roughRelation.getAartifactGuid()).getArtifact();
        ArtifactReadable bArt = this.orcsApi.getQueryFactory().fromBranch(this.transaction.getBranch()).andGuid(roughRelation.getBartifactGuid()).getArtifact();
        if (aArt == null || bArt == null) {
            this.results.warningf("The relation of type %s could not be created.", new Object[]{roughRelation.getRelationTypeName()});
            if (aArt == null) {
                this.results.warningf("The artifact with guid: %s does not exist.", new Object[]{roughRelation.getAartifactGuid()});
            }
            if (bArt == null) {
                this.results.warningf("The artifact with guid: %s does not exist.", new Object[]{roughRelation.getBartifactGuid()});
            }
        } else {
            try {
                this.transaction.relate((ArtifactId)aArt, relationType, (ArtifactId)bArt, roughRelation.getRationale(), this.importArtifactOrder);
            }
            catch (IllegalArgumentException ex) {
                this.results.error(ex.toString());
            }
        }
    }

    private RelationTypeToken getRelationType(String relationName) {
        for (RelationTypeToken type : this.orcsApi.tokenService().getRelationTypes()) {
            if (!type.getName().equals(relationName)) continue;
            return type;
        }
        return null;
    }

    public boolean isAddRelation() {
        return this.addRelation;
    }

    public void setAddRelation(boolean addRelation) {
        this.addRelation = addRelation;
    }

    public Collection<ArtifactId> getCreatedArtifacts() {
        return this.createdArtifacts;
    }

    public List<Pair<ArtifactId, String>> getArtifactWordContent() {
        return this.artifactWordContent;
    }

    public HashMap<String, HashMap<ArtifactReadable, ArtifactId>> getDoorsIdArtIdMap() {
        return this.doorsIdArtIdMap;
    }
}

