/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.WebApplicationException;
import org.eclipse.osee.define.operations.api.git.GitOperations;
import org.eclipse.osee.define.operations.api.traceability.TraceabilityOperations;
import org.eclipse.osee.define.rest.api.CertBaselineData;
import org.eclipse.osee.define.rest.api.CertFileData;
import org.eclipse.osee.define.rest.api.DefineTupleTypes;
import org.eclipse.osee.define.rest.api.traceability.TraceData;
import org.eclipse.osee.define.rest.internal.TraceReportGenerator;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.Named;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.search.TupleQuery;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public final class TraceabilityOperationsImpl
implements TraceabilityOperations {
    private final OrcsApi orcsApi;
    private final QueryFactory queryFactory;
    private final TupleQuery tupleQuery;
    private final GitOperations gitOps;

    public TraceabilityOperationsImpl(OrcsApi orcsApi, GitOperations gitOperations) {
        this.orcsApi = orcsApi;
        this.queryFactory = orcsApi.getQueryFactory();
        this.tupleQuery = this.queryFactory.tupleQuery();
        this.gitOps = gitOperations;
    }

    public void generateTraceReport(BranchId branchId, String codeRoot, String traceRoot, Writer providedWriter, ArtifactTypeToken artifactType, AttributeTypeToken attributeType) {
        TraceReportGenerator generator = new TraceReportGenerator(artifactType, attributeType);
        try {
            generator.generate(this.orcsApi, branchId, codeRoot, traceRoot, providedWriter);
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    public TraceData getSrsToImpd(BranchId branch, ArtifactTypeId excludeType) {
        ResultSet allSwReqs = this.queryFactory.fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.AbstractSoftwareRequirement}).getResults();
        List swReqs = allSwReqs.getList().stream().filter(req -> excludeType.isInvalid() || !req.isOfType(new ArtifactTypeId[]{excludeType})).map(req -> req.getName()).collect(Collectors.toList());
        ResultSet impds = this.queryFactory.fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.ImplementationDetailsMsWord}).getResults();
        HashMap<String, String[]> impdMap = new HashMap<String, String[]>();
        for (ArtifactReadable impd : impds) {
            String[] pair;
            List matchingReq = impd.getRelated(CoreRelationTypes.ImplementationInfo_SoftwareRequirement).getList();
            if (matchingReq.isEmpty()) {
                pair = this.findMatchingReq(impd);
            } else {
                pair = new String[matchingReq.size() + 1];
                int i = 0;
                while (i < matchingReq.size()) {
                    pair[i] = ((ArtifactReadable)matchingReq.get(i)).getName();
                    ++i;
                }
                pair[matchingReq.size()] = "0";
            }
            impdMap.put(impd.getName(), pair);
        }
        TraceData traceData = new TraceData(swReqs, impdMap);
        return traceData;
    }

    private String[] findMatchingReq(ArtifactReadable impd) {
        ArtifactReadable cursor = impd.getParent();
        int level = 1;
        while (cursor != null) {
            if (cursor.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.AbstractSoftwareRequirement})) {
                return new String[]{cursor.getName(), String.valueOf(level)};
            }
            ++level;
            cursor = cursor.getParent();
        }
        return null;
    }

    public ArtifactId baselineFiles(BranchId branch, ArtifactReadable repoArtifact, CertBaselineData baselineData, TransactionBuilder tx, String password) {
        ArtifactToken baselineEvent = tx.createArtifact(CoreArtifactTypes.CertificationBaselineEvent, baselineData.eventName);
        ArtifactId baselinedByUser = this.queryFactory.fromBranch((BranchId)CoreBranches.COMMON).andAttributeIs((AttributeTypeToken)CoreAttributeTypes.UserId, baselineData.baselinedByUserId).asArtifactId();
        ArtifactToken baselineCommit = this.gitOps.getCommitArtifactId(branch, baselineData.changeId);
        if (baselineCommit.isInvalid()) {
            this.gitOps.updateGitTrackingBranch(branch, repoArtifact, null, true, password, false, false);
            baselineCommit = this.gitOps.getCommitArtifactId(branch, baselineData.changeId);
            if (baselineCommit.isInvalid()) {
                throw new OseeArgumentException("No commit with change id [%s] can be found", new Object[]{baselineData.changeId});
            }
        }
        tx.setSoleAttributeValue((ArtifactId)baselineEvent, (AttributeTypeToken)CoreAttributeTypes.GitChangeId, (Object)baselineData.changeId);
        tx.setSoleAttributeValue((ArtifactId)baselineEvent, (AttributeTypeToken)CoreAttributeTypes.BaselinedBy, (Object)baselinedByUser);
        Date baselinedTimestamp = baselineData.baselinedTimestamp == null ? new Date() : baselineData.baselinedTimestamp;
        tx.setSoleAttributeValue((ArtifactId)baselineEvent, (AttributeTypeToken)CoreAttributeTypes.BaselinedTimestamp, (Object)baselinedTimestamp);
        if (baselineData.reviewId != null) {
            tx.setSoleAttributeValue((ArtifactId)baselineEvent, (AttributeTypeToken)CoreAttributeTypes.ReviewId, (Object)baselineData.reviewId);
        }
        if (baselineData.reviewStoryId != null) {
            tx.setSoleAttributeValue((ArtifactId)baselineEvent, (AttributeTypeToken)CoreAttributeTypes.ReviewStoryId, (Object)baselineData.reviewStoryId);
        }
        for (String path : baselineData.files) {
            ArtifactId codeUnit = this.loadCodeUnit((ArtifactId)repoArtifact, branch, path);
            if (codeUnit.isInvalid()) {
                throw new OseeArgumentException("No code unit found for path [%s]", new Object[]{path});
            }
            tx.relate((ArtifactId)baselineEvent, (RelationTypeToken)CoreRelationTypes.SupportingInfo_IsSupportedBy, codeUnit);
            this.updateLGitLatestTuple((ArtifactId)repoArtifact, branch, tx, codeUnit, (ArtifactId)baselineCommit);
        }
        return baselineEvent;
    }

    public ArtifactId baselineFiles(BranchId branch, ArtifactReadable repoArtifact, CertBaselineData baselineData, String password) {
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, "rest - baseline  files");
        ArtifactId baselineEvent = this.baselineFiles(branch, repoArtifact, baselineData, password);
        tx.commit();
        return baselineEvent;
    }

    private ArtifactId loadCodeUnit(ArtifactId repository, BranchId branch, String path) {
        List codeUnits = this.queryFactory.fromBranch(branch).andNameEquals(path).andTypeEquals(new ArtifactTypeToken[]{CoreArtifactTypes.CodeUnit}).asArtifactTokens();
        for (ArtifactToken codeUnit : codeUnits) {
            if (!codeUnit.getName().equals(path)) continue;
            return codeUnit;
        }
        return ArtifactId.SENTINEL;
    }

    private void updateLGitLatestTuple(ArtifactId repository, BranchId branch, TransactionBuilder tx, ArtifactId codeUnit, ArtifactId baselineCommit) {
        ArtifactId[] commitWraper = new ArtifactId[1];
        this.tupleQuery.getTuple4E3E4FromE1E2(DefineTupleTypes.GitLatest, branch, (Object)repository, (Object)codeUnit, (changeCommit, ignore) -> {
            ArtifactId artifactId = changeCommit;
        });
        tx.deleteTuple4ByE1E2(DefineTupleTypes.GitLatest, (Object)repository, (Object)codeUnit);
        tx.addTuple4(DefineTupleTypes.GitLatest, (Object)repository, (Object)codeUnit, (Object)commitWraper[0], (Object)baselineCommit);
    }

    public List<CertBaselineData> getBaselineData(BranchId branch, ArtifactReadable repoArtifact) {
        List certEvents = org.eclipse.osee.framework.jdk.core.util.Collections.transform((Collection)repoArtifact.getChildren(), this::getBaselineData);
        Collections.sort(certEvents);
        return certEvents;
    }

    public TransactionToken copyCertBaselineData(BranchId destinationBranch, String repositoryName, BranchId sourceBranch) {
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(destinationBranch, "rest - copy cert baseline data");
        ArtifactReadable sourceRepo = this.gitOps.getRepoArtifact(sourceBranch, repositoryName);
        ArtifactReadable destinationRepo = this.gitOps.getRepoArtifact(destinationBranch, repositoryName);
        for (CertBaselineData certEvent : this.getBaselineData(sourceBranch, sourceRepo)) {
            this.baselineFiles(destinationBranch, destinationRepo, certEvent, tx, null);
        }
        return tx.commit();
    }

    public List<CertFileData> getCertFileData(BranchId branch, ArtifactReadable repoArtifact) {
        ArrayList<CertFileData> files = new ArrayList<CertFileData>();
        HashCollection baselineEvents = new HashCollection();
        for (ArtifactReadable bl : repoArtifact.getChildren()) {
            CertBaselineData baselineData = this.getBaselineData(bl);
            for (String filePath : baselineData.files) {
                baselineEvents.put((Object)filePath, (Object)baselineData);
            }
        }
        for (String fileName : baselineEvents.keySet()) {
            CertFileData file = new CertFileData();
            file.baselinedInfo = new ArrayList();
            List baselinedCommits = (List)baselineEvents.getValues((Object)fileName);
            Collections.sort(baselinedCommits);
            file.path = fileName;
            for (CertBaselineData baselinedCommit : baselinedCommits) {
                CertFileData.BaselineData baselineData = new CertFileData.BaselineData(file);
                baselineData.baselinedChangeId = baselinedCommit.changeId;
                baselineData.baselinedTimestamp = baselinedCommit.baselinedTimestamp;
                file.baselinedInfo.add(baselineData);
            }
            files.add(file);
        }
        return files;
    }

    public CertBaselineData getBaselineData(ArtifactReadable baselineArtifact) {
        String userId;
        CertBaselineData baselineData = new CertBaselineData();
        baselineData.eventName = baselineArtifact.getName();
        baselineData.changeId = (String)baselineArtifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.GitChangeId);
        ArtifactId baselinedByUser = (ArtifactId)baselineArtifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.BaselinedBy);
        baselineData.baselinedByUserId = userId = ((ArtifactToken)this.queryFactory.fromBranch((BranchId)CoreBranches.COMMON).andId(baselinedByUser).asArtifactTokens((AttributeTypeToken)CoreAttributeTypes.UserId).iterator().next()).getName();
        baselineData.baselinedTimestamp = (Date)baselineArtifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.BaselinedTimestamp);
        baselineData.reviewId = (Integer)baselineArtifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.ReviewId, null);
        baselineData.reviewStoryId = (String)baselineArtifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.ReviewStoryId, null);
        baselineData.files = org.eclipse.osee.framework.jdk.core.util.Collections.transform((Collection)baselineArtifact.getRelated(CoreRelationTypes.SupportingInfo_SupportingInfo).getList(), Named::getName);
        return baselineData;
    }
}

