/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.synchronization.forest.morphology;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.osee.define.operations.synchronization.forest.Grove;
import org.eclipse.osee.define.operations.synchronization.forest.GroveThing;
import org.eclipse.osee.define.operations.synchronization.forest.GroveThingNotFoundWithNativeKeysException;
import org.eclipse.osee.define.operations.synchronization.forest.morphology.DuplicateGroveEntryException;
import org.eclipse.osee.define.operations.synchronization.forest.morphology.DuplicateStoreEntryException;
import org.eclipse.osee.define.operations.synchronization.forest.morphology.Store;
import org.eclipse.osee.define.operations.synchronization.forest.morphology.StoreRank3;
import org.eclipse.osee.define.operations.synchronization.forest.morphology.StoreRankN;
import org.eclipse.osee.define.operations.synchronization.forest.morphology.StoreType;
import org.eclipse.osee.define.operations.synchronization.identifier.Identifier;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierType;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class AbstractMapGrove
implements Grove {
    protected final IdentifierType identifierType;
    protected final Store nativeStore;
    protected final Store primaryStore;

    public AbstractMapGrove(IdentifierType identifierType, boolean groveThingProvidesNativeKeys, Predicate<Object>[] primaryKeyValidators, Predicate<Object>[] nativeKeyValidators) {
        this.identifierType = identifierType;
        this.primaryStore = this.createPrimaryStorage(identifierType == IdentifierType.SPEC_OBJECT ? StoreType.PRIMARY_HIERARCHY : StoreType.PRIMARY, primaryKeyValidators);
        this.nativeStore = groveThingProvidesNativeKeys ? this.createNativeStorage(nativeKeyValidators) : null;
    }

    @Override
    public GroveThing add(GroveThing groveThing) {
        try {
            this.primaryStore.add(groveThing);
            if (Objects.nonNull(this.nativeStore)) {
                this.nativeStore.add(groveThing);
            }
            return groveThing;
        }
        catch (DuplicateStoreEntryException e) {
            throw new DuplicateGroveEntryException(this, (Throwable)e);
        }
    }

    @Override
    public boolean containsByPrimaryKeys(Identifier ... primaryKeys) {
        return this.primaryStore.contains(primaryKeys);
    }

    @Override
    public boolean containsByNativeKeys(Object ... nativeKeys) {
        if (Objects.isNull(this.nativeStore)) {
            throw new IllegalStateException(new Message().title((CharSequence)"AbstractMapGrove::getByNativeKeys, Grove was not created with support for native keys.").indentInc().segment((CharSequence)"Grove Identifier Type", (Object)this.identifierType).toString());
        }
        return this.nativeStore.contains(nativeKeys);
    }

    private Store createNativeStorage(Predicate<Object>[] keyValidators) {
        int keyCount = Objects.nonNull(keyValidators) ? keyValidators.length : 0;
        return keyCount > 0 ? new StoreRankN(StoreType.NATIVE, keyCount, keyValidators) : null;
    }

    private Store createPrimaryStorage(StoreType storeType, Predicate<Object>[] keyValidators) {
        int keyCount = Objects.nonNull(keyValidators) ? keyValidators.length : 0;
        return storeType == StoreType.PRIMARY_HIERARCHY ? new StoreRank3(StoreType.PRIMARY_HIERARCHY, keyValidators[0], keyValidators[1], keyValidators[2]) : new StoreRankN(StoreType.PRIMARY, keyCount, keyValidators);
    }

    @Override
    public Optional<GroveThing> getByPrimaryKeys(Identifier ... primaryKeys) {
        return this.primaryStore.get(primaryKeys);
    }

    @Override
    public Optional<GroveThing> getByNativeKeys(Object ... nativeKeys) {
        if (Objects.isNull(this.nativeStore)) {
            throw new IllegalStateException(new Message().title((CharSequence)"AbstractMapGrove::getByNativeKeys, Grove was not created with support for native keys.").indentInc().segment((CharSequence)"Grove Identifier Type", (Object)this.identifierType).toString());
        }
        return this.nativeStore.get(nativeKeys);
    }

    @Override
    public GroveThing getByNativeKeysOrElseThrow(Object ... nativeKeys) {
        if (Objects.isNull(this.nativeStore)) {
            throw new IllegalStateException(new Message().title((CharSequence)"AbstractMapGrove::getByNativeKeys, Grove was not created with support for native keys.").indentInc().segment((CharSequence)"Grove Identifier Type", (Object)this.identifierType).toString());
        }
        return this.nativeStore.get(nativeKeys).orElseThrow(() -> new GroveThingNotFoundWithNativeKeysException(this, nativeKeys));
    }

    @Override
    public Optional<GroveThing> getByUniquePrimaryKey(Object uniquePrimaryKey) {
        return this.primaryStore.getByUniqueKey(uniquePrimaryKey);
    }

    @Override
    public IdentifierType getType() {
        assert (this.identifierType != null);
        return this.identifierType;
    }

    @Override
    public int nativeRank() {
        return Objects.nonNull(this.nativeStore) ? this.nativeStore.rank() : 0;
    }

    @Override
    public int rank() {
        return this.primaryStore.rank();
    }

    @Override
    public int size() {
        return this.primaryStore.size();
    }

    @Override
    public Stream<GroveThing> stream(Identifier ... primaryKeys) {
        return this.primaryStore.stream(primaryKeys);
    }

    @Override
    public Stream<Identifier> streamIdentifiersDeep(Identifier ... primaryKeys) {
        return this.primaryStore.streamKeysAtAndBelow(primaryKeys);
    }

    @Override
    public Stream<Identifier> streamIdentifiersShallow(Identifier ... primaryKeys) {
        return this.primaryStore.streamKeysAt(primaryKeys);
    }

    @Override
    public Stream<Identifier[]> streamKeySets(Identifier ... primaryKeys) {
        return this.primaryStore.streamKeySets(primaryKeys);
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.indent(indent).title((CharSequence)"Grove").indentInc().segment((CharSequence)"Type", (Object)this.getType()).toMessage((ToMessage)this.primaryStore).toMessage((ToMessage)this.nativeStore).indentDec();
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

