/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.publisher.datarights;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.osee.define.operations.publisher.datarights.DataRightConfiguration;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.publishing.DataRight;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.search.QueryBuilder;

class DataRightClassificationMap {
    private static final DataRight unspecifiedDataRight = new DataRight("Unspecified", DataRightConfiguration.unspecifiedValue);
    private static final Map<String, DataRight> unspecifiedMap = Map.of("Unspecified", unspecifiedDataRight);
    private static final DataRightClassificationMap unspecifiedDataRightClassificationMap = new DataRightClassificationMap(unspecifiedMap);
    private final Map<String, DataRight> map;

    private DataRightClassificationMap(Map<String, DataRight> map) {
        assert (map.containsKey("Unspecified")) : "DataRightClassificationMap::new, the parameter \"map\" does not contain an entry for the unspecified key.";
        this.map = map;
    }

    public static DataRightClassificationMap create(QueryBuilder commonBranchQuery) {
        ArtifactReadable footerMappingArtifact;
        HashMap<String, DataRight> toReturn = new HashMap<String, DataRight>();
        try {
            footerMappingArtifact = commonBranchQuery.andId((ArtifactId)DataRightConfiguration.mappingArtifact).asArtifact();
        }
        catch (Exception exception) {
            return unspecifiedDataRightClassificationMap;
        }
        footerMappingArtifact.getAttributeValues((AttributeTypeToken)DataRightConfiguration.mappingAttribute).forEach(footer -> {
            String[] parts = ((String)footer).split("\\n", 2);
            if (parts.length == 2) {
                String classification = parts[0].trim();
                String content = parts[1].trim();
                DataRight dataRight = new DataRight(classification, content);
                toReturn.put(classification, dataRight);
            }
        });
        if (toReturn.size() == 0) {
            return unspecifiedDataRightClassificationMap;
        }
        if (!toReturn.containsKey("Unspecified")) {
            toReturn.put("Unspecified", unspecifiedDataRight);
        }
        return new DataRightClassificationMap(Collections.unmodifiableMap(toReturn));
    }

    public DataRight get(String classification) {
        DataRight dataRight = this.map.get(Strings.isValid((String)classification) ? classification : "Unspecified");
        return Objects.nonNull(dataRight) ? dataRight : this.map.get("Unspecified");
    }
}

