/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.markdown;

import com.vladsch.flexmark.ext.autolink.AutolinkExtension;
import com.vladsch.flexmark.ext.gfm.tasklist.TaskListExtension;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.ext.toc.TocExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.eclipse.osee.framework.core.util.OseeInf;

public class MarkdownConverter {
    private MutableDataSet options;

    public MarkdownConverter() {
        this.setDefaultOptions();
    }

    public MarkdownConverter(MutableDataSet options) {
        this.options = options;
    }

    public void setOptions(MutableDataSet options) {
        this.options = options;
    }

    private void setDefaultOptions() {
        this.options = new MutableDataSet();
        this.options.set(Parser.EXTENSIONS, Arrays.asList(TablesExtension.create(), TaskListExtension.create(), TocExtension.create(), AutolinkExtension.create()));
    }

    public ByteArrayInputStream convertToHtmlStream(ByteArrayInputStream markdownInputStream) {
        String markdownContent = new String(markdownInputStream.readAllBytes(), StandardCharsets.UTF_8);
        String htmlContent = this.convertToHtmlString(markdownContent);
        return new ByteArrayInputStream(htmlContent.getBytes(StandardCharsets.UTF_8));
    }

    public String convertToHtmlString(String markdownContent) {
        Parser parser = Parser.builder((DataHolder)this.options).build();
        HtmlRenderer renderer = HtmlRenderer.builder((DataHolder)this.options).build();
        Document document = parser.parse(markdownContent);
        return "<html><head><meta charset=\"UTF-8\">" + this.getCssStyles() + "</head><body>\n" + renderer.render((Node)document) + "</body></html>";
    }

    private String getCssStyles() {
        return "<style>\n" + OseeInf.getResourceContents((String)"markdownToHtmlStyles.css", MarkdownConverter.class) + "\n</style>";
    }
}

