/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.markdown;

import java.util.HashMap;
import java.util.regex.Pattern;

public class MarkdownCleaner {
    public static boolean containsSpecialCharacters(String text) {
        Pattern specialCharsPattern = Pattern.compile("[\u00a0\u200b\u200c\u200d\u2003\u2002\u2009\u200a\u205f\u3000\u200e\u200f\u202a\u202b\u202c\u202d\u202e\u2066\u2067\u2068\u2069\ufffc\ufeff\u2019\u2013\u201c\u201d]");
        return specialCharsPattern.matcher(text).find();
    }

    public static String removeSpecialCharacters(String text) {
        char[] specialChars;
        HashMap<Character, Character> replacementMap = new HashMap<Character, Character>();
        replacementMap.put(Character.valueOf('\u2019'), Character.valueOf('\''));
        replacementMap.put(Character.valueOf('\u2013'), Character.valueOf('-'));
        replacementMap.put(Character.valueOf('\u201c'), Character.valueOf('\"'));
        replacementMap.put(Character.valueOf('\u201d'), Character.valueOf('\"'));
        char[] cArray = specialChars = new char[]{'\u00a0', '\u200b', '\u200c', '\u200d', '\u2003', '\u2002', '\u2009', '\u200a', '\u205f', '\u3000', '\u200e', '\u200f', '\u202a', '\u202b', '\u202c', '\u202d', '\u202e', '\u2066', '\u2067', '\u2068', '\u2069', '\ufffc', '\ufeff', '\u2019', '\u2013', '\u201c', '\u201d'};
        int n = specialChars.length;
        int n2 = 0;
        while (n2 < n) {
            char specialChar = cArray[n2];
            char replacement = replacementMap.getOrDefault(Character.valueOf(specialChar), Character.valueOf(' ')).charValue();
            text = text.replace(specialChar, replacement);
            ++n2;
        }
        return text;
    }

    public static boolean containsMarkdownBolds(String text) {
        return text.contains("**");
    }

    public static String removeMarkdownBolds(String text) {
        text = text.replace("**", "");
        return text;
    }
}

