/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.health.operations;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.osee.jdbc.JdbcDbType;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.orcs.OrcsApi;

public class HealthDbTablespace {
    private final OrcsApi orcsApi;
    private String errorMsg = "";
    private final String orderByName;
    private final String orderByDirection;
    private final List<TablespaceMonitoringMetric> tablespaces = new ArrayList<TablespaceMonitoringMetric>();

    public HealthDbTablespace(OrcsApi orcsApi, String orderByName, String orderByDirection) {
        this.orcsApi = orcsApi;
        this.orderByName = orderByName;
        this.orderByDirection = orderByDirection;
    }

    public void queryDbTablespace() {
        if (this.orcsApi.getJdbcService().getClient().getDbType().equals((Object)JdbcDbType.oracle)) {
            List<String> password = this.getPassword();
            if (password.size() == 1) {
                String setRoleQuery = "SET ROLE osee_health IDENTIFIED BY " + password.get(0);
                this.orcsApi.getJdbcService().getClient().runCall(setRoleQuery, new Object[0]);
                String selectFromTblSummaryQuery = "SELECT * FROM OSEE_DB_TABLESPACE_SUMMARY " + this.handleOrderByOracle();
                Consumer<JdbcStatement> consumer = stmt -> {
                    String tName = stmt.getString("TABLESPACE_NAME");
                    String max_ts_pct_used = String.valueOf(stmt.getDouble("MAX_TS_PCT_USED"));
                    String auto_ext = stmt.getString("AUTO_EXT");
                    String ts_pct_used = String.valueOf(stmt.getDouble("TS_PCT_USED"));
                    String ts_pct_free = String.valueOf(stmt.getDouble("TS_PCT_FREE"));
                    String used_ts_size = String.valueOf(stmt.getDouble("USED_TS_SIZE"));
                    String free_ts_size = String.valueOf(stmt.getDouble("FREE_TS_SIZE"));
                    String curr_ts_size = String.valueOf(stmt.getDouble("CURR_TS_SIZE"));
                    String max_ts_size = String.valueOf(stmt.getDouble("MAX_TS_SIZE"));
                    this.tablespaces.add(new TablespaceMonitoringMetric(tName, max_ts_pct_used, auto_ext, ts_pct_used, ts_pct_free, used_ts_size, free_ts_size, curr_ts_size, max_ts_size));
                };
                this.orcsApi.getJdbcService().getClient().runQuery(consumer, selectFromTblSummaryQuery, new Object[0]);
                String unsetRoleQuery = "SET ROLE ALL EXCEPT osee_health";
                this.orcsApi.getJdbcService().getClient().runCall(unsetRoleQuery, new Object[0]);
            }
        } else if (this.orcsApi.getJdbcService().getClient().getDbType().equals((Object)JdbcDbType.postgresql)) {
            String selectFromTablespaceQuery = "SELECT ts.spcname AS tablespace_name, pg_size_pretty(pg_tablespace_size(ts.oid)) AS tablespace_size FROM pg_tablespace ts " + this.handleOrderByPostgres();
            Consumer<JdbcStatement> consumer = stmt -> this.tablespaces.add(new TablespaceMonitoringMetric(stmt.getString("tablespace_name"), stmt.getString("tablespace_size")));
            this.orcsApi.getJdbcService().getClient().runQuery(consumer, selectFromTablespaceQuery, new Object[0]);
        } else {
            this.errorMsg = "Using unsupported database";
        }
    }

    private List<String> getPassword() {
        ArrayList<String> password = new ArrayList<String>();
        Consumer<JdbcStatement> consumer = stmt -> password.add(stmt.getString("OSEE_VALUE"));
        String selectPasswordQuery = "SELECT OSEE_VALUE FROM OSEE_INFO WHERE OSEE_KEY = 'osee.health.view.password'";
        this.orcsApi.getJdbcService().getClient().runQuery(consumer, selectPasswordQuery, new Object[0]);
        return password;
    }

    public String handleOrderByPostgres() {
        String orderByString = " ORDER BY ";
        switch (this.orderByName) {
            case "tablespaceName": {
                orderByString = String.valueOf(orderByString) + "tablespace_name ";
                break;
            }
            case "usedTsSize": {
                orderByString = String.valueOf(orderByString) + "tablespace_size ";
                break;
            }
            default: {
                orderByString = String.valueOf(orderByString) + "tablespace_size ";
            }
        }
        switch (this.orderByDirection) {
            case "asc": {
                orderByString = String.valueOf(orderByString) + "asc ";
                break;
            }
            case "desc": {
                orderByString = String.valueOf(orderByString) + "desc ";
                break;
            }
            default: {
                orderByString = String.valueOf(orderByString) + "desc ";
            }
        }
        return orderByString;
    }

    public String handleOrderByOracle() {
        String orderByString = " ORDER BY ";
        switch (this.orderByName) {
            case "tablespaceName": {
                orderByString = String.valueOf(orderByString) + "TABLESPACE_NAME ";
                break;
            }
            case "maxTsPctUsed": {
                orderByString = String.valueOf(orderByString) + "MAX_TS_PCT_USED ";
                break;
            }
            case "autoExtend": {
                orderByString = String.valueOf(orderByString) + "AUTO_EXT ";
                break;
            }
            case "tsPctUsed": {
                orderByString = String.valueOf(orderByString) + "TS_PCT_USED ";
                break;
            }
            case "tsPctFree": {
                orderByString = String.valueOf(orderByString) + "TS_PCT_FREE ";
                break;
            }
            case "usedTsSize": {
                orderByString = String.valueOf(orderByString) + "USED_TS_SIZE ";
                break;
            }
            case "freeTsSize": {
                orderByString = String.valueOf(orderByString) + "FREE_TS_SIZE ";
                break;
            }
            case "currTsSize": {
                orderByString = String.valueOf(orderByString) + "CURR_TS_SIZE ";
                break;
            }
            case "maxTxSize": {
                orderByString = String.valueOf(orderByString) + "MAX_TS_SIZE ";
                break;
            }
            default: {
                orderByString = String.valueOf(orderByString) + "MAX_TS_PCT_USED ";
            }
        }
        switch (this.orderByDirection) {
            case "asc": {
                orderByString = String.valueOf(orderByString) + "asc ";
                break;
            }
            case "desc": {
                orderByString = String.valueOf(orderByString) + "desc ";
                break;
            }
            default: {
                orderByString = String.valueOf(orderByString) + "desc ";
            }
        }
        return orderByString;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public List<TablespaceMonitoringMetric> getTablespaces() {
        return this.tablespaces;
    }

    public class TablespaceMonitoringMetric {
        private String tablespaceName = "";
        private String maxTsPctUsed = "";
        private String autoExtend = "";
        private String tsPctUsed = "";
        private String tsPctFree = "";
        private String usedTsSize = "";
        private String freeTsSize = "";
        private String currTsSize = "";
        private String maxTxSize = "";

        public TablespaceMonitoringMetric(String tablespaceName, String maxTsPctUsed, String autoExtend, String tsPctUsed, String tsPctFree, String usedTsSize, String freeTsSize, String currTsSize, String maxTxSize) {
            this.tablespaceName = tablespaceName;
            this.maxTsPctUsed = maxTsPctUsed != null ? maxTsPctUsed : "";
            this.autoExtend = autoExtend;
            this.tsPctUsed = tsPctUsed != null ? tsPctUsed : "";
            this.tsPctFree = tsPctFree;
            this.usedTsSize = usedTsSize != null ? usedTsSize : "";
            this.freeTsSize = freeTsSize != null ? freeTsSize : "";
            this.currTsSize = currTsSize;
            this.maxTxSize = maxTxSize;
        }

        public TablespaceMonitoringMetric(String tablespaceName, String usedTsSize) {
            this.tablespaceName = tablespaceName;
            this.usedTsSize = usedTsSize;
        }

        public String getTablespaceName() {
            return this.tablespaceName;
        }

        public String getMaxTsPctUsed() {
            return this.maxTsPctUsed;
        }

        public String getAutoExtend() {
            return this.autoExtend;
        }

        public String getTsPctUsed() {
            return this.tsPctUsed;
        }

        public String getTsPctFree() {
            return this.tsPctFree;
        }

        public String getUsedTsSize() {
            return this.usedTsSize;
        }

        public String getFreeTsSize() {
            return this.freeTsSize;
        }

        public String getCurrTsSize() {
            return this.currTsSize;
        }

        public String getMaxTxSize() {
            return this.maxTxSize;
        }
    }
}

