/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.health.operations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.internal.health.operations.HealthUtils;

public class HealthBalancers {
    private final JdbcClient jdbcClient;
    private String auth = "";

    public HealthBalancers(JdbcClient jdbcClient, OrcsApi orcsApi) {
        this.jdbcClient = jdbcClient;
        this.auth = (String)orcsApi.userService().getUser().getLoginIds().get(0);
    }

    public List<HealthBalancer> getBalancers() {
        ArrayList<HealthBalancer> balancers = new ArrayList<HealthBalancer>();
        List<String> balancerNames = HealthUtils.getBalancers(this.jdbcClient);
        if (balancerNames.size() == 0) {
            balancers.add(new HealthBalancer("", false, "No balancers configured in osee_info"));
            return balancers;
        }
        for (String balancerName : balancerNames) {
            try {
                String urlStr = String.valueOf(balancerName) + "/balancer-manager";
                Boolean reachable = HealthUtils.isUrlReachable(urlStr, this.auth);
                if (reachable.booleanValue()) {
                    balancers.add(new HealthBalancer(balancerName, true, HealthUtils.getErrorMsg()));
                    continue;
                }
                balancers.add(new HealthBalancer(balancerName, false, HealthUtils.getErrorMsg()));
            }
            catch (Exception exception) {
                balancers.add(new HealthBalancer(balancerName, false, HealthUtils.getErrorMsg()));
            }
        }
        return balancers;
    }

    public class HealthBalancer {
        private final String name;
        private final Boolean alive;
        private final String errorMsg;

        public HealthBalancer(String name, Boolean alive, String errorMsg) {
            this.name = name;
            this.alive = alive;
            this.errorMsg = errorMsg;
        }

        public String getName() {
            return this.name;
        }

        public Boolean getAlive() {
            return this.alive;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }
    }
}

