/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.zip.ZipEntry;
import javax.ws.rs.core.Response;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.rest.model.Transaction;

public final class OrcsRestUtil {
    private OrcsRestUtil() {
    }

    public static <T> T executeCallable(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public static Response asResponse(boolean modified) {
        Response.ResponseBuilder builder = modified ? Response.ok() : Response.notModified();
        return builder.build();
    }

    public static List<Transaction> asTransactions(ResultSet<? extends TransactionReadable> results) {
        ArrayList<Transaction> toReturn = new ArrayList<Transaction>(results.size());
        for (TransactionReadable data : results) {
            toReturn.add(OrcsRestUtil.asTransaction(data));
        }
        return toReturn;
    }

    public static Transaction asTransaction(TransactionReadable tx) {
        Transaction data = new Transaction();
        data.setTxId((TransactionId)tx);
        data.setAuthor((ArtifactId)tx.getAuthor());
        data.setBranchUuid(tx.getBranch().getId().longValue());
        data.setComment(tx.getComment());
        data.setCommitArt(tx.getCommitArt());
        data.setTimeStamp(tx.getDate());
        data.setTxType(tx.getTxType());
        return data;
    }

    private static boolean isSearchedFile(String filename, String subname, String ext) {
        if (filename.length() + 1 < subname.length() + ext.length()) {
            return false;
        }
        boolean getname = false;
        boolean getext = false;
        if (subname.isEmpty()) {
            getname = true;
        } else if (filename.contains(subname)) {
            getname = true;
        }
        if (ext.isEmpty()) {
            getext = true;
        } else if (filename.substring(filename.length() - ext.length() - 1, filename.length()).equals("." + ext)) {
            getext = true;
        }
        return getname && getext;
    }

    public static File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(String.valueOf(destDirPath) + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }

    public static String getLatestFile(String folder, String subname, String ext) {
        File dir = new File(folder);
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            return null;
        }
        File lastModifiedFile = files[0];
        int index = -1;
        int i = 0;
        while (i < files.length) {
            if (OrcsRestUtil.isSearchedFile(files[i].getName(), subname, ext)) {
                index = i;
                lastModifiedFile = files[i];
                break;
            }
            ++i;
        }
        i = index + 1;
        while (i < files.length) {
            if (OrcsRestUtil.isSearchedFile(files[i].getName(), subname, ext) && lastModifiedFile.lastModified() < files[i].lastModified()) {
                lastModifiedFile = files[i];
            }
            ++i;
        }
        lastModifiedFile.toString();
        String name = lastModifiedFile.getName();
        if (index > -1) {
            return name;
        }
        return null;
    }
}

