/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IUserGroup;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.model.ExecutedCommandHistory;
import org.eclipse.osee.orcs.rest.model.GridCommanderEndpoint;
import org.eclipse.osee.orcs.rest.model.UserContext;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class GridCommanderEndpointImpl
implements GridCommanderEndpoint {
    private final OrcsApi orcsApi;
    private final BranchId branch;

    public GridCommanderEndpointImpl(OrcsApi orcsApi, BranchId branch, UriInfo uriInfo) {
        this.orcsApi = orcsApi;
        this.branch = branch;
    }

    public TransactionToken createDefaultContext() {
        IUserGroup everyoneUserGroup = this.orcsApi.userService().getUserGroup(CoreUserGroups.Everyone);
        this.orcsApi.userService().requireRole(new IUserGroupArtifactToken[]{CoreUserGroups.AccountAdmin});
        ArtifactId contextId = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andIsOfType(new ArtifactTypeToken[]{CoreArtifactTypes.Context}).andNameEquals("Default User Context").asArtifactIdOrSentinel();
        if (contextId.isValid()) {
            return TransactionToken.SENTINEL;
        }
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction((BranchId)CoreBranches.COMMON, "Create default context");
        ArtifactToken defaultUserContext = tx.createArtifact(CoreArtifactTypes.Context, "Default User Context", ApplicabilityId.BASE);
        tx.setSoleAttributeValue((ArtifactId)defaultUserContext, (AttributeTypeToken)CoreAttributeTypes.Description, (Object)"Context containing all default commands available to users");
        ArtifactToken createNewCommand = tx.createArtifact(CoreArtifactTypes.Command, "Create New Command", ApplicabilityId.BASE);
        tx.setSoleAttributeValue((ArtifactId)createNewCommand, (AttributeTypeToken)CoreAttributeTypes.Description, (Object)"Add a new command to this Context");
        ArtifactToken openURLCommand = tx.createArtifact(CoreArtifactTypes.Command, "Open URL", ApplicabilityId.BASE);
        tx.setSoleAttributeValue((ArtifactId)openURLCommand, (AttributeTypeToken)CoreAttributeTypes.Description, (Object)"Opens a URL provided by user in new tab");
        ArtifactToken helpCommand = tx.createArtifact(CoreArtifactTypes.Command, "Help", ApplicabilityId.BASE);
        tx.setSoleAttributeValue((ArtifactId)helpCommand, (AttributeTypeToken)CoreAttributeTypes.Description, (Object)"Show available commands");
        ArtifactToken filterCommand = tx.createArtifact(CoreArtifactTypes.Command, "Filter", ApplicabilityId.BASE);
        tx.setSoleAttributeValue((ArtifactId)filterCommand, (AttributeTypeToken)CoreAttributeTypes.Description, (Object)"Filters elements in data table");
        ArtifactToken hideColumnCommand = tx.createArtifact(CoreArtifactTypes.Command, "Hide Column", ApplicabilityId.BASE);
        tx.setSoleAttributeValue((ArtifactId)hideColumnCommand, (AttributeTypeToken)CoreAttributeTypes.Description, (Object)"Select columns to hide");
        ArtifactToken findArtifactCommand = tx.createArtifact(CoreArtifactTypes.Command, "Find Artifact", ApplicabilityId.BASE);
        tx.setSoleAttributeValue((ArtifactId)findArtifactCommand, (AttributeTypeToken)CoreAttributeTypes.Description, (Object)"Search for an artifact");
        tx.setSoleAttributeValue((ArtifactId)findArtifactCommand, (AttributeTypeToken)CoreAttributeTypes.HttpMethod, (Object)"GET");
        ArtifactToken createNewCommandParameter = tx.createArtifact(CoreArtifactTypes.ParameterSingleSelect, "Command Action Options", ApplicabilityId.BASE);
        tx.setSoleAttributeValue((ArtifactId)createNewCommandParameter, (AttributeTypeToken)CoreAttributeTypes.Description, (Object)"Command creation options");
        tx.setSoleAttributeValue((ArtifactId)createNewCommandParameter, (AttributeTypeToken)CoreAttributeTypes.DefaultValue, (Object)"Open a URL");
        ArtifactToken urlParameter = tx.createArtifact(CoreArtifactTypes.ParameterString, "URL", ApplicabilityId.BASE);
        tx.setSoleAttributeValue((ArtifactId)urlParameter, (AttributeTypeToken)CoreAttributeTypes.Description, (Object)"URL to open in new browser tab");
        tx.setSoleAttributeValue((ArtifactId)urlParameter, (AttributeTypeToken)CoreAttributeTypes.DefaultValue, (Object)"www.example.com");
        tx.setSoleAttributeValue((ArtifactId)urlParameter, (AttributeTypeToken)CoreAttributeTypes.UseValidator, (Object)true);
        tx.setSoleAttributeValue((ArtifactId)urlParameter, (AttributeTypeToken)CoreAttributeTypes.ValidatorType, (Object)"pattern: (?:http[s]:?\\/\\/)?(?:[\\w\\-]+(?::[\\w\\-]+)?@)?(?:[\\w\\-]+\\.)+(?:[a-z]{2,4})(?::[0-9]+)?(?:\\/[\\w\\-\\.%]+)*(?:\\?(?:[\\w\\-\\.%]+=[\\w\\-\\.%!]+&?)+)?(#\\w+\\-\\.%!)?; required: true");
        ArtifactToken searchTermParameter = tx.createArtifact(CoreArtifactTypes.ParameterString, "Search Term", ApplicabilityId.BASE);
        tx.setSoleAttributeValue((ArtifactId)searchTermParameter, (AttributeTypeToken)CoreAttributeTypes.Description, (Object)"Enter a term to search by: ");
        tx.setSoleAttributeValue((ArtifactId)searchTermParameter, (AttributeTypeToken)CoreAttributeTypes.DefaultValue, (Object)"");
        ArtifactToken searchParamParameter = tx.createArtifact(CoreArtifactTypes.ParameterString, "Search Parameter", ApplicabilityId.BASE);
        tx.setSoleAttributeValue((ArtifactId)searchParamParameter, (AttributeTypeToken)CoreAttributeTypes.Description, (Object)"Enter parameter to search by: ");
        tx.setSoleAttributeValue((ArtifactId)searchParamParameter, (AttributeTypeToken)CoreAttributeTypes.DefaultValue, (Object)"Search Parameter");
        ArtifactToken columnOptionsParameter = tx.createArtifact(CoreArtifactTypes.ParameterMultipleSelect, "Column Options", ApplicabilityId.BASE);
        tx.setSoleAttributeValue((ArtifactId)columnOptionsParameter, (AttributeTypeToken)CoreAttributeTypes.Description, (Object)"Select Column(s) to hide");
        tx.relate((ArtifactId)createNewCommand, CoreRelationTypes.DefaultHierarchical, (ArtifactId)createNewCommandParameter);
        tx.relate((ArtifactId)openURLCommand, CoreRelationTypes.DefaultHierarchical, (ArtifactId)urlParameter);
        tx.relate((ArtifactId)hideColumnCommand, CoreRelationTypes.DefaultHierarchical, (ArtifactId)columnOptionsParameter);
        tx.relate((ArtifactId)filterCommand, CoreRelationTypes.DefaultHierarchical, (ArtifactId)searchTermParameter);
        tx.relate((ArtifactId)findArtifactCommand, CoreRelationTypes.DefaultHierarchical, (ArtifactId)searchParamParameter);
        tx.relate((ArtifactId)defaultUserContext, CoreRelationTypes.ContextToCommand, (ArtifactId)createNewCommand);
        tx.relate((ArtifactId)defaultUserContext, CoreRelationTypes.ContextToCommand, (ArtifactId)openURLCommand);
        tx.relate((ArtifactId)defaultUserContext, CoreRelationTypes.ContextToCommand, (ArtifactId)helpCommand);
        tx.relate((ArtifactId)defaultUserContext, CoreRelationTypes.ContextToCommand, (ArtifactId)filterCommand);
        tx.relate((ArtifactId)defaultUserContext, CoreRelationTypes.ContextToCommand, (ArtifactId)hideColumnCommand);
        tx.relate((ArtifactId)defaultUserContext, CoreRelationTypes.ContextToCommand, (ArtifactId)findArtifactCommand);
        tx.relate((ArtifactId)everyoneUserGroup.getArtifact(), CoreRelationTypes.UserGroupToContext, (ArtifactId)defaultUserContext);
        return tx.commit();
    }

    public List<UserContext> getUserCommands() {
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(this.branch);
        UserToken user = this.orcsApi.userService().getUser();
        List roles = user.getRoles();
        ArtifactReadable userWithContextsReadable = query.andId((ArtifactId)user).follow(CoreRelationTypes.UserToContext_Context).follow(CoreRelationTypes.ContextToCommand_Artifact).follow(CoreRelationTypes.DefaultHierarchical_Child).asArtifact();
        List groups = query.andIds((Collection)roles).follow(CoreRelationTypes.UserGroupToContext_Context).follow(CoreRelationTypes.ContextToCommand_Artifact).follow(CoreRelationTypes.DefaultHierarchical_Child).asArtifacts();
        HashSet contexts = new HashSet();
        contexts.addAll(userWithContextsReadable.getRelatedList(CoreRelationTypes.UserToContext_Context));
        groups.forEach(group -> {
            boolean bl = contexts.addAll(group.getRelatedList(CoreRelationTypes.UserGroupToContext_Context));
        });
        ArrayList contextList = new ArrayList(contexts);
        List<UserContext> usersContexts = contextList.stream().filter(cntxt -> cntxt.isValid()).map(context -> new UserContext(context)).collect(Collectors.toList());
        return usersContexts;
    }

    public ExecutedCommandHistory asExecutedCommandHistoryTable() {
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(this.branch);
        UserToken user = this.orcsApi.userService().getUser();
        List<String> columnHeaders = Arrays.asList("Artifact Id", "Name", "Parameters", "Timestamp", "Execution Frequency", "Validated", "Favorite");
        ArtifactReadable userWithExecutedCmdHistoryReadable = query.andId((ArtifactId)user).follow(CoreRelationTypes.UserToHistory_ExecutedCommandHistory).follow(CoreRelationTypes.DefaultHierarchical_Child).asArtifact();
        if (!userWithExecutedCmdHistoryReadable.getRelated(CoreRelationTypes.UserToHistory_ExecutedCommandHistory, ArtifactTypeToken.SENTINEL).isEmpty()) {
            ArtifactReadable cmdHistory = (ArtifactReadable)userWithExecutedCmdHistoryReadable.getRelated(CoreRelationTypes.UserToHistory_ExecutedCommandHistory, ArtifactTypeToken.SENTINEL).get(0);
            return new ExecutedCommandHistory(user, cmdHistory, columnHeaders);
        }
        return new ExecutedCommandHistory(user);
    }
}

