/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.ApiKeyApi;
import org.eclipse.osee.framework.core.data.ApiKey;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.KeyScopeContainer;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.KeyScope;
import org.eclipse.osee.jdbc.JdbcService;

public class ApiKeyApiImpl
implements ApiKeyApi {
    private final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private JdbcService jdbcService;

    public void start() {
    }

    public void setJdbcService(JdbcService jdbcService) {
        this.jdbcService = jdbcService;
    }

    public List<ApiKey> getApiKeys(ArtifactId userArtId) {
        String query = "select * from osee_api_key where user_art_id = ?";
        ArrayList<ApiKey> apiKeys = new ArrayList<ApiKey>();
        this.jdbcService.getClient().runQuery(stmt -> {
            boolean bl = apiKeys.add(new ApiKey(stmt.getString("key_name"), Arrays.stream(stmt.getString("scopes").split(",")).map(scopeID -> new KeyScopeContainer(Long.valueOf(Long.parseLong(scopeID)))).collect(Collectors.toList()), stmt.getString("creation_date").replaceAll(" \\d{2}:\\d{2}:\\d{2}$", ""), stmt.getString("expiration_date").replaceAll(" \\d{2}:\\d{2}:\\d{2}$", ""), stmt.getString("key_uid")));
        }, query, new Object[]{userArtId});
        return apiKeys;
    }

    public ApiKey getApiKey(String apiKeyString) {
        String query = "SELECT * FROM osee_api_key WHERE API_KEY_VALUE = ? FETCH FIRST 1 ROWS ONLY";
        apiKeyString = this.hashApiKey(apiKeyString);
        AtomicReference apiKeyRef = new AtomicReference();
        this.jdbcService.getClient().runQuery(stmt -> {
            ApiKey apiKey = new ApiKey(stmt.getString("key_name"), Arrays.stream(stmt.getString("scopes").split(",")).map(scopeID -> new KeyScopeContainer(Long.valueOf(Long.parseLong(scopeID)))).collect(Collectors.toList()), stmt.getString("creation_date").replaceAll(" \\d{2}:\\d{2}:\\d{2}$", ""), stmt.getString("expiration_date").replaceAll(" \\d{2}:\\d{2}:\\d{2}$", ""), stmt.getString("key_uid"), UserId.valueOf((Long)stmt.getLong("user_art_id")));
            apiKeyRef.set(apiKey);
        }, query, new Object[]{apiKeyString});
        return (ApiKey)apiKeyRef.get();
    }

    public List<KeyScopeContainer> getKeyScopes() {
        List<KeyScopeContainer> keyScopes = this.scopesToContainer(KeyScope.values(), false);
        return keyScopes;
    }

    public Map<String, String> createApiKey(ApiKey apiKey, ArtifactId userArtId) {
        String apiKeyValue = this.generateApiKey();
        apiKey.setHashedValue(this.hashApiKey(apiKeyValue));
        HashMap<String, String> uidAndValue = new HashMap<String, String>();
        uidAndValue.put("uniqueID", this.saveApiKey(apiKey, userArtId));
        uidAndValue.put("keyValue", apiKeyValue);
        return uidAndValue;
    }

    private String saveApiKey(ApiKey apiKey, ArtifactId userArtId) {
        String insertSql = "insert into osee_api_key(key_name,api_key_value,scopes,creation_date,expiration_date,user_art_id)  values (?,?,?,?,?,?)";
        String selectSql = "SELECT KEY_UID FROM osee_api_key WHERE API_KEY_VALUE = ? FETCH FIRST 1 ROWS ONLY";
        this.jdbcService.getClient().runPreparedUpdate(insertSql, new Object[]{apiKey.getName(), apiKey.getHashedValue(), String.join((CharSequence)",", apiKey.getScopes().stream().map(scopeContainer -> scopeContainer.getId().toString()).collect(Collectors.toList())), this.dateStringToTimestamp(apiKey.getCreationDate()), this.dateStringToTimestamp(apiKey.getExpirationDate()), userArtId});
        AtomicReference uniqueIdRef = new AtomicReference();
        this.jdbcService.getClient().runQuery(stmt -> uniqueIdRef.set(stmt.getString("key_uid")), selectSql, new Object[]{apiKey.getHashedValue()});
        return (String)uniqueIdRef.get();
    }

    public boolean revokeApiKey(long keyUID) {
        String deleteSql = "delete from osee_api_key where KEY_UID = ?";
        int rowsDeleted = this.jdbcService.getClient().runPreparedUpdate(deleteSql, new Object[]{keyUID});
        return rowsDeleted > 0;
    }

    public boolean checkKeyExpiration(ApiKey apiKey) {
        LocalDate expirationDate;
        LocalDate currentDate = LocalDate.now();
        return currentDate.isEqual(expirationDate = LocalDate.parse(apiKey.getExpirationDate(), this.dateFormatter)) || currentDate.isBefore(expirationDate);
    }

    private String generateApiKey() {
        SecureRandom secureRandom = new SecureRandom();
        StringBuilder apiKeValue = new StringBuilder();
        int i = 0;
        while (i < 32) {
            int randomIndex = secureRandom.nextInt("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789@~".length());
            apiKeValue.append("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789@~".charAt(randomIndex));
            ++i;
        }
        return apiKeValue.toString();
    }

    private String hashApiKey(String apiKeyValue) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] encodedhash = digest.digest(apiKeyValue.getBytes("UTF-8"));
            StringBuilder hexString = new StringBuilder(2 * encodedhash.length);
            byte[] byArray = encodedhash;
            int n = encodedhash.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
                ++n2;
            }
            return hexString.toString();
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    private List<KeyScopeContainer> scopeIdsToContainer(Long[] scopeIds, boolean selected) {
        return Arrays.stream(scopeIds).map(KeyScope::fromId).map(scope -> new KeyScopeContainer(scope.getId(), scope.getName(), selected)).collect(Collectors.toList());
    }

    private List<KeyScopeContainer> scopesToContainer(KeyScope[] scopes, boolean selected) {
        return Arrays.stream(scopes).map(scope -> new KeyScopeContainer(scope.getId(), scope.getName(), selected)).collect(Collectors.toList());
    }

    private Timestamp dateStringToTimestamp(String dateString) {
        LocalDateTime localDateTime = LocalDate.parse(dateString).atStartOfDay();
        return Timestamp.valueOf(localDateTime);
    }
}

