/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.xml.publishing;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osee.framework.core.xml.publishing.AbstractElementList;
import org.eclipse.osee.framework.core.xml.publishing.WordElement;
import org.eclipse.osee.framework.core.xml.publishing.XmlAttributeSpecification;
import org.eclipse.osee.framework.core.xml.publishing.XmlTagSpecification;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractElement
implements WordElement {
    private final Map<Pair<Class<?>, Class<?>>, Object> childMap;
    private final Element element;
    private boolean isLeaf;
    private final boolean isRoot;
    private final WordElement parent;
    private final XmlTagSpecification wordXmlTag;

    AbstractElement(WordElement parent, Element element, XmlTagSpecification wordXmlTag) {
        this.parent = Objects.requireNonNull(parent);
        this.element = Objects.requireNonNull(element);
        this.wordXmlTag = Objects.requireNonNull(wordXmlTag);
        this.childMap = new HashMap();
        this.isLeaf = true;
        this.isRoot = Objects.isNull(this.parent);
    }

    AbstractElement(Element element, XmlTagSpecification wordXmlTag) {
        this.parent = null;
        this.element = Objects.requireNonNull(element);
        this.wordXmlTag = Objects.requireNonNull(wordXmlTag);
        this.childMap = new HashMap();
        this.isLeaf = true;
        this.isRoot = Objects.isNull(this.parent);
    }

    @Override
    public <C> Optional<C> getChild(Pair<Class<?>, Class<?>> childKey) {
        Object child = this.childMap.get(childKey);
        return Optional.ofNullable(child);
    }

    @Override
    public Document getDocument() {
        return this.element.getOwnerDocument();
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    @Override
    public WordElement getParent() {
        if (this.isRoot) {
            throw new NoSuchElementException("AbstractElement::getParent, WordElement is the root element.");
        }
        return this.parent;
    }

    public String getTag() {
        return this.wordXmlTag.getFullname();
    }

    @Override
    public String getText() {
        return Objects.requireNonNull(this.element.getTextContent(), "AbstractElement::getText, Element text is unexpectedly null.");
    }

    @Override
    public Optional<String> getAttribute(XmlAttributeSpecification wordXmlAttribute) {
        if (!this.wordXmlTag.isValidAttribute(wordXmlAttribute)) {
            return Optional.empty();
        }
        Attr attributeNode = this.element.getAttributeNode(wordXmlAttribute.getFullname());
        if (Objects.isNull(attributeNode)) {
            return Optional.empty();
        }
        return Optional.of(attributeNode.getNodeValue());
    }

    @Override
    public boolean isLeaf() {
        return this.isLeaf;
    }

    @Override
    public boolean isRootElement() {
        return this.isRoot;
    }

    <C> void setChild(@NonNull C child) {
        Conditions.requireNonNull(child, (String)"child");
        if (!(child instanceof AbstractElement) && !(child instanceof AbstractElementList)) {
            throw new IllegalArgumentException(new StringBuilder(1024).append("AbstractElement::setChild, the parameter \"child\" is not of an allowed class.").append("\n").append("   Child Class:     ").append(child.getClass().getName()).append("\n").append("   Allowed Classes: ").append("AbstractElement, AbstractElementList").append("\n").toString());
        }
        Pair childKey = child instanceof AbstractElementList ? Pair.createNullableImmutable(child.getClass(), ((AbstractElementList)child).getParent().getClass()) : Pair.createNullableImmutable(child.getClass(), null);
        Object priorChild = this.childMap.put(childKey, child);
        this.isLeaf = false;
        if (Objects.nonNull(priorChild)) {
            this.childMap.put(childKey, priorChild);
            throw new IllegalStateException(new StringBuilder(1024).append("AbstractElement::setChild, attempt to set a child that has already been set.").append("\n").append("   Child Class: ").append(child.getClass().getName()).append("\n").append("   Prior Child: ").append(priorChild).append("\n").append("   Child:       ").append(child).append("\n").toString());
        }
    }
}

