/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.util;

public class Result {
    public static Result TrueResult = new Result(true);
    public static Result FalseResult = new Result(false);
    public static Result CancelledResult = new Result(false, true);
    private boolean isTrue;
    private boolean cancelled = false;
    private String text = "";

    public Result(boolean valid, String text) {
        this.isTrue = valid;
        this.text = text;
    }

    public Result(String text) {
        this.isTrue = false;
        this.text = text;
    }

    public Result(String format, Object ... objects) {
        this.isTrue = false;
        this.text = String.format(format, objects);
    }

    public Result(boolean isTrue) {
        this.isTrue = isTrue;
    }

    public Result(boolean isTrue, boolean cancelled) {
        this.isTrue = isTrue;
        this.cancelled = cancelled;
    }

    public void set(boolean isTrue) {
        this.isTrue = isTrue;
    }

    public Result() {
        this.isTrue = true;
    }

    public boolean isTrue() {
        return this.isTrue;
    }

    public boolean isFalse() {
        return !this.isTrue;
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.isTrue())) + (this.getText().equals("") ? "" : " - \"" + this.getText() + "\"");
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setTextWithFormat(String format, Object ... objects) {
        this.text = String.format(format, objects);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public void errorf(String format, String data) {
        this.isTrue = false;
        this.text = String.valueOf(this.text) + String.format(format, data);
    }

    public void logf(String format, String data) {
        this.text = String.valueOf(this.text) + String.format(format, data);
    }
}

