/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing.wordml;

import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osee.framework.core.publishing.IncludeBookmark;
import org.eclipse.osee.framework.core.publishing.PublishingAppender;
import org.eclipse.osee.framework.core.publishing.PublishingAppenderBase;
import org.eclipse.osee.framework.core.publishing.WordCoreUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.xml.XmlEncoderDecoder;

public class WordMlPublishingAppender
extends PublishingAppenderBase {
    public WordMlPublishingAppender(Appendable appendable) {
        super(appendable);
    }

    @Override
    public void addBold() {
        this.append("<w:b/>");
    }

    @Override
    public void addEditParagraphNoEscape(CharSequence text) {
        this.startParagraph();
        this.append(text);
        this.endParagraph();
    }

    @Override
    public void addErrorRow(CharSequence id, CharSequence name, CharSequence type, CharSequence description) {
        this.addTableRow(id, name, type, description);
    }

    @Override
    public void addNoProof() {
        this.append("<w:noProof/>");
    }

    @Override
    public void addOleData(CharSequence oleData) {
        this.append("<w:docOleData>");
        this.append(oleData);
        this.append("</w:docOleData>");
    }

    @Override
    public void addPageMargins() {
        this.append("<w:pgMar w:top=\"1440\" w:right=\"1296\" w:bottom=\"1440\" w:left=\"1296\" w:header=\"720\" w:footer=\"720\" w:gutter=\"0\"/>");
    }

    @Override
    public void addPageSize(WordCoreUtil.pageType pageType2) {
        this.append(pageType2.getPageSize());
    }

    @Override
    public void addParagraph(CharSequence text) {
        this.startParagraph();
        this.addTextInsideParagraph(text);
        this.endParagraph();
    }

    @Override
    public void addParagraphBold(CharSequence text) {
        this.startParagraph();
        this.startRun();
        this.startRunPresentation();
        this.addBold();
        this.endRunPresentation();
        this.startText();
        this.appendEscaped(text);
        this.endText();
        this.startRunPresentation();
        this.addBold();
        this.endRunPresentation();
        this.endRun();
        this.endParagraph();
    }

    @Override
    public void addParagraphNoEscape(CharSequence text) {
        this.startParagraph();
        this.startRun();
        this.startText();
        this.append(text);
        this.endText();
        this.endRun();
        this.endParagraph();
    }

    private void addParagraphStyle(CharSequence style) {
        this.append("<w:pStyle w:val=\"");
        this.append(style);
        this.append("\"/>");
    }

    private void addParagraphStyle(CharSequence style, int outlineLevel) {
        this.append("<w:pStyle w:val=\"");
        this.append(style);
        this.append(Integer.toString(outlineLevel));
        this.append("\"/>");
    }

    @Override
    public void addRunWithTextEscape(CharSequence text) {
        CharSequence xmlEncodedText = XmlEncoderDecoder.textToXml((CharSequence)text);
        this.startRun();
        this.startText();
        this.append(xmlEncodedText);
        this.endText();
        this.endRun();
    }

    @Override
    public void addRunWithTextEscape(CharSequence ... texts) {
        if (Objects.isNull(texts) || texts.length == 0) {
            return;
        }
        this.startRun();
        this.startText();
        CharSequence[] charSequenceArray = texts;
        int n = texts.length;
        int n2 = 0;
        while (n2 < n) {
            CharSequence text = charSequenceArray[n2];
            CharSequence xmlEncodedText = XmlEncoderDecoder.textToXml((CharSequence)text);
            this.append(xmlEncodedText);
            ++n2;
        }
        this.endText();
        this.endRun();
    }

    @Override
    public void addRunWithTextNoEscape(CharSequence text) {
        this.startRun();
        this.startText();
        this.append(text);
        this.endText();
        this.endRun();
    }

    @Override
    public void addRunWithTextNoEscape(CharSequence ... texts) {
        if (Objects.isNull(texts) || texts.length == 0) {
            return;
        }
        this.startRun();
        this.startText();
        CharSequence[] charSequenceArray = texts;
        int n = texts.length;
        int n2 = 0;
        while (n2 < n) {
            CharSequence text = charSequenceArray[n2];
            this.append(text);
            ++n2;
        }
        this.endText();
        this.endRun();
    }

    @Override
    public void addTableCaption(CharSequence captionText) {
        this.append("<w:p wsp:rsidR=\"003571A9\" wsp:rsidRDefault=\"00AE7B3F\" wsp:rsidP=\"00AE7B3F\">");
        this.startParagraphPresentation();
        this.addParagraphStyle("Caption");
        this.endParagraphPresentation();
        this.addRunWithTextNoEscape((CharSequence)"Table ");
        this.append("<w:fldSimple w:instr=\" SEQ Table \\* ARABIC \">");
        this.startRun();
        this.startRunPresentation();
        this.addNoProof();
        this.endRunPresentation();
        this.startText();
        this.append("#");
        this.endText();
        this.endRun();
        this.append("</w:fldSimple>");
        this.addRunWithTextNoEscape(": ", captionText);
        this.endParagraph();
    }

    @Override
    public void addTableColumn(CharSequence text) {
        this.startTableColumn();
        this.addParagraph(text);
        this.endTableColumn();
    }

    @Override
    public void addTableColumns(CharSequence ... texts) {
        CharSequence[] charSequenceArray = texts;
        int n = texts.length;
        int n2 = 0;
        while (n2 < n) {
            CharSequence text = charSequenceArray[n2];
            this.addTableColumn(text);
            ++n2;
        }
    }

    @Override
    public void addTableColumnHeader(CharSequence text) {
        this.startTableColumn();
        this.addParagraphBold(text);
        this.endTableColumn();
    }

    @Override
    public void addTableColumnHeaders(CharSequence ... texts) {
        CharSequence[] charSequenceArray = texts;
        int n = texts.length;
        int n2 = 0;
        while (n2 < n) {
            CharSequence text = charSequenceArray[n2];
            this.addTableColumnHeader(text);
            ++n2;
        }
    }

    @Override
    public void addTableRow(CharSequence ... texts) {
        this.startTableRow();
        this.addTableColumns(texts);
        this.endTableRow();
    }

    @Override
    public void addTableHeaderRow(CharSequence ... texts) {
        this.startTableRow();
        this.addTableColumnHeaders(texts);
        this.endTableRow();
    }

    @Override
    public void addTablePresentation(WordCoreUtil.tablePresentation tablePresentation2) {
        this.append(tablePresentation2.get());
    }

    @Override
    public void addTextInsideParagraph(CharSequence text) {
        this.startRun();
        this.startText();
        this.appendEscaped(text);
        this.endText();
        this.endRun();
    }

    @Override
    public void addTextInsideParagraph(CharSequence text, CharSequence rgbHexColor) {
        StringBuilder runPresentationWithColor = WordCoreUtil.getRunPresentationWithRgbHexColor(rgbHexColor);
        this.startRun();
        this.append(runPresentationWithColor);
        this.startText();
        this.appendEscaped(text);
        this.endText();
        this.endRun();
    }

    private void appendEscaped(CharSequence value) {
        CharSequence xmlEncodedText = XmlEncoderDecoder.textToXml((CharSequence)value);
        CharSequence xmlEncodedTextWithWordMlHardLineBreaks = WordCoreUtil.replaceVerticalWhitespaceCharactersWithWordMlHardLineBreaks(xmlEncodedText);
        this.append(xmlEncodedTextWithWordMlHardLineBreaks);
    }

    @Override
    public void createHyperLinkDoc(CharSequence filename) {
        StringBuilder hyperlinkDocument = WordCoreUtil.getHyperlinkDocument(filename);
        this.append(hyperlinkDocument);
    }

    @Override
    public void endAppendixSubSection() {
        this.endSubSection();
    }

    @Override
    public void endErrorLog() {
        this.endTable();
        this.addTableCaption("Error Log");
        this.endAppendixSubSection();
        this.setPageBreak(true, 1, true);
    }

    @Override
    public void endListPresentation() {
        this.append("</w:listPr>");
    }

    @Override
    public PublishingAppender endParagraph() {
        this.append("</w:p>");
        return this;
    }

    @Override
    public void endParagraphPresentation() {
        this.append("</w:pPr>");
    }

    @Override
    public void endRun() {
        this.append("</w:r>");
    }

    @Override
    public void endRunPresentation() {
        this.append("</w:rPr>");
    }

    @Override
    public void endSection() {
        this.append("</wx:sect>");
    }

    @Override
    public void endSectionPresentation() {
        this.append("</w:sectPr>");
    }

    @Override
    public void endSubSection() {
        this.append("</wx:sub-section>");
    }

    @Override
    public void endTable() {
        this.append("</w:tbl>");
        this.endSubSection();
    }

    @Override
    public void endTableColumn() {
        this.append("</w:tc>");
    }

    @Override
    public void endTableRow() {
        this.append("</w:tr>");
    }

    @Override
    public void endText() {
        this.append("</w:t>");
    }

    @Override
    public void resetListValue() {
        this.startParagraph();
        this.append("<w:pPr><w:rPr><w:vanish/></w:rPr></w:pPr>");
        this.endParagraph();
        this.startParagraph();
        this.append("<w:pPr><w:rPr><w:vanish/></w:rPr></w:pPr><w:r><w:rPr><w:vanish/></w:rPr><w:fldChar w:fldCharType=\"begin\"/></w:r><w:r><w:rPr><w:vanish/></w:rPr><w:instrText> LISTNUM  \\l 1 \\s 0 </w:instrText></w:r><w:r><w:rPr><w:vanish/></w:rPr><w:fldChar w:fldCharType=\"end\"/><wx:t wx:val=\"1.\"/></w:r>");
        this.endParagraph();
    }

    @Override
    public void setPageBreak(boolean chapterNumbering, int chapterStyle, boolean restartNumbering) {
        this.setPageBreak(chapterNumbering, chapterStyle, restartNumbering, WordCoreUtil.pageType.PORTRAIT);
    }

    @Override
    public void setPageBreak(boolean chapterNumbering, int chapterStyle, boolean restartNumbering, WordCoreUtil.pageType pageType2) {
        this.startParagraph();
        this.startParagraphPresentation();
        this.startSectionPresentation();
        this.addPageSize(pageType2);
        this.addPageMargins();
        if (chapterNumbering) {
            this.append("<w:pgNumType ");
            if (restartNumbering) {
                this.append("w:start=\"1\" ");
            }
            this.append("w:chap-style=\"");
            this.append(Integer.toString(chapterStyle));
            this.append("\"/>");
        }
        this.endSectionPresentation();
        this.endParagraphPresentation();
        this.endParagraph();
    }

    @Override
    public void setPageLayout(WordCoreUtil.pageType pageType2) {
        if (WordCoreUtil.pageType.LANDSCAPE.equals((Object)pageType2)) {
            this.startParagraph();
            this.startParagraphPresentation();
            this.startSectionPresentation();
            this.addPageSize(pageType2);
            this.endSectionPresentation();
            this.endParagraphPresentation();
            this.endParagraph();
        }
    }

    @Override
    public void startAppendixSubSection(CharSequence style, CharSequence headingText) {
        this.startSubSection();
        if (Strings.isValid((CharSequence[])new CharSequence[]{headingText})) {
            this.startParagraph();
            this.startParagraphPresentation();
            this.addParagraphStyle(style);
            this.endParagraphPresentation();
            this.addTextInsideParagraph(headingText);
            this.endParagraph();
        }
    }

    @Override
    public void startErrorLog() {
        this.startAppendixSubSection("Heading1", "Error Log");
        this.startTable();
        this.append("<w:tblPr><w:tblW w:w=\"0\" w:type=\"auto\"/><w:tblBorders><w:top w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/><w:left w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/><w:bottom w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/><w:right w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/><w:insideH w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/><w:insideV w:val=\"single\" w:sz=\"4\" wx:bdrwidth=\"10\" w:space=\"0\" w:color=\"auto\"/></w:tblBorders></w:tblPr>");
        this.addTableHeaderRow("Artifact Id", "Artifact Name", "Artifact Type", "Description");
    }

    @Override
    public void startListPresentation() {
        this.append("<w:listPr>");
    }

    @Override
    public void startOutlineSubSection(@Nullable String[] bookmark, @Nullable CharSequence headingNumber, int headingLevel, @Nullable CharSequence headingText, @Nullable CharSequence outlineType, @Nullable CharSequence font) {
        String closeBookmark;
        String openBookmark;
        IncludeBookmark includeBookmark;
        if (bookmark != null && bookmark.length == 2 && Strings.isValidAndNonBlank((String)bookmark[0]) && Strings.isValidAndNonBlank((String)bookmark[1])) {
            includeBookmark = IncludeBookmark.YES;
            openBookmark = bookmark[0];
            closeBookmark = bookmark[1];
        } else {
            includeBookmark = IncludeBookmark.NO;
            openBookmark = "";
            closeBookmark = "";
        }
        this.startSubSection();
        if (includeBookmark.isYes()) {
            this.append(openBookmark);
        }
        if (Strings.isValid((CharSequence[])new CharSequence[]{headingText}) && Strings.isValid((CharSequence[])new CharSequence[]{headingNumber})) {
            CharSequence safeFont = Strings.isValidAndNonBlank((CharSequence)font) ? font : "Times New Roman";
            CharSequence safeOutlineType = Strings.isValidAndNonBlank((CharSequence)outlineType) ? outlineType : "Heading";
            this.startParagraph();
            this.startParagraphPresentation();
            this.addParagraphStyle(safeOutlineType, headingLevel);
            this.startListPresentation();
            this.append("<wx:t wx:val=\"");
            this.append(headingNumber);
            this.append("\" wx:wTabBefore=\"540\" wx:wTabAfter=\"90\"/><wx:font wx:val=\"");
            this.append(safeFont);
            this.append("\"/>");
            this.endListPresentation();
            this.endParagraphPresentation();
            this.addTextInsideParagraph(headingText);
            this.endParagraph();
        }
        if (includeBookmark.isYes()) {
            this.append(closeBookmark);
        }
    }

    @Override
    public void endOutlineSubSection() {
        this.endSubSection();
    }

    @Override
    public PublishingAppender startParagraph() {
        this.append("<w:p>");
        return this;
    }

    @Override
    public void startParagraphPresentation() {
        this.append("<w:pPr>");
    }

    @Override
    public void startRun() {
        this.append("<w:r>");
    }

    @Override
    public void startRunPresentation() {
        this.append("<w:rPr>");
    }

    @Override
    public void startSection() {
        this.append("<wx:sect>");
    }

    @Override
    public void startSectionPresentation() {
        this.append("<w:sectPr>");
    }

    @Override
    public void startSubSection() {
        this.append("<wx:sub-section>");
    }

    @Override
    public void startTable() {
        this.startSubSection();
        this.append("<w:tbl>");
    }

    @Override
    public void startTableColumn() {
        this.append("<w:tc>");
    }

    @Override
    public void startTableRow() {
        this.append("<w:tr>");
    }

    @Override
    public void startText() {
        this.append("<w:t>");
    }

    @Override
    public void endArtifact() {
    }
}

