/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.publishing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.osee.framework.core.publishing.PublishingArtifact;

public abstract class PublishingArtifactBase
implements PublishingArtifact {
    private boolean areChildrenCached = false;
    private boolean bookmarked = false;
    private boolean changed = false;
    private boolean endsSection = false;
    private List<Integer> hierarchyPosition = null;
    private boolean hierarchyPositionSet = false;
    private final Set<PublishingArtifact> hyperlinkFrom = new HashSet<PublishingArtifact>();
    private final Set<PublishingArtifact> hyperlinkTo = new HashSet<PublishingArtifact>();
    private int outlineLevel = 0;
    private boolean processed = false;
    private String publishingContent = null;
    private int renderedAttributeCount = 0;
    private boolean startsSection = false;

    @Override
    public boolean areChildrenCached() {
        return this.areChildrenCached;
    }

    @Override
    public void clearBookmarked() {
        this.bookmarked = false;
    }

    @Override
    public void clearEndOfSection() {
        this.endsSection = false;
    }

    @Override
    public void clearHyperlinkFrom(PublishingArtifact artifact) {
        this.hyperlinkFrom.remove(artifact);
    }

    @Override
    public void clearHyperlinkTo(PublishingArtifact artifact) {
        this.hyperlinkTo.remove(artifact);
    }

    @Override
    public void clearProcessed() {
        this.processed = false;
    }

    @Override
    public void clearStartOfSection() {
        this.startsSection = false;
    }

    @Override
    public List<Integer> getHierarchyPosition() {
        if (!this.hierarchyPositionSet) {
            throw new IllegalStateException();
        }
        return this.hierarchyPosition;
    }

    @Override
    public int getOutlineLevel() {
        return this.hierarchyPosition != null ? this.hierarchyPosition.size() : 0;
    }

    @Override
    public Optional<String> getPublishingContent() {
        return Optional.ofNullable(this.publishingContent);
    }

    @Override
    public void incrementRenderedAttributeCount() {
        ++this.renderedAttributeCount;
    }

    @Override
    public boolean isBookmarked() {
        return this.bookmarked;
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public boolean isEndOfSection() {
        return this.endsSection;
    }

    @Override
    public boolean isHierarchyPositionSet() {
        return this.hierarchyPositionSet;
    }

    @Override
    public boolean isHyperlinked() {
        return !this.hyperlinkFrom.isEmpty();
    }

    @Override
    public boolean isHyperlinkedFrom(PublishingArtifact artifact) {
        return this.hyperlinkFrom.contains(artifact);
    }

    @Override
    public boolean isHyperlinkedTo(PublishingArtifact artifact) {
        return this.hyperlinkTo.contains(artifact);
    }

    @Override
    public boolean isProcessed() {
        return this.processed;
    }

    @Override
    public boolean isPublished() {
        return this.renderedAttributeCount > 0;
    }

    @Override
    public boolean isPublishingContentCached() {
        return Objects.nonNull(this.publishingContent);
    }

    @Override
    public boolean isStartOfSection() {
        return this.startsSection;
    }

    @Override
    public void pushHierarchyPosition(Integer position) {
        if (this.hierarchyPositionSet) {
            throw new IllegalStateException();
        }
        (Objects.isNull(this.hierarchyPosition) ? (this.hierarchyPosition = new ArrayList<Integer>()) : this.hierarchyPosition).add(0, position);
    }

    @Override
    public void setBookmarked() {
        this.bookmarked = true;
    }

    @Override
    public void setChanged() {
        this.changed = true;
    }

    @Override
    public void setChildrenLoadedAndCached() {
        this.areChildrenCached = true;
    }

    @Override
    public void setEndOfSection() {
        this.endsSection = true;
    }

    @Override
    public void setHierarchyPosition() {
        this.hierarchyPositionSet = true;
        this.hierarchyPosition = Collections.unmodifiableList(this.hierarchyPosition);
    }

    @Override
    public void setHierarchyPosition(List<Integer> parentHierarcyPosition) {
        this.hierarchyPositionSet = true;
        ArrayList<Integer> hierarchyPosition = new ArrayList<Integer>(parentHierarcyPosition);
        if (Objects.nonNull(this.hierarchyPosition)) {
            hierarchyPosition.addAll(this.hierarchyPosition);
        }
        this.hierarchyPosition = Collections.unmodifiableList(hierarchyPosition);
    }

    @Override
    public void setHyperlinkFrom(PublishingArtifact artifact) {
        this.hyperlinkFrom.add(artifact);
    }

    @Override
    public void setHyperlinkTo(PublishingArtifact artifact) {
        this.hyperlinkTo.add(artifact);
    }

    @Override
    public void setOutlineLevel(int level) {
        this.outlineLevel = level;
    }

    @Override
    public void setProcessed() {
        this.processed = true;
    }

    @Override
    public void setPublishingContent(String content) {
        this.publishingContent = Objects.requireNonNull(content);
    }

    @Override
    public void setStartOfSection() {
        this.startsSection = true;
    }

    @Override
    public Stream<PublishingArtifact> streamHyperlinkedFrom() {
        return this.hyperlinkFrom.stream();
    }

    @Override
    public Stream<PublishingArtifact> streamHyperlinkedTo() {
        return this.hyperlinkTo.stream();
    }
}

